/**
 ********************************************************************************
 *** RoleDocument.java                                                        ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessconfiguration.data;

import net.anotheria.asg.data.AbstractASGDocument;
import java.util.List;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.util.crypt.MD5Util;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.BasicComparable;

public class RoleDocument extends AbstractASGDocument implements Role, IComparable{

	public RoleDocument() {
		super("");
	}

	public RoleDocument(String id){
		super(id);
	}

	public RoleDocument(RoleDocument toClone){
		super(toClone);
	}

	RoleDocument(RoleBuilder builder){
		super("");
		setName(builder.name);
		setPermissions(builder.permissions);
		setContextInitializers(builder.contextInitializers);
		setDescription(builder.description);
	}

	public String getName(){
		return getString(PROP_NAME);
	}

	public void setName(String value){
		setString(PROP_NAME, value);
	}

	public List<String> getPermissions(){
		return copyToStringList(getList(PROP_PERMISSIONS));
	}

	public void setPermissions(List<String> value){
		setList(PROP_PERMISSIONS, copyFromStringList(value));
	}

	public List<String> getContextInitializers(){
		return copyToStringList(getList(PROP_CONTEXT_INITIALIZERS));
	}

	public void setContextInitializers(List<String> value){
		setList(PROP_CONTEXT_INITIALIZERS, copyFromStringList(value));
	}

	public String getDescription(){
		return getString(PROP_DESCRIPTION);
	}

	public void setDescription(String value){
		setString(PROP_DESCRIPTION, value);
	}


	public String toString(){
		String ret = "Role ";
		ret += "["+getId()+"] ";
		ret += "name: "+getName();
		ret += ", ";
		ret += "permissions: "+getPermissions();
		ret += ", ";
		ret += "contextInitializers: "+getContextInitializers();
		ret += ", ";
		ret += "description: "+getDescription();
		return ret;
	}

	public int getPermissionsSize(){
		return getList(PROP_PERMISSIONS).size();
	}

	public void addPermissionsElement(String permission){
		getListPropertyAnyCase(PROP_PERMISSIONS).add(new StringProperty("" + permission, permission));
	} //method

	public void removePermissionsElement(int index){
		getListProperty(PROP_PERMISSIONS).remove(index);
	} //method

	public void swapPermissionsElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_PERMISSIONS).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_PERMISSIONS).get(index2)).getString();
		((StringProperty)getList(PROP_PERMISSIONS).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_PERMISSIONS).get(index2)).setString(tmp1);
	} //method

	public String getPermissionsElement(int index){
		StringProperty p = (StringProperty)getList(PROP_PERMISSIONS).get(index);
		return p.getString();
	} //method

	public int getContextInitializersSize(){
		return getList(PROP_CONTEXT_INITIALIZERS).size();
	}

	public void addContextInitializersElement(String contextInitializer){
		getListPropertyAnyCase(PROP_CONTEXT_INITIALIZERS).add(new StringProperty("" + contextInitializer, contextInitializer));
	} //method

	public void removeContextInitializersElement(int index){
		getListProperty(PROP_CONTEXT_INITIALIZERS).remove(index);
	} //method

	public void swapContextInitializersElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_CONTEXT_INITIALIZERS).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_CONTEXT_INITIALIZERS).get(index2)).getString();
		((StringProperty)getList(PROP_CONTEXT_INITIALIZERS).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_CONTEXT_INITIALIZERS).get(index2)).setString(tmp1);
	} //method

	public String getContextInitializersElement(int index){
		StringProperty p = (StringProperty)getList(PROP_CONTEXT_INITIALIZERS).get(index);
		return p.getString();
	} //method


	public int compareTo(Role comparable){
		return compareTo(comparable, RoleSortType.SORT_BY_DEFAULT);
	}

	public int compareTo(IComparable anotherComparable, int method){
		RoleDocument anotherDoc = (RoleDocument) anotherComparable;
		switch(method){
			case RoleSortType.SORT_BY_ID:
				return BasicComparable.compareString(getId(), anotherDoc.getId());
			case RoleSortType.SORT_BY_NAME:
				return BasicComparable.compareString(getName(), anotherDoc.getName());
			case RoleSortType.SORT_BY_DESCRIPTION:
				return BasicComparable.compareString(getDescription(), anotherDoc.getDescription());
			default:
				throw new RuntimeException("Sort method "+method+" is not supported.");
		}
	}

	public String getDefinedName(){
		return "Role";
	}

	public String getDefinedParentName(){
		return "AnoAccessConfiguration";
	}

	public String getFootprint(){
		StringBuilder footprint = new StringBuilder();
		footprint.append(getName());
		footprint.append(getPermissions());
		footprint.append(getContextInitializers());
		footprint.append(getDescription());
		return MD5Util.getMD5Hash(footprint);
	}

	public boolean equals(Object o){
		return o == this || ((o instanceof RoleDocument) && ((RoleDocument)o).getId().equals(getId()));
	}
}
