/**
 ********************************************************************************
 *** MultiOpRolesContextInitializersAction.java                               ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessconfiguration.action;

import java.util.List;
import java.util.ArrayList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.RoleFactory;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.Role;
import net.anotheria.anosite.gen.anoaccessconfiguration.bean.ContextInitializersElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.anoaccessconfiguration.bean.ContextInitializersQuickAddFB;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.ContextInitializer;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.ContextInitializerSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpRolesContextInitializersAction extends BaseRoleAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("anoaccessconfigurationRoleContextInitializersShow"))
			return anoaccessconfigurationRoleContextInitializersShow(mapping, req, res);
		if (path.equals("anoaccessconfigurationRoleContextInitializersAdd"))
			return anoaccessconfigurationRoleContextInitializersAdd(mapping, req, res);
		if (path.equals("anoaccessconfigurationRoleContextInitializersDelete"))
			return anoaccessconfigurationRoleContextInitializersDelete(mapping, req, res);
		if (path.equals("anoaccessconfigurationRoleContextInitializersMove"))
			return anoaccessconfigurationRoleContextInitializersMove(mapping, req, res);
		if (path.equals("anoaccessconfigurationRoleContextInitializersQuickAdd"))
			return anoaccessconfigurationRoleContextInitializersQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand anoaccessconfigurationRoleContextInitializersShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Role role = getAnoAccessConfigurationService().getRole(id);
		addBeanToRequest(req, "ownerId", id);
		checkRoles(role, req);

		ContextInitializersElementFB form = new ContextInitializersElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(role.getId());
		addBeanToRequest(req, "anoaccessconfigurationRoleContextInitializersElementForm", form);

		ContextInitializersQuickAddFB quickAddForm = new ContextInitializersQuickAddFB() ;
		quickAddForm.setOwnerId(role.getId());
		addBeanToRequest(req, "anoaccessconfigurationRoleContextInitializersQuickAddForm", quickAddForm);


		//link contextInitializer to AnoAccessConfiguration.ContextInitializer
		List<ContextInitializer> contextinitializers = getAnoAccessConfigurationService().getContextInitializers(new ContextInitializerSortType(ContextInitializerSortType.SORT_BY_NAME));
		List<LabelValueBean> contextinitializersValues = new ArrayList<LabelValueBean>(contextinitializers.size());
		for (int i=0; i<contextinitializers.size(); i++){
			net.anotheria.anosite.gen.anoaccessconfiguration.data.ContextInitializer tmp_contextinitializer = (net.anotheria.anosite.gen.anoaccessconfiguration.data.ContextInitializer) contextinitializers.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_contextinitializer.getId(), tmp_contextinitializer.getName()+" ["+tmp_contextinitializer.getId()+"]" );
			contextinitializersValues.add(bean);
		}
		addBeanToRequest(req, "contextinitializerValuesCollection", contextinitializersValues);
		// generate list ...
		int size = role.getContextInitializersSize();
		List<ContextInitializersElementFB> beans = new ArrayList<ContextInitializersElementFB>(size);
		for (int i=0; i<size; i++){
			String value = role.getContextInitializersElement(i);
			ContextInitializersElementFB bean = new ContextInitializersElementFB();
			bean.setOwnerId(role.getId());
			bean.setPosition(i);
			bean.setContextInitializer(value);
			try{
				ContextInitializer tmp_contextinitializer = getAnoAccessConfigurationService().getContextInitializer(value);
				bean.setDescription(tmp_contextinitializer.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand anoaccessconfigurationRoleContextInitializersDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Role roleCurr = getAnoAccessConfigurationService().getRole(id);
		canUpdateRoles(roleCurr, req);
		checkRoles(roleCurr, req);
		int position = getIntParameter(req, "pPosition");
		Role role = getAnoAccessConfigurationService().getRole(id);
		role.removeContextInitializersElement(position);
		getAnoAccessConfigurationService().updateRole(role);
		return anoaccessconfigurationRoleContextInitializersShow(mapping, req, res);
	}

	public ActionCommand anoaccessconfigurationRoleContextInitializersMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		Role role = getAnoAccessConfigurationService().getRole(id);
		canUpdateRoles(role, req);
		checkRoles(role, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(role, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(role, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(role, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(role, position);
		return anoaccessconfigurationRoleContextInitializersShow(mapping, req, res);
	}

	private void moveUp(Role role, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		role.swapContextInitializersElement(position, position-1);
		getAnoAccessConfigurationService().updateRole(role);
	}

	private void moveTop(Role role, int position) throws ASGRuntimeException {
		List<String> targetList = role.getContextInitializers();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		role.setContextInitializers(targetList);
		getAnoAccessConfigurationService().updateRole(role);
	}

	private void moveDown(Role role, int position) throws ASGRuntimeException {
		if (position<role.getContextInitializersSize()-1){
			role.swapContextInitializersElement(position, position+1);
			getAnoAccessConfigurationService().updateRole(role);
		}
	}

	private void moveBottom(Role role, int position) throws ASGRuntimeException {
		List<String> targetList = role.getContextInitializers();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		role.setContextInitializers(targetList);
		getAnoAccessConfigurationService().updateRole(role);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand anoaccessconfigurationRoleContextInitializersAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		ContextInitializersElementFB form = new ContextInitializersElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Role role;
		role = getAnoAccessConfigurationService().getRole(id);
		canUpdateRoles(role, req);
		checkRoles(role, req);
		role.addContextInitializersElement(form.getContextInitializer());
		getAnoAccessConfigurationService().updateRole(role);
		return anoaccessconfigurationRoleContextInitializersShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand anoaccessconfigurationRoleContextInitializersQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		ContextInitializersQuickAddFB form = new ContextInitializersQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Role role;
		role = getAnoAccessConfigurationService().getRole(id);
		canUpdateRoles(role, req);
		checkRoles(role, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				role.addContextInitializersElement(""+i);
			}
		}
		getAnoAccessConfigurationService().updateRole(role);
		return anoaccessconfigurationRoleContextInitializersShow(mapping, req, res);
	}

}
