/**
 ********************************************************************************
 *** BaseContextInitializerAction.java                                        ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessconfiguration.action;

import net.anotheria.anosite.gen.shared.action.BaseAnoAccessConfigurationAction;
import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.ContextInitializer;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseContextInitializerAction extends BaseAnoAccessConfigurationAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Context Initializers";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "AnoAccessConfiguration";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "ContextInitializer";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, ContextInitializer contextinitializer) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("AnoAccessConfiguration.ContextInitializer").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessConfiguration.ContextInitializer", contextinitializer, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessConfiguration.ContextInitializer", contextinitializer, "className");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.className", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessConfiguration.ContextInitializer", contextinitializer, "description");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.description", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockContextInitializers(ContextInitializer contextinitializer, HttpServletRequest req) throws Exception{
		if(contextinitializer instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)contextinitializer;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getAnoAccessConfigurationService().updateContextInitializer( contextinitializer);
			logger.info("Lock-OPERATION, document with id : ["+contextinitializer.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockContextInitializers(ContextInitializer contextinitializer, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(contextinitializer instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)contextinitializer;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getAnoAccessConfigurationService().updateContextInitializer( contextinitializer);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+contextinitializer.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+contextinitializer.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkContextInitializers(ContextInitializer contextinitializer, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = contextinitializer instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)contextinitializer).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)contextinitializer).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockContextInitializers(contextinitializer, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateContextInitializers(ContextInitializer contextinitializer, HttpServletRequest req) throws Exception{
		if(contextinitializer instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)contextinitializer, false, getUserId(req));
		}
		if (isTimeoutReached(contextinitializer)) {
			checkContextInitializers(contextinitializer, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(contextinitializer, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(ContextInitializer contextinitializer){
		if (contextinitializer instanceof LockableObject) {
			LockableObject lock = (LockableObject)contextinitializer;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(ContextInitializer contextinitializer, HttpServletRequest req){
		if (contextinitializer instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)contextinitializer;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
