/**
 ********************************************************************************
 *** BaseBrandFeatureAction.java                                              ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asfeature.action;

import net.anotheria.anosite.gen.shared.action.BaseFeaturesAction;
import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.asfeature.data.BrandFeature;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseBrandFeatureAction extends BaseFeaturesAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "BrandFeatures";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASFeature";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "BrandFeature";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, BrandFeature brandfeature) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASFeature.BrandFeature").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASFeature.BrandFeature", brandfeature, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASFeature.BrandFeature", brandfeature, "enabled");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.enabled", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASFeature.BrandFeature", brandfeature, "activeInProduction");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.activeInProduction", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASFeature.BrandFeature", brandfeature, "obsolete");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.obsolete", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASFeature.BrandFeature", brandfeature, "description");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.description", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASFeature.BrandFeature", brandfeature, "guards");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.guards", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASFeature.BrandFeature", brandfeature, "brands");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.brands", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockBrandFeatures(BrandFeature brandfeature, HttpServletRequest req) throws Exception{
		if(brandfeature instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)brandfeature;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASFeatureService().updateBrandFeature( brandfeature);
			logger.info("Lock-OPERATION, document with id : ["+brandfeature.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockBrandFeatures(BrandFeature brandfeature, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(brandfeature instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)brandfeature;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASFeatureService().updateBrandFeature( brandfeature);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+brandfeature.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+brandfeature.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkBrandFeatures(BrandFeature brandfeature, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = brandfeature instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)brandfeature).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)brandfeature).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockBrandFeatures(brandfeature, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateBrandFeatures(BrandFeature brandfeature, HttpServletRequest req) throws Exception{
		if(brandfeature instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)brandfeature, false, getUserId(req));
		}
		if (isTimeoutReached(brandfeature)) {
			checkBrandFeatures(brandfeature, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(brandfeature, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(BrandFeature brandfeature){
		if (brandfeature instanceof LockableObject) {
			LockableObject lock = (LockableObject)brandfeature;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(BrandFeature brandfeature, HttpServletRequest req){
		if (brandfeature instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)brandfeature;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
