/**
 ********************************************************************************
 *** ASExperimentServiceImpl.java                                             ***
 *** The implementation of the IASExperimentService.                          ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asexperiment.service;

import java.nio.charset.Charset;
import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import net.anotheria.anodoc.data.Module;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;
import net.anotheria.util.slicer.Segment;
import net.anotheria.util.slicer.Slicer;
import net.anotheria.anosite.gen.asexperiment.data.ModuleASExperiment;
import net.anotheria.anosite.gen.shared.service.BasicCMSService;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryResultEntry;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.util.StringUtils;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.asg.util.listener.IModuleListener;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import net.anotheria.anodoc.util.mapper.ObjectMapperUtil;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.anosite.gen.asexperiment.data.Experiment;
import net.anotheria.anosite.gen.asexperiment.data.ExperimentXMLHelper;
import net.anotheria.anosite.gen.asexperiment.data.ExperimentDocument;

public class ASExperimentServiceImpl extends BasicCMSService implements IASExperimentService, IModuleListener{

	// Generated by: class net.anotheria.asg.generator.model.docs.CMSBasedServiceGenerator.generateImplementation

	private static ASExperimentServiceImpl instance;

	private ASExperimentServiceImpl(){
		addServiceListener(new net.anotheria.anosite.cms.listener.CRUDLogListener());
		addModuleListener(ModuleASExperiment.MODULE_ID, this);
	}

	static final ASExperimentServiceImpl getInstance(){
		if (instance==null){
			instance = new ASExperimentServiceImpl();
		}
		return instance;
	}

	private ModuleASExperiment _getModuleASExperiment(){
		return (ModuleASExperiment) getModule(ModuleASExperiment.MODULE_ID);
	}

	@Override
	public void moduleLoaded(Module module){
		firePersistenceChangedEvent();
	}

	@Override
	public List<Experiment> getExperiments(){
		List<Experiment> experiments = new ArrayList<>();
		experiments.addAll(_getModuleASExperiment().getExperiments());
		return experiments;
	}

	@Override
	public List<Experiment> getExperiments(SortType sortType){
		return StaticQuickSorter.sort(getExperiments(), sortType);
	}

	/**
	 * Returns the Experiment objects with the specified ids.
	 */
	public List<Experiment> getExperiments(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<Experiment> all = getExperiments();
		List<Experiment> ret = new ArrayList<>();
		for (Experiment experiment : all){
			if(ids.contains(experiment.getId())){
				ret.add(experiment);
			}
		}
		return ret;
	}

	/**
	 * Returns the Experiment objects with the specified ids, sorted by given sorttype.
	 */
	public List<Experiment> getExperiments(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getExperiments(ids), sortType);
	}

	@Override
	public void deleteExperiment(Experiment experiment){
		deleteExperiment(experiment.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(experiment);
		}
	}

	@Override
	public void deleteExperiment(String id){
		ModuleASExperiment module = _getModuleASExperiment();
		Experiment varValue = hasServiceListeners()?module.getExperiment(id):null;
		module.deleteExperiment(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteExperiments(List<Experiment> list){
		ModuleASExperiment module = _getModuleASExperiment();
		for (Experiment experiment : list){
			module.deleteExperiment(experiment.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public Experiment getExperiment(String id){
		return _getModuleASExperiment().getExperiment(id);
	}

	@Override
	public Experiment importExperiment(Experiment experiment){
		ModuleASExperiment module = _getModuleASExperiment();
		module.importExperiment((ExperimentDocument)experiment);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(experiment);
		}
		return experiment;
	}

	@Override
	public List<Experiment> importExperiments(List<Experiment> list){
		ModuleASExperiment module = _getModuleASExperiment();
		List<Experiment> ret = new ArrayList<>();
		for (Experiment experiment : list){
			Experiment imported = module.importExperiment((ExperimentDocument)experiment);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Experiment experiment : ret)
				fireObjectImportedEvent(experiment);
		}
		return ret;
	}

	@Override
	public Experiment createExperiment(Experiment experiment){
		ModuleASExperiment module = _getModuleASExperiment();
		module.createExperiment((ExperimentDocument)experiment);
		updateModule(module);
		fireObjectCreatedEvent(experiment);
		return experiment;
	}

	@Override
	/**
	 * Creates multiple new Experiment objects.
	 * Returns the created versions.
	 */
	public List<Experiment> createExperiments(List<Experiment> list){
		ModuleASExperiment module = _getModuleASExperiment();
		List<Experiment> ret = new ArrayList<>();
		for (Experiment experiment : list){
			Experiment created = module.createExperiment((ExperimentDocument)experiment);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Experiment experiment : ret)
				fireObjectCreatedEvent(experiment);
		}
		return ret;
	}

	@Override
	public Experiment updateExperiment(Experiment experiment){
		Experiment oldVersion = null;
		ModuleASExperiment module = _getModuleASExperiment();
		if (hasServiceListeners())
			oldVersion = module.getExperiment(experiment.getId());
		module.updateExperiment((ExperimentDocument)experiment);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, experiment);
		}
		return experiment;
	}

	@Override
	public List<Experiment> updateExperiments(List<Experiment> list){
		List<Experiment> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASExperiment module = _getModuleASExperiment();
		for (Experiment experiment : list){
			if (oldList!=null)
				oldList.add(module.getExperiment(experiment.getId()));
			module.updateExperiment((ExperimentDocument)experiment);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<Experiment> getExperimentsByProperty(String propertyName, Object value){
		List<Experiment> allExperiments = getExperiments();
		List<Experiment> ret = new ArrayList<>();
		for (int i=0; i<allExperiments.size(); i++){
			Experiment experiment = allExperiments.get(i);
			try{
				Property property = ((ExperimentDocument)experiment).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(experiment);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(experiment);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(experiment);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<Experiment> getExperimentsByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getExperimentsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on Experiments
	 */
	public QueryResult executeQueryOnExperiments(DocumentQuery query){
		List<Experiment> allExperiments = getExperiments();
		QueryResult result = new QueryResult();
		for (int i=0; i<allExperiments.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allExperiments.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all Experiment objects, where property matches.
	 */
	public List<Experiment> getExperimentsByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<Experiment> ret = new ArrayList<>();
		List<Experiment> src = getExperiments();
		for ( Experiment experiment : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(experiment.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(experiment);
		}
		return ret;
	}

	/**
	 * Returns all Experiment objects, where property matches, sorted
	 */
	public List<Experiment> getExperimentsByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getExperimentsByProperty(property), sortType);
	}

	/**
	 * Returns Experiment objects count.
	 */
	public int getExperimentsCount() {
		return _getModuleASExperiment().getExperiments().size();
	}

	/**
	 * Returns Experiment objects segment.
	 */
	public List<Experiment> getExperiments(Segment aSegment) {
		return Slicer.slice(aSegment, getExperiments()).getSliceData();
	}

	/**
	 * Returns Experiment objects segment, where property matched.
	 */
	public List<Experiment> getExperimentsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<Experiment> ret = new ArrayList<>();
		List<Experiment> src = getExperiments();
		for (Experiment experiment : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(experiment.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(experiment);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns Experiment objects segment, where property matched, sorted.
	 */
	public List<Experiment> getExperimentsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getExperimentsByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchExperiment(final String id, Set<String> addedDocuments, JSONArray data) throws ASExperimentServiceException {
		if (id.isEmpty() || addedDocuments.contains("Experiment" + id))
			return;

		try {
			final ExperimentDocument experiment = _getModuleASExperiment().getExperiment(id);
			addedDocuments.add("Experiment" + id);



			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(experiment);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASExperiment");
			dataObject.put("document", "ASExperiment_Experiment");

			data.put(dataObject);

		}catch(IOException e){
			throw new ASExperimentServiceException ("Problem with fetching data for this Experiment instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASExperimentServiceException ("Problem with fetching data for this Experiment instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredExperiment(final JSONObject data) throws ASExperimentServiceException {
		try {
			String objectData = data.getString("object");
			Experiment experiment = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), ExperimentDocument.class);

			try {
				updateExperiment(experiment);
			}catch(Exception e){
				importExperiment(experiment);
			}
		}catch(JSONException e){
			throw new ASExperimentServiceException("Problem with getting data from json Experiment instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASExperimentServiceException("Problem with parsing data for this Experiment instance :" + e.getMessage());
		}
	}

	public void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ASExperimentServiceException {
		switch(documentName) {
			case DOCUMENT_ASEXPERIMENT_EXPERIMENT:
				saveTransferredExperiment(data);
				break;
			default:
				log.info("There is no correct document: " + documentName + "in this service");
				throw new ASExperimentServiceException("No such document");
		}
	}

	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public QueryResult executeQueryOnAllObjects(DocumentQuery query){
		QueryResult ret = new QueryResult();
		ret.add(executeQueryOnExperiments(query).getEntries());
		return ret;
	} //executeQueryOnAllObjects


	public XMLNode exportExperimentsToXML(){
		XMLNode ret = new XMLNode("Experiments");
		List<Experiment> list = getExperiments();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Experiment object : list)
			ret.addChildNode(ExperimentXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportExperimentsToXML(List<Experiment> list){
		XMLNode ret = new XMLNode("Experiments");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Experiment object : list)
			ret.addChildNode(ExperimentXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportToXML(){
		XMLNode ret = new XMLNode("ASExperiment");

		ret.addChildNode(exportExperimentsToXML());

		return ret;
	}
}
