/**
 ********************************************************************************
 *** ASBrandServiceImpl.java                                                  ***
 *** The implementation of the IASBrandService.                               ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asbrand.service;

import java.nio.charset.Charset;
import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import net.anotheria.anodoc.data.Module;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;
import net.anotheria.util.slicer.Segment;
import net.anotheria.util.slicer.Slicer;
import net.anotheria.anosite.gen.asbrand.data.ModuleASBrand;
import net.anotheria.anosite.gen.shared.service.BasicCMSService;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryResultEntry;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.util.StringUtils;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.asg.util.listener.IModuleListener;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import net.anotheria.anodoc.util.mapper.ObjectMapperUtil;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.anosite.gen.asbrand.data.Brand;
import net.anotheria.anosite.gen.asbrand.data.BrandXMLHelper;
import net.anotheria.anosite.gen.asbrand.data.BrandDocument;
import net.anotheria.anosite.gen.aswebdata.service.ASWebDataServiceException;
import net.anotheria.anosite.gen.assitedata.service.ASSiteDataServiceException;
import net.anotheria.anosite.gen.asresourcedata.service.ASResourceDataServiceException;

public class ASBrandServiceImpl extends BasicCMSService implements IASBrandService, IModuleListener{

	// Generated by: class net.anotheria.asg.generator.model.docs.CMSBasedServiceGenerator.generateImplementation

	private static ASBrandServiceImpl instance;

	private ASBrandServiceImpl(){
		addServiceListener(new net.anotheria.anosite.cms.listener.CRUDLogListener());
		addServiceListener(new net.anotheria.anosite.cms.listener.AutoTransferBrandListener());
		addModuleListener(ModuleASBrand.MODULE_ID, this);
	}

	static final ASBrandServiceImpl getInstance(){
		if (instance==null){
			instance = new ASBrandServiceImpl();
		}
		return instance;
	}

	private ModuleASBrand _getModuleASBrand(){
		return (ModuleASBrand) getModule(ModuleASBrand.MODULE_ID);
	}

	@Override
	public void moduleLoaded(Module module){
		firePersistenceChangedEvent();
	}

	@Override
	public List<Brand> getBrands(){
		List<Brand> brands = new ArrayList<>();
		brands.addAll(_getModuleASBrand().getBrands());
		return brands;
	}

	@Override
	public List<Brand> getBrands(SortType sortType){
		return StaticQuickSorter.sort(getBrands(), sortType);
	}

	/**
	 * Returns the Brand objects with the specified ids.
	 */
	public List<Brand> getBrands(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<Brand> all = getBrands();
		List<Brand> ret = new ArrayList<>();
		for (Brand brand : all){
			if(ids.contains(brand.getId())){
				ret.add(brand);
			}
		}
		return ret;
	}

	/**
	 * Returns the Brand objects with the specified ids, sorted by given sorttype.
	 */
	public List<Brand> getBrands(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getBrands(ids), sortType);
	}

	@Override
	public void deleteBrand(Brand brand){
		deleteBrand(brand.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(brand);
		}
	}

	@Override
	public void deleteBrand(String id){
		ModuleASBrand module = _getModuleASBrand();
		Brand varValue = hasServiceListeners()?module.getBrand(id):null;
		module.deleteBrand(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteBrands(List<Brand> list){
		ModuleASBrand module = _getModuleASBrand();
		for (Brand brand : list){
			module.deleteBrand(brand.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public Brand getBrand(String id){
		return _getModuleASBrand().getBrand(id);
	}

	@Override
	public Brand importBrand(Brand brand){
		ModuleASBrand module = _getModuleASBrand();
		module.importBrand((BrandDocument)brand);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(brand);
		}
		return brand;
	}

	@Override
	public List<Brand> importBrands(List<Brand> list){
		ModuleASBrand module = _getModuleASBrand();
		List<Brand> ret = new ArrayList<>();
		for (Brand brand : list){
			Brand imported = module.importBrand((BrandDocument)brand);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Brand brand : ret)
				fireObjectImportedEvent(brand);
		}
		return ret;
	}

	@Override
	public Brand createBrand(Brand brand){
		ModuleASBrand module = _getModuleASBrand();
		module.createBrand((BrandDocument)brand);
		updateModule(module);
		fireObjectCreatedEvent(brand);
		return brand;
	}

	@Override
	/**
	 * Creates multiple new Brand objects.
	 * Returns the created versions.
	 */
	public List<Brand> createBrands(List<Brand> list){
		ModuleASBrand module = _getModuleASBrand();
		List<Brand> ret = new ArrayList<>();
		for (Brand brand : list){
			Brand created = module.createBrand((BrandDocument)brand);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Brand brand : ret)
				fireObjectCreatedEvent(brand);
		}
		return ret;
	}

	@Override
	public Brand updateBrand(Brand brand){
		Brand oldVersion = null;
		ModuleASBrand module = _getModuleASBrand();
		if (hasServiceListeners())
			oldVersion = module.getBrand(brand.getId());
		module.updateBrand((BrandDocument)brand);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, brand);
		}
		return brand;
	}

	@Override
	public List<Brand> updateBrands(List<Brand> list){
		List<Brand> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASBrand module = _getModuleASBrand();
		for (Brand brand : list){
			if (oldList!=null)
				oldList.add(module.getBrand(brand.getId()));
			module.updateBrand((BrandDocument)brand);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<Brand> getBrandsByProperty(String propertyName, Object value){
		List<Brand> allBrands = getBrands();
		List<Brand> ret = new ArrayList<>();
		for (int i=0; i<allBrands.size(); i++){
			Brand brand = allBrands.get(i);
			try{
				Property property = ((BrandDocument)brand).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(brand);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(brand);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(brand);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<Brand> getBrandsByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getBrandsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on Brands
	 */
	public QueryResult executeQueryOnBrands(DocumentQuery query){
		List<Brand> allBrands = getBrands();
		QueryResult result = new QueryResult();
		for (int i=0; i<allBrands.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allBrands.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all Brand objects, where property matches.
	 */
	public List<Brand> getBrandsByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<Brand> ret = new ArrayList<>();
		List<Brand> src = getBrands();
		for ( Brand brand : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(brand.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(brand);
		}
		return ret;
	}

	/**
	 * Returns all Brand objects, where property matches, sorted
	 */
	public List<Brand> getBrandsByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getBrandsByProperty(property), sortType);
	}

	/**
	 * Returns Brand objects count.
	 */
	public int getBrandsCount() {
		return _getModuleASBrand().getBrands().size();
	}

	/**
	 * Returns Brand objects segment.
	 */
	public List<Brand> getBrands(Segment aSegment) {
		return Slicer.slice(aSegment, getBrands()).getSliceData();
	}

	/**
	 * Returns Brand objects segment, where property matched.
	 */
	public List<Brand> getBrandsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<Brand> ret = new ArrayList<>();
		List<Brand> src = getBrands();
		for (Brand brand : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(brand.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(brand);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns Brand objects segment, where property matched, sorted.
	 */
	public List<Brand> getBrandsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getBrandsByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchBrand(final String id, Set<String> addedDocuments, JSONArray data) throws ASBrandServiceException {
		if (id.isEmpty() || addedDocuments.contains("Brand" + id))
			return;

		try {
			final BrandDocument brand = _getModuleASBrand().getBrand(id);
			addedDocuments.add("Brand" + id);


			if (!brand.getLocalizations().isEmpty()) {
				for (String aLocalizationsId: brand.getLocalizations()) {
					getASResourceDataService().fetchLocalizationBundle(aLocalizationsId, addedDocuments, data);
				}
			}
			if (!brand.getMediaLinks().isEmpty()) {
				for (String aMediaLinksId: brand.getMediaLinks()) {
					getASSiteDataService().fetchMediaLink(aMediaLinksId, addedDocuments, data);
				}
			}
			if (!brand.getAttributes().isEmpty()) {
				for (String aAttributesId: brand.getAttributes()) {
					getASWebDataService().fetchAttribute(aAttributesId, addedDocuments, data);
				}
			}

			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(brand);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASBrand");
			dataObject.put("document", "ASBrand_Brand");

			data.put(dataObject);

		}catch(ASWebDataServiceException e){
			throw new ASBrandServiceException("Problem with getting document from ASWebData" + e.getMessage());
		}catch(ASSiteDataServiceException e){
			throw new ASBrandServiceException("Problem with getting document from ASSiteData" + e.getMessage());
		}catch(ASResourceDataServiceException e){
			throw new ASBrandServiceException("Problem with getting document from ASResourceData" + e.getMessage());
		}catch(IOException e){
			throw new ASBrandServiceException ("Problem with fetching data for this Brand instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASBrandServiceException ("Problem with fetching data for this Brand instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredBrand(final JSONObject data) throws ASBrandServiceException {
		try {
			String objectData = data.getString("object");
			Brand brand = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), BrandDocument.class);

			try {
				updateBrand(brand);
			}catch(Exception e){
				importBrand(brand);
			}
		}catch(JSONException e){
			throw new ASBrandServiceException("Problem with getting data from json Brand instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASBrandServiceException("Problem with parsing data for this Brand instance :" + e.getMessage());
		}
	}

	public void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ASBrandServiceException {
		switch(documentName) {
			case DOCUMENT_ASBRAND_BRAND:
				saveTransferredBrand(data);
				break;
			default:
				log.info("There is no correct document: " + documentName + "in this service");
				throw new ASBrandServiceException("No such document");
		}
	}

	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public QueryResult executeQueryOnAllObjects(DocumentQuery query){
		QueryResult ret = new QueryResult();
		ret.add(executeQueryOnBrands(query).getEntries());
		return ret;
	} //executeQueryOnAllObjects


	public XMLNode exportBrandsToXML(){
		XMLNode ret = new XMLNode("Brands");
		List<Brand> list = getBrands();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Brand object : list)
			ret.addChildNode(BrandXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportBrandsToXML(List<Brand> list){
		XMLNode ret = new XMLNode("Brands");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Brand object : list)
			ret.addChildNode(BrandXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportToXML(){
		XMLNode ret = new XMLNode("ASBrand");

		ret.addChildNode(exportBrandsToXML());

		return ret;
	}
}
