/**
 ********************************************************************************
 *** MultiOpBrandFeaturesBrandsAction.java                                    ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asfeature.action;

import java.util.List;
import java.util.ArrayList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asfeature.data.BrandFeatureFactory;
import net.anotheria.anosite.gen.asfeature.data.BrandFeature;
import net.anotheria.anosite.gen.asfeature.bean.BrandsElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.asfeature.bean.BrandsQuickAddFB;
import net.anotheria.anosite.gen.asbrand.data.Brand;
import net.anotheria.anosite.gen.asbrand.data.BrandSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpBrandFeaturesBrandsAction extends BaseBrandFeatureAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("asfeatureBrandFeatureBrandsShow"))
			return asfeatureBrandFeatureBrandsShow(mapping, req, res);
		if (path.equals("asfeatureBrandFeatureBrandsAdd"))
			return asfeatureBrandFeatureBrandsAdd(mapping, req, res);
		if (path.equals("asfeatureBrandFeatureBrandsDelete"))
			return asfeatureBrandFeatureBrandsDelete(mapping, req, res);
		if (path.equals("asfeatureBrandFeatureBrandsMove"))
			return asfeatureBrandFeatureBrandsMove(mapping, req, res);
		if (path.equals("asfeatureBrandFeatureBrandsQuickAdd"))
			return asfeatureBrandFeatureBrandsQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand asfeatureBrandFeatureBrandsShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		BrandFeature brandfeature = getASFeatureService().getBrandFeature(id);
		addBeanToRequest(req, "ownerId", id);
		checkBrandFeatures(brandfeature, req);

		BrandsElementFB form = new BrandsElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(brandfeature.getId());
		addBeanToRequest(req, "asfeatureBrandFeatureBrandsElementForm", form);

		BrandsQuickAddFB quickAddForm = new BrandsQuickAddFB() ;
		quickAddForm.setOwnerId(brandfeature.getId());
		addBeanToRequest(req, "asfeatureBrandFeatureBrandsQuickAddForm", quickAddForm);


		//link brand to ASBrand.Brand
		List<Brand> brands = getASBrandService().getBrands(new BrandSortType(BrandSortType.SORT_BY_NAME));
		List<LabelValueBean> brandsValues = new ArrayList<LabelValueBean>(brands.size());
		for (int i=0; i<brands.size(); i++){
			net.anotheria.anosite.gen.asbrand.data.Brand tmp_brand = (net.anotheria.anosite.gen.asbrand.data.Brand) brands.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_brand.getId(), tmp_brand.getName()+" ["+tmp_brand.getId()+"]" );
			brandsValues.add(bean);
		}
		addBeanToRequest(req, "brandValuesCollection", brandsValues);
		// generate list ...
		int size = brandfeature.getBrandsSize();
		List<BrandsElementFB> beans = new ArrayList<BrandsElementFB>(size);
		for (int i=0; i<size; i++){
			String value = brandfeature.getBrandsElement(i);
			BrandsElementFB bean = new BrandsElementFB();
			bean.setOwnerId(brandfeature.getId());
			bean.setPosition(i);
			bean.setBrand(value);
			try{
				Brand tmp_brand = getASBrandService().getBrand(value);
				bean.setDescription(tmp_brand.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand asfeatureBrandFeatureBrandsDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		BrandFeature brandfeatureCurr = getASFeatureService().getBrandFeature(id);
		canUpdateBrandFeatures(brandfeatureCurr, req);
		checkBrandFeatures(brandfeatureCurr, req);
		int position = getIntParameter(req, "pPosition");
		BrandFeature brandfeature = getASFeatureService().getBrandFeature(id);
		brandfeature.removeBrandsElement(position);
		getASFeatureService().updateBrandFeature(brandfeature);
		return asfeatureBrandFeatureBrandsShow(mapping, req, res);
	}

	public ActionCommand asfeatureBrandFeatureBrandsMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		BrandFeature brandfeature = getASFeatureService().getBrandFeature(id);
		canUpdateBrandFeatures(brandfeature, req);
		checkBrandFeatures(brandfeature, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(brandfeature, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(brandfeature, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(brandfeature, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(brandfeature, position);
		return asfeatureBrandFeatureBrandsShow(mapping, req, res);
	}

	private void moveUp(BrandFeature brandfeature, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		brandfeature.swapBrandsElement(position, position-1);
		getASFeatureService().updateBrandFeature(brandfeature);
	}

	private void moveTop(BrandFeature brandfeature, int position) throws ASGRuntimeException {
		List<String> targetList = brandfeature.getBrands();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		brandfeature.setBrands(targetList);
		getASFeatureService().updateBrandFeature(brandfeature);
	}

	private void moveDown(BrandFeature brandfeature, int position) throws ASGRuntimeException {
		if (position<brandfeature.getBrandsSize()-1){
			brandfeature.swapBrandsElement(position, position+1);
			getASFeatureService().updateBrandFeature(brandfeature);
		}
	}

	private void moveBottom(BrandFeature brandfeature, int position) throws ASGRuntimeException {
		List<String> targetList = brandfeature.getBrands();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		brandfeature.setBrands(targetList);
		getASFeatureService().updateBrandFeature(brandfeature);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand asfeatureBrandFeatureBrandsAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		BrandsElementFB form = new BrandsElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		BrandFeature brandfeature;
		brandfeature = getASFeatureService().getBrandFeature(id);
		canUpdateBrandFeatures(brandfeature, req);
		checkBrandFeatures(brandfeature, req);
		brandfeature.addBrandsElement(form.getBrand());
		getASFeatureService().updateBrandFeature(brandfeature);
		return asfeatureBrandFeatureBrandsShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand asfeatureBrandFeatureBrandsQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		BrandsQuickAddFB form = new BrandsQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		BrandFeature brandfeature;
		brandfeature = getASFeatureService().getBrandFeature(id);
		canUpdateBrandFeatures(brandfeature, req);
		checkBrandFeatures(brandfeature, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				brandfeature.addBrandsElement(""+i);
			}
		}
		getASFeatureService().updateBrandFeature(brandfeature);
		return asfeatureBrandFeatureBrandsShow(mapping, req, res);
	}

}
