/**
 ********************************************************************************
 *** ASCustomDataServiceImpl.java                                             ***
 *** The implementation of the IASCustomDataService.                          ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.ascustomdata.service;

import java.nio.charset.Charset;
import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import net.anotheria.anodoc.data.Module;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;
import net.anotheria.util.slicer.Segment;
import net.anotheria.util.slicer.Slicer;
import net.anotheria.anosite.gen.ascustomdata.data.ModuleASCustomData;
import net.anotheria.anosite.gen.shared.service.BasicCMSService;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryResultEntry;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.util.StringUtils;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.asg.util.listener.IModuleListener;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import net.anotheria.anodoc.util.mapper.ObjectMapperUtil;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.anosite.gen.ascustomdata.data.CustomBoxType;
import net.anotheria.anosite.gen.ascustomdata.data.CustomBoxTypeXMLHelper;
import net.anotheria.anosite.gen.ascustomdata.data.CustomBoxTypeDocument;
import net.anotheria.anosite.gen.ascustomdata.data.CustomBoxHandlerDef;
import net.anotheria.anosite.gen.ascustomdata.data.CustomBoxHandlerDefXMLHelper;
import net.anotheria.anosite.gen.ascustomdata.data.CustomBoxHandlerDefDocument;
import net.anotheria.anosite.gen.ascustomdata.data.CustomGuardDef;
import net.anotheria.anosite.gen.ascustomdata.data.CustomGuardDefXMLHelper;
import net.anotheria.anosite.gen.ascustomdata.data.CustomGuardDefDocument;

public class ASCustomDataServiceImpl extends BasicCMSService implements IASCustomDataService, IModuleListener{

	// Generated by: class net.anotheria.asg.generator.model.docs.CMSBasedServiceGenerator.generateImplementation

	private static ASCustomDataServiceImpl instance;

	private ASCustomDataServiceImpl(){
		addServiceListener(new net.anotheria.anosite.cms.listener.CRUDLogListener());
		addModuleListener(ModuleASCustomData.MODULE_ID, this);
	}

	static final ASCustomDataServiceImpl getInstance(){
		if (instance==null){
			instance = new ASCustomDataServiceImpl();
		}
		return instance;
	}

	private ModuleASCustomData _getModuleASCustomData(){
		return (ModuleASCustomData) getModule(ModuleASCustomData.MODULE_ID);
	}

	@Override
	public void moduleLoaded(Module module){
		firePersistenceChangedEvent();
	}

	@Override
	public List<CustomBoxType> getCustomBoxTypes(){
		List<CustomBoxType> customboxtypes = new ArrayList<>();
		customboxtypes.addAll(_getModuleASCustomData().getCustomBoxTypes());
		return customboxtypes;
	}

	@Override
	public List<CustomBoxType> getCustomBoxTypes(SortType sortType){
		return StaticQuickSorter.sort(getCustomBoxTypes(), sortType);
	}

	/**
	 * Returns the CustomBoxType objects with the specified ids.
	 */
	public List<CustomBoxType> getCustomBoxTypes(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<CustomBoxType> all = getCustomBoxTypes();
		List<CustomBoxType> ret = new ArrayList<>();
		for (CustomBoxType customboxtype : all){
			if(ids.contains(customboxtype.getId())){
				ret.add(customboxtype);
			}
		}
		return ret;
	}

	/**
	 * Returns the CustomBoxType objects with the specified ids, sorted by given sorttype.
	 */
	public List<CustomBoxType> getCustomBoxTypes(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getCustomBoxTypes(ids), sortType);
	}

	@Override
	public void deleteCustomBoxType(CustomBoxType customboxtype){
		deleteCustomBoxType(customboxtype.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(customboxtype);
		}
	}

	@Override
	public void deleteCustomBoxType(String id){
		ModuleASCustomData module = _getModuleASCustomData();
		CustomBoxType varValue = hasServiceListeners()?module.getCustomBoxType(id):null;
		module.deleteCustomBoxType(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteCustomBoxTypes(List<CustomBoxType> list){
		ModuleASCustomData module = _getModuleASCustomData();
		for (CustomBoxType customboxtype : list){
			module.deleteCustomBoxType(customboxtype.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public CustomBoxType getCustomBoxType(String id){
		return _getModuleASCustomData().getCustomBoxType(id);
	}

	@Override
	public CustomBoxType importCustomBoxType(CustomBoxType customboxtype){
		ModuleASCustomData module = _getModuleASCustomData();
		module.importCustomBoxType((CustomBoxTypeDocument)customboxtype);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(customboxtype);
		}
		return customboxtype;
	}

	@Override
	public List<CustomBoxType> importCustomBoxTypes(List<CustomBoxType> list){
		ModuleASCustomData module = _getModuleASCustomData();
		List<CustomBoxType> ret = new ArrayList<>();
		for (CustomBoxType customboxtype : list){
			CustomBoxType imported = module.importCustomBoxType((CustomBoxTypeDocument)customboxtype);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (CustomBoxType customboxtype : ret)
				fireObjectImportedEvent(customboxtype);
		}
		return ret;
	}

	@Override
	public CustomBoxType createCustomBoxType(CustomBoxType customboxtype){
		ModuleASCustomData module = _getModuleASCustomData();
		module.createCustomBoxType((CustomBoxTypeDocument)customboxtype);
		updateModule(module);
		fireObjectCreatedEvent(customboxtype);
		return customboxtype;
	}

	@Override
	/**
	 * Creates multiple new CustomBoxType objects.
	 * Returns the created versions.
	 */
	public List<CustomBoxType> createCustomBoxTypes(List<CustomBoxType> list){
		ModuleASCustomData module = _getModuleASCustomData();
		List<CustomBoxType> ret = new ArrayList<>();
		for (CustomBoxType customboxtype : list){
			CustomBoxType created = module.createCustomBoxType((CustomBoxTypeDocument)customboxtype);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (CustomBoxType customboxtype : ret)
				fireObjectCreatedEvent(customboxtype);
		}
		return ret;
	}

	@Override
	public CustomBoxType updateCustomBoxType(CustomBoxType customboxtype){
		CustomBoxType oldVersion = null;
		ModuleASCustomData module = _getModuleASCustomData();
		if (hasServiceListeners())
			oldVersion = module.getCustomBoxType(customboxtype.getId());
		module.updateCustomBoxType((CustomBoxTypeDocument)customboxtype);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, customboxtype);
		}
		return customboxtype;
	}

	@Override
	public List<CustomBoxType> updateCustomBoxTypes(List<CustomBoxType> list){
		List<CustomBoxType> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASCustomData module = _getModuleASCustomData();
		for (CustomBoxType customboxtype : list){
			if (oldList!=null)
				oldList.add(module.getCustomBoxType(customboxtype.getId()));
			module.updateCustomBoxType((CustomBoxTypeDocument)customboxtype);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<CustomBoxType> getCustomBoxTypesByProperty(String propertyName, Object value){
		List<CustomBoxType> allCustomBoxTypes = getCustomBoxTypes();
		List<CustomBoxType> ret = new ArrayList<>();
		for (int i=0; i<allCustomBoxTypes.size(); i++){
			CustomBoxType customboxtype = allCustomBoxTypes.get(i);
			try{
				Property property = ((CustomBoxTypeDocument)customboxtype).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(customboxtype);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(customboxtype);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(customboxtype);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<CustomBoxType> getCustomBoxTypesByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getCustomBoxTypesByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on CustomBoxTypes
	 */
	public QueryResult executeQueryOnCustomBoxTypes(DocumentQuery query){
		List<CustomBoxType> allCustomBoxTypes = getCustomBoxTypes();
		QueryResult result = new QueryResult();
		for (int i=0; i<allCustomBoxTypes.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allCustomBoxTypes.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all CustomBoxType objects, where property matches.
	 */
	public List<CustomBoxType> getCustomBoxTypesByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<CustomBoxType> ret = new ArrayList<>();
		List<CustomBoxType> src = getCustomBoxTypes();
		for ( CustomBoxType customboxtype : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(customboxtype.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(customboxtype);
		}
		return ret;
	}

	/**
	 * Returns all CustomBoxType objects, where property matches, sorted
	 */
	public List<CustomBoxType> getCustomBoxTypesByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getCustomBoxTypesByProperty(property), sortType);
	}

	/**
	 * Returns CustomBoxType objects count.
	 */
	public int getCustomBoxTypesCount() {
		return _getModuleASCustomData().getCustomBoxTypes().size();
	}

	/**
	 * Returns CustomBoxType objects segment.
	 */
	public List<CustomBoxType> getCustomBoxTypes(Segment aSegment) {
		return Slicer.slice(aSegment, getCustomBoxTypes()).getSliceData();
	}

	/**
	 * Returns CustomBoxType objects segment, where property matched.
	 */
	public List<CustomBoxType> getCustomBoxTypesByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<CustomBoxType> ret = new ArrayList<>();
		List<CustomBoxType> src = getCustomBoxTypes();
		for (CustomBoxType customboxtype : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(customboxtype.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(customboxtype);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns CustomBoxType objects segment, where property matched, sorted.
	 */
	public List<CustomBoxType> getCustomBoxTypesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getCustomBoxTypesByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchCustomBoxType(final String id, Set<String> addedDocuments, JSONArray data) throws ASCustomDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("CustomBoxType" + id))
			return;

		try {
			final CustomBoxTypeDocument customboxtype = _getModuleASCustomData().getCustomBoxType(id);
			addedDocuments.add("CustomBoxType" + id);



			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(customboxtype);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASCustomData");
			dataObject.put("document", "ASCustomData_CustomBoxType");

			data.put(dataObject);

		}catch(IOException e){
			throw new ASCustomDataServiceException ("Problem with fetching data for this CustomBoxType instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASCustomDataServiceException ("Problem with fetching data for this CustomBoxType instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredCustomBoxType(final JSONObject data) throws ASCustomDataServiceException {
		try {
			String objectData = data.getString("object");
			CustomBoxType customboxtype = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), CustomBoxTypeDocument.class);

			try {
				updateCustomBoxType(customboxtype);
			}catch(Exception e){
				importCustomBoxType(customboxtype);
			}
		}catch(JSONException e){
			throw new ASCustomDataServiceException("Problem with getting data from json CustomBoxType instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASCustomDataServiceException("Problem with parsing data for this CustomBoxType instance :" + e.getMessage());
		}
	}

	@Override
	public List<CustomBoxHandlerDef> getCustomBoxHandlerDefs(){
		List<CustomBoxHandlerDef> customboxhandlerdefs = new ArrayList<>();
		customboxhandlerdefs.addAll(_getModuleASCustomData().getCustomBoxHandlerDefs());
		return customboxhandlerdefs;
	}

	@Override
	public List<CustomBoxHandlerDef> getCustomBoxHandlerDefs(SortType sortType){
		return StaticQuickSorter.sort(getCustomBoxHandlerDefs(), sortType);
	}

	/**
	 * Returns the CustomBoxHandlerDef objects with the specified ids.
	 */
	public List<CustomBoxHandlerDef> getCustomBoxHandlerDefs(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<CustomBoxHandlerDef> all = getCustomBoxHandlerDefs();
		List<CustomBoxHandlerDef> ret = new ArrayList<>();
		for (CustomBoxHandlerDef customboxhandlerdef : all){
			if(ids.contains(customboxhandlerdef.getId())){
				ret.add(customboxhandlerdef);
			}
		}
		return ret;
	}

	/**
	 * Returns the CustomBoxHandlerDef objects with the specified ids, sorted by given sorttype.
	 */
	public List<CustomBoxHandlerDef> getCustomBoxHandlerDefs(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getCustomBoxHandlerDefs(ids), sortType);
	}

	@Override
	public void deleteCustomBoxHandlerDef(CustomBoxHandlerDef customboxhandlerdef){
		deleteCustomBoxHandlerDef(customboxhandlerdef.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(customboxhandlerdef);
		}
	}

	@Override
	public void deleteCustomBoxHandlerDef(String id){
		ModuleASCustomData module = _getModuleASCustomData();
		CustomBoxHandlerDef varValue = hasServiceListeners()?module.getCustomBoxHandlerDef(id):null;
		module.deleteCustomBoxHandlerDef(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteCustomBoxHandlerDefs(List<CustomBoxHandlerDef> list){
		ModuleASCustomData module = _getModuleASCustomData();
		for (CustomBoxHandlerDef customboxhandlerdef : list){
			module.deleteCustomBoxHandlerDef(customboxhandlerdef.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public CustomBoxHandlerDef getCustomBoxHandlerDef(String id){
		return _getModuleASCustomData().getCustomBoxHandlerDef(id);
	}

	@Override
	public CustomBoxHandlerDef importCustomBoxHandlerDef(CustomBoxHandlerDef customboxhandlerdef){
		ModuleASCustomData module = _getModuleASCustomData();
		module.importCustomBoxHandlerDef((CustomBoxHandlerDefDocument)customboxhandlerdef);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(customboxhandlerdef);
		}
		return customboxhandlerdef;
	}

	@Override
	public List<CustomBoxHandlerDef> importCustomBoxHandlerDefs(List<CustomBoxHandlerDef> list){
		ModuleASCustomData module = _getModuleASCustomData();
		List<CustomBoxHandlerDef> ret = new ArrayList<>();
		for (CustomBoxHandlerDef customboxhandlerdef : list){
			CustomBoxHandlerDef imported = module.importCustomBoxHandlerDef((CustomBoxHandlerDefDocument)customboxhandlerdef);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (CustomBoxHandlerDef customboxhandlerdef : ret)
				fireObjectImportedEvent(customboxhandlerdef);
		}
		return ret;
	}

	@Override
	public CustomBoxHandlerDef createCustomBoxHandlerDef(CustomBoxHandlerDef customboxhandlerdef){
		ModuleASCustomData module = _getModuleASCustomData();
		module.createCustomBoxHandlerDef((CustomBoxHandlerDefDocument)customboxhandlerdef);
		updateModule(module);
		fireObjectCreatedEvent(customboxhandlerdef);
		return customboxhandlerdef;
	}

	@Override
	/**
	 * Creates multiple new CustomBoxHandlerDef objects.
	 * Returns the created versions.
	 */
	public List<CustomBoxHandlerDef> createCustomBoxHandlerDefs(List<CustomBoxHandlerDef> list){
		ModuleASCustomData module = _getModuleASCustomData();
		List<CustomBoxHandlerDef> ret = new ArrayList<>();
		for (CustomBoxHandlerDef customboxhandlerdef : list){
			CustomBoxHandlerDef created = module.createCustomBoxHandlerDef((CustomBoxHandlerDefDocument)customboxhandlerdef);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (CustomBoxHandlerDef customboxhandlerdef : ret)
				fireObjectCreatedEvent(customboxhandlerdef);
		}
		return ret;
	}

	@Override
	public CustomBoxHandlerDef updateCustomBoxHandlerDef(CustomBoxHandlerDef customboxhandlerdef){
		CustomBoxHandlerDef oldVersion = null;
		ModuleASCustomData module = _getModuleASCustomData();
		if (hasServiceListeners())
			oldVersion = module.getCustomBoxHandlerDef(customboxhandlerdef.getId());
		module.updateCustomBoxHandlerDef((CustomBoxHandlerDefDocument)customboxhandlerdef);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, customboxhandlerdef);
		}
		return customboxhandlerdef;
	}

	@Override
	public List<CustomBoxHandlerDef> updateCustomBoxHandlerDefs(List<CustomBoxHandlerDef> list){
		List<CustomBoxHandlerDef> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASCustomData module = _getModuleASCustomData();
		for (CustomBoxHandlerDef customboxhandlerdef : list){
			if (oldList!=null)
				oldList.add(module.getCustomBoxHandlerDef(customboxhandlerdef.getId()));
			module.updateCustomBoxHandlerDef((CustomBoxHandlerDefDocument)customboxhandlerdef);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<CustomBoxHandlerDef> getCustomBoxHandlerDefsByProperty(String propertyName, Object value){
		List<CustomBoxHandlerDef> allCustomBoxHandlerDefs = getCustomBoxHandlerDefs();
		List<CustomBoxHandlerDef> ret = new ArrayList<>();
		for (int i=0; i<allCustomBoxHandlerDefs.size(); i++){
			CustomBoxHandlerDef customboxhandlerdef = allCustomBoxHandlerDefs.get(i);
			try{
				Property property = ((CustomBoxHandlerDefDocument)customboxhandlerdef).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(customboxhandlerdef);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(customboxhandlerdef);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(customboxhandlerdef);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<CustomBoxHandlerDef> getCustomBoxHandlerDefsByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getCustomBoxHandlerDefsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on CustomBoxHandlerDefs
	 */
	public QueryResult executeQueryOnCustomBoxHandlerDefs(DocumentQuery query){
		List<CustomBoxHandlerDef> allCustomBoxHandlerDefs = getCustomBoxHandlerDefs();
		QueryResult result = new QueryResult();
		for (int i=0; i<allCustomBoxHandlerDefs.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allCustomBoxHandlerDefs.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all CustomBoxHandlerDef objects, where property matches.
	 */
	public List<CustomBoxHandlerDef> getCustomBoxHandlerDefsByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<CustomBoxHandlerDef> ret = new ArrayList<>();
		List<CustomBoxHandlerDef> src = getCustomBoxHandlerDefs();
		for ( CustomBoxHandlerDef customboxhandlerdef : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(customboxhandlerdef.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(customboxhandlerdef);
		}
		return ret;
	}

	/**
	 * Returns all CustomBoxHandlerDef objects, where property matches, sorted
	 */
	public List<CustomBoxHandlerDef> getCustomBoxHandlerDefsByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getCustomBoxHandlerDefsByProperty(property), sortType);
	}

	/**
	 * Returns CustomBoxHandlerDef objects count.
	 */
	public int getCustomBoxHandlerDefsCount() {
		return _getModuleASCustomData().getCustomBoxHandlerDefs().size();
	}

	/**
	 * Returns CustomBoxHandlerDef objects segment.
	 */
	public List<CustomBoxHandlerDef> getCustomBoxHandlerDefs(Segment aSegment) {
		return Slicer.slice(aSegment, getCustomBoxHandlerDefs()).getSliceData();
	}

	/**
	 * Returns CustomBoxHandlerDef objects segment, where property matched.
	 */
	public List<CustomBoxHandlerDef> getCustomBoxHandlerDefsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<CustomBoxHandlerDef> ret = new ArrayList<>();
		List<CustomBoxHandlerDef> src = getCustomBoxHandlerDefs();
		for (CustomBoxHandlerDef customboxhandlerdef : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(customboxhandlerdef.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(customboxhandlerdef);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns CustomBoxHandlerDef objects segment, where property matched, sorted.
	 */
	public List<CustomBoxHandlerDef> getCustomBoxHandlerDefsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getCustomBoxHandlerDefsByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchCustomBoxHandlerDef(final String id, Set<String> addedDocuments, JSONArray data) throws ASCustomDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("CustomBoxHandlerDef" + id))
			return;

		try {
			final CustomBoxHandlerDefDocument customboxhandlerdef = _getModuleASCustomData().getCustomBoxHandlerDef(id);
			addedDocuments.add("CustomBoxHandlerDef" + id);



			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(customboxhandlerdef);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASCustomData");
			dataObject.put("document", "ASCustomData_CustomBoxHandlerDef");

			data.put(dataObject);

		}catch(IOException e){
			throw new ASCustomDataServiceException ("Problem with fetching data for this CustomBoxHandlerDef instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASCustomDataServiceException ("Problem with fetching data for this CustomBoxHandlerDef instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredCustomBoxHandlerDef(final JSONObject data) throws ASCustomDataServiceException {
		try {
			String objectData = data.getString("object");
			CustomBoxHandlerDef customboxhandlerdef = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), CustomBoxHandlerDefDocument.class);

			try {
				updateCustomBoxHandlerDef(customboxhandlerdef);
			}catch(Exception e){
				importCustomBoxHandlerDef(customboxhandlerdef);
			}
		}catch(JSONException e){
			throw new ASCustomDataServiceException("Problem with getting data from json CustomBoxHandlerDef instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASCustomDataServiceException("Problem with parsing data for this CustomBoxHandlerDef instance :" + e.getMessage());
		}
	}

	@Override
	public List<CustomGuardDef> getCustomGuardDefs(){
		List<CustomGuardDef> customguarddefs = new ArrayList<>();
		customguarddefs.addAll(_getModuleASCustomData().getCustomGuardDefs());
		return customguarddefs;
	}

	@Override
	public List<CustomGuardDef> getCustomGuardDefs(SortType sortType){
		return StaticQuickSorter.sort(getCustomGuardDefs(), sortType);
	}

	/**
	 * Returns the CustomGuardDef objects with the specified ids.
	 */
	public List<CustomGuardDef> getCustomGuardDefs(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<CustomGuardDef> all = getCustomGuardDefs();
		List<CustomGuardDef> ret = new ArrayList<>();
		for (CustomGuardDef customguarddef : all){
			if(ids.contains(customguarddef.getId())){
				ret.add(customguarddef);
			}
		}
		return ret;
	}

	/**
	 * Returns the CustomGuardDef objects with the specified ids, sorted by given sorttype.
	 */
	public List<CustomGuardDef> getCustomGuardDefs(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getCustomGuardDefs(ids), sortType);
	}

	@Override
	public void deleteCustomGuardDef(CustomGuardDef customguarddef){
		deleteCustomGuardDef(customguarddef.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(customguarddef);
		}
	}

	@Override
	public void deleteCustomGuardDef(String id){
		ModuleASCustomData module = _getModuleASCustomData();
		CustomGuardDef varValue = hasServiceListeners()?module.getCustomGuardDef(id):null;
		module.deleteCustomGuardDef(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteCustomGuardDefs(List<CustomGuardDef> list){
		ModuleASCustomData module = _getModuleASCustomData();
		for (CustomGuardDef customguarddef : list){
			module.deleteCustomGuardDef(customguarddef.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public CustomGuardDef getCustomGuardDef(String id){
		return _getModuleASCustomData().getCustomGuardDef(id);
	}

	@Override
	public CustomGuardDef importCustomGuardDef(CustomGuardDef customguarddef){
		ModuleASCustomData module = _getModuleASCustomData();
		module.importCustomGuardDef((CustomGuardDefDocument)customguarddef);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(customguarddef);
		}
		return customguarddef;
	}

	@Override
	public List<CustomGuardDef> importCustomGuardDefs(List<CustomGuardDef> list){
		ModuleASCustomData module = _getModuleASCustomData();
		List<CustomGuardDef> ret = new ArrayList<>();
		for (CustomGuardDef customguarddef : list){
			CustomGuardDef imported = module.importCustomGuardDef((CustomGuardDefDocument)customguarddef);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (CustomGuardDef customguarddef : ret)
				fireObjectImportedEvent(customguarddef);
		}
		return ret;
	}

	@Override
	public CustomGuardDef createCustomGuardDef(CustomGuardDef customguarddef){
		ModuleASCustomData module = _getModuleASCustomData();
		module.createCustomGuardDef((CustomGuardDefDocument)customguarddef);
		updateModule(module);
		fireObjectCreatedEvent(customguarddef);
		return customguarddef;
	}

	@Override
	/**
	 * Creates multiple new CustomGuardDef objects.
	 * Returns the created versions.
	 */
	public List<CustomGuardDef> createCustomGuardDefs(List<CustomGuardDef> list){
		ModuleASCustomData module = _getModuleASCustomData();
		List<CustomGuardDef> ret = new ArrayList<>();
		for (CustomGuardDef customguarddef : list){
			CustomGuardDef created = module.createCustomGuardDef((CustomGuardDefDocument)customguarddef);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (CustomGuardDef customguarddef : ret)
				fireObjectCreatedEvent(customguarddef);
		}
		return ret;
	}

	@Override
	public CustomGuardDef updateCustomGuardDef(CustomGuardDef customguarddef){
		CustomGuardDef oldVersion = null;
		ModuleASCustomData module = _getModuleASCustomData();
		if (hasServiceListeners())
			oldVersion = module.getCustomGuardDef(customguarddef.getId());
		module.updateCustomGuardDef((CustomGuardDefDocument)customguarddef);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, customguarddef);
		}
		return customguarddef;
	}

	@Override
	public List<CustomGuardDef> updateCustomGuardDefs(List<CustomGuardDef> list){
		List<CustomGuardDef> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASCustomData module = _getModuleASCustomData();
		for (CustomGuardDef customguarddef : list){
			if (oldList!=null)
				oldList.add(module.getCustomGuardDef(customguarddef.getId()));
			module.updateCustomGuardDef((CustomGuardDefDocument)customguarddef);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<CustomGuardDef> getCustomGuardDefsByProperty(String propertyName, Object value){
		List<CustomGuardDef> allCustomGuardDefs = getCustomGuardDefs();
		List<CustomGuardDef> ret = new ArrayList<>();
		for (int i=0; i<allCustomGuardDefs.size(); i++){
			CustomGuardDef customguarddef = allCustomGuardDefs.get(i);
			try{
				Property property = ((CustomGuardDefDocument)customguarddef).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(customguarddef);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(customguarddef);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(customguarddef);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<CustomGuardDef> getCustomGuardDefsByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getCustomGuardDefsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on CustomGuardDefs
	 */
	public QueryResult executeQueryOnCustomGuardDefs(DocumentQuery query){
		List<CustomGuardDef> allCustomGuardDefs = getCustomGuardDefs();
		QueryResult result = new QueryResult();
		for (int i=0; i<allCustomGuardDefs.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allCustomGuardDefs.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all CustomGuardDef objects, where property matches.
	 */
	public List<CustomGuardDef> getCustomGuardDefsByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<CustomGuardDef> ret = new ArrayList<>();
		List<CustomGuardDef> src = getCustomGuardDefs();
		for ( CustomGuardDef customguarddef : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(customguarddef.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(customguarddef);
		}
		return ret;
	}

	/**
	 * Returns all CustomGuardDef objects, where property matches, sorted
	 */
	public List<CustomGuardDef> getCustomGuardDefsByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getCustomGuardDefsByProperty(property), sortType);
	}

	/**
	 * Returns CustomGuardDef objects count.
	 */
	public int getCustomGuardDefsCount() {
		return _getModuleASCustomData().getCustomGuardDefs().size();
	}

	/**
	 * Returns CustomGuardDef objects segment.
	 */
	public List<CustomGuardDef> getCustomGuardDefs(Segment aSegment) {
		return Slicer.slice(aSegment, getCustomGuardDefs()).getSliceData();
	}

	/**
	 * Returns CustomGuardDef objects segment, where property matched.
	 */
	public List<CustomGuardDef> getCustomGuardDefsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<CustomGuardDef> ret = new ArrayList<>();
		List<CustomGuardDef> src = getCustomGuardDefs();
		for (CustomGuardDef customguarddef : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(customguarddef.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(customguarddef);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns CustomGuardDef objects segment, where property matched, sorted.
	 */
	public List<CustomGuardDef> getCustomGuardDefsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getCustomGuardDefsByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchCustomGuardDef(final String id, Set<String> addedDocuments, JSONArray data) throws ASCustomDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("CustomGuardDef" + id))
			return;

		try {
			final CustomGuardDefDocument customguarddef = _getModuleASCustomData().getCustomGuardDef(id);
			addedDocuments.add("CustomGuardDef" + id);



			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(customguarddef);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASCustomData");
			dataObject.put("document", "ASCustomData_CustomGuardDef");

			data.put(dataObject);

		}catch(IOException e){
			throw new ASCustomDataServiceException ("Problem with fetching data for this CustomGuardDef instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASCustomDataServiceException ("Problem with fetching data for this CustomGuardDef instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredCustomGuardDef(final JSONObject data) throws ASCustomDataServiceException {
		try {
			String objectData = data.getString("object");
			CustomGuardDef customguarddef = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), CustomGuardDefDocument.class);

			try {
				updateCustomGuardDef(customguarddef);
			}catch(Exception e){
				importCustomGuardDef(customguarddef);
			}
		}catch(JSONException e){
			throw new ASCustomDataServiceException("Problem with getting data from json CustomGuardDef instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASCustomDataServiceException("Problem with parsing data for this CustomGuardDef instance :" + e.getMessage());
		}
	}

	public void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ASCustomDataServiceException {
		switch(documentName) {
			case DOCUMENT_ASCUSTOMDATA_CUSTOMBOXTYPE:
				saveTransferredCustomBoxType(data);
				break;
			case DOCUMENT_ASCUSTOMDATA_CUSTOMBOXHANDLERDEF:
				saveTransferredCustomBoxHandlerDef(data);
				break;
			case DOCUMENT_ASCUSTOMDATA_CUSTOMGUARDDEF:
				saveTransferredCustomGuardDef(data);
				break;
			default:
				log.info("There is no correct document: " + documentName + "in this service");
				throw new ASCustomDataServiceException("No such document");
		}
	}

	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public QueryResult executeQueryOnAllObjects(DocumentQuery query){
		QueryResult ret = new QueryResult();
		ret.add(executeQueryOnCustomBoxTypes(query).getEntries());
		ret.add(executeQueryOnCustomBoxHandlerDefs(query).getEntries());
		ret.add(executeQueryOnCustomGuardDefs(query).getEntries());
		return ret;
	} //executeQueryOnAllObjects


	public XMLNode exportCustomBoxTypesToXML(){
		XMLNode ret = new XMLNode("CustomBoxTypes");
		List<CustomBoxType> list = getCustomBoxTypes();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (CustomBoxType object : list)
			ret.addChildNode(CustomBoxTypeXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportCustomBoxTypesToXML(List<CustomBoxType> list){
		XMLNode ret = new XMLNode("CustomBoxTypes");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (CustomBoxType object : list)
			ret.addChildNode(CustomBoxTypeXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportCustomBoxHandlerDefsToXML(){
		XMLNode ret = new XMLNode("CustomBoxHandlerDefs");
		List<CustomBoxHandlerDef> list = getCustomBoxHandlerDefs();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (CustomBoxHandlerDef object : list)
			ret.addChildNode(CustomBoxHandlerDefXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportCustomBoxHandlerDefsToXML(List<CustomBoxHandlerDef> list){
		XMLNode ret = new XMLNode("CustomBoxHandlerDefs");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (CustomBoxHandlerDef object : list)
			ret.addChildNode(CustomBoxHandlerDefXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportCustomGuardDefsToXML(){
		XMLNode ret = new XMLNode("CustomGuardDefs");
		List<CustomGuardDef> list = getCustomGuardDefs();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (CustomGuardDef object : list)
			ret.addChildNode(CustomGuardDefXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportCustomGuardDefsToXML(List<CustomGuardDef> list){
		XMLNode ret = new XMLNode("CustomGuardDefs");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (CustomGuardDef object : list)
			ret.addChildNode(CustomGuardDefXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportToXML(){
		XMLNode ret = new XMLNode("ASCustomData");

		ret.addChildNode(exportCustomBoxTypesToXML());
		ret.addChildNode(exportCustomBoxHandlerDefsToXML());
		ret.addChildNode(exportCustomGuardDefsToXML());

		return ret;
	}
}
