/**
 ********************************************************************************
 *** ShowAttributesAction.java                                                ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.aswebdata.data.Attribute;
import net.anotheria.anosite.gen.aswebdata.bean.AttributeListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.aswebdata.bean.AttributeListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;

public class ShowAttributesAction extends BaseAttributeAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"Attribute";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"Attribute";
	private static Logger log = LoggerFactory.getLogger(ShowAttributesAction.class);
	private Sorter<AttributeListItemBean> sorter;

	private IAttributeDecorator idDecorator;
	private IAttributeDecorator nameDecorator;
	private IAttributeDecorator keyDecorator;
	private IAttributeDecorator subattributesDecorator;
	private IAttributeDecorator guardsDecorator;

	private DocumentFilter nameFilterAZ;

	public ShowAttributesAction(){
		sorter = new QuickSorter<AttributeListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
			nameDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
			keyDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
			subattributesDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.BoxCMS2Decorator").newInstance();
			guardsDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.GuardCMS2Decorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = AttributeListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = AttributeListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		AttributeListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new AttributeListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (AttributeListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new AttributeListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<Attribute> _unfiltered_attributes = getASWebDataService().getAttributes();
		List<Attribute> attributes = new ArrayList<Attribute>();
		for (int i=0; i<_unfiltered_attributes.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_attributes.get(i), "name", filterParameter0));
			if (mayPass)
				attributes.add(_unfiltered_attributes.get(i));
		}
		List<AttributeListItemBean> beans = new ArrayList<AttributeListItemBean>(attributes.size());
		for (Attribute attribute : attributes){
			checkAttributes(attribute, req);
			AttributeListItemBean bean = makeAttributeListItemBean(attribute);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "attributes", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		return mapping.success();
	}

	protected AttributeListItemBean makeAttributeListItemBean(Attribute attribute) {
		AttributeListItemBean bean = new AttributeListItemBean();
		bean.setPlainId(attribute.getId());
		bean.setIdForSorting(attribute.getId());
		bean.setId(idDecorator.decorate(attribute, "id", "3"));
		bean.setNameForSorting(attribute.getName());
		bean.setName(nameDecorator.decorate(attribute, "name", "null"));
		bean.setKeyForSorting(attribute.getKey());
		bean.setKey(keyDecorator.decorate(attribute, "key", "null"));
		bean.setValue(attribute.getValue());
		bean.setSubattributesForSorting(attribute.getSubattributes());
		bean.setSubattributes(subattributesDecorator.decorate(attribute, "subattributes", "null"));
		bean.setGuardsForSorting(attribute.getGuards());
		bean.setGuards(guardsDecorator.decorate(attribute, "guards", "null"));
		bean.setLocked(((LockableObject)attribute).isLocked());
		bean.setLockerId(((LockableObject)attribute).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)attribute).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)attribute).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(attribute.getLastUpdateTimestamp()));
		return bean;
	}
}
