/**
 ********************************************************************************
 *** MultiOpDialogAttributesAction.java                                       ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.action;

import net.anotheria.util.NumberUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.aswebdata.data.AttributeFactory;
import net.anotheria.anosite.gen.aswebdata.data.Attribute;
import net.anotheria.anosite.gen.aswebdata.bean.EditAttributeFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;

public class MultiOpDialogAttributesAction extends BaseAttributeAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("aswebdataAttributeDelete"))
			return aswebdataAttributeDelete(mapping, req, res);
		if (path.equals("aswebdataAttributeDuplicate"))
			return aswebdataAttributeDuplicate(mapping, req, res);
		if (path.equals("aswebdataAttributeUpdate"))
			return aswebdataAttributeUpdate(mapping, req, res);
		if (path.equals("aswebdataAttributeClose"))
			return aswebdataAttributeClose(mapping, req, res);
		if (path.equals("aswebdataAttributeLock"))
			return aswebdataAttributeLock(mapping, req, res);
		if (path.equals("aswebdataAttributeUnLock"))
			return aswebdataAttributeUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand aswebdataAttributeDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			Attribute attributeCurr = getASWebDataService().getAttribute(id);
			if (attributeCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)attributeCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASWebDataService().deleteAttribute(id);
		}
		res.sendRedirect("aswebdataAttributeShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand aswebdataAttributeDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		Attribute attributeSrc = getASWebDataService().getAttribute(id);
		Attribute attributeDest = AttributeFactory.createAttribute(attributeSrc);




		Attribute attributeCreated = getASWebDataService().createAttribute(attributeDest);
		res.sendRedirect("aswebdataAttributeEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+attributeCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand aswebdataAttributeUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditAttributeFB form = new EditAttributeFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		Attribute attribute = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		attribute = (Attribute)getASWebDataService().getAttribute(form.getId()).clone();
	}else{
		attribute = AttributeFactory.createAttribute();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	attribute.setName(form.getName());
	attribute.setKey(form.getKey());
	attribute.setValue(form.getValue());
	// skipped container subattributes
	// skipped container guards

	Attribute updatedCopy = null;
	if (create){
		updatedCopy = getASWebDataService().createAttribute(attribute);
	}else{
		canUpdateAttributes(attribute, req);
		checkAttributes(attribute, req);
		updatedCopy = getASWebDataService().updateAttribute(attribute);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("aswebdataAttributeEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(attribute, req);
		res.sendRedirect("aswebdataAttributeShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(Attribute attribute, HttpServletRequest req) throws Exception{
	if(((LockableObject)attribute).isLocked())
		unLockAttributes(attribute, req, false);
}

public ActionCommand aswebdataAttributeLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Attribute attributeCurr = id != null && !id.equals("") ? getASWebDataService().getAttribute(id) : null;
	if(attributeCurr != null && attributeCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)attributeCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockAttributes(attributeCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, attributeCurr));
	return null;
}

public ActionCommand aswebdataAttributeUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Attribute attributeCurr = id != null && !id.equals("") ? getASWebDataService().getAttribute(id) : null;
	if(attributeCurr != null && attributeCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)attributeCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockAttributes(attributeCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, attributeCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, Attribute item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "aswebdataAttributeShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "aswebdataAttributeEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "aswebdataAttributeShow?ts="+System.currentTimeMillis();
}

public ActionCommand aswebdataAttributeClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Attribute attributeCurr = id != null && !id.equals("") ? getASWebDataService().getAttribute(id) : null;
	if(attributeCurr != null && attributeCurr instanceof LockableObject && ((LockableObject)attributeCurr).isLocked()) 
		unLockAttributes(attributeCurr, req, false);
	res.sendRedirect("aswebdataAttributeShow?ts="+System.currentTimeMillis());
	return null;
}

}
