/**
 ********************************************************************************
 *** MultiOpBoxsAttributesAction.java                                         ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.action;

import java.util.List;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.aswebdata.data.BoxFactory;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.anosite.gen.aswebdata.bean.AttributesElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.aswebdata.bean.AttributesQuickAddFB;
import net.anotheria.anosite.gen.aswebdata.data.Attribute;
import net.anotheria.anosite.gen.aswebdata.data.AttributeSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpBoxsAttributesAction extends BaseBoxAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("aswebdataBoxAttributesShow"))
			return aswebdataBoxAttributesShow(mapping, req, res);
		if (path.equals("aswebdataBoxAttributesAdd"))
			return aswebdataBoxAttributesAdd(mapping, req, res);
		if (path.equals("aswebdataBoxAttributesDelete"))
			return aswebdataBoxAttributesDelete(mapping, req, res);
		if (path.equals("aswebdataBoxAttributesMove"))
			return aswebdataBoxAttributesMove(mapping, req, res);
		if (path.equals("aswebdataBoxAttributesQuickAdd"))
			return aswebdataBoxAttributesQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand aswebdataBoxAttributesShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Box box = getASWebDataService().getBox(id);
		addBeanToRequest(req, "ownerId", id);
		checkBoxs(box, req);

		AttributesElementFB form = new AttributesElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(box.getId());
		addBeanToRequest(req, "aswebdataBoxAttributesElementForm", form);

		AttributesQuickAddFB quickAddForm = new AttributesQuickAddFB() ;
		quickAddForm.setOwnerId(box.getId());
		addBeanToRequest(req, "aswebdataBoxAttributesQuickAddForm", quickAddForm);


		//link attribute to Attribute
		List<Attribute> attributes = getASWebDataService().getAttributes(new AttributeSortType(AttributeSortType.SORT_BY_NAME));
		List<LabelValueBean> attributesValues = new ArrayList<LabelValueBean>(attributes.size());
		for (int i=0; i<attributes.size(); i++){
			net.anotheria.anosite.gen.aswebdata.data.Attribute tmp_attribute = (net.anotheria.anosite.gen.aswebdata.data.Attribute) attributes.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_attribute.getId(), tmp_attribute.getName()+" ["+tmp_attribute.getId()+"]" );
			attributesValues.add(bean);
		}
		addBeanToRequest(req, "attributeValuesCollection", attributesValues);
		// generate list ...
		int size = box.getAttributesSize();
		List<AttributesElementFB> beans = new ArrayList<AttributesElementFB>(size);
		for (int i=0; i<size; i++){
			String value = box.getAttributesElement(i);
			AttributesElementFB bean = new AttributesElementFB();
			bean.setOwnerId(box.getId());
			bean.setPosition(i);
			bean.setAttribute(value);
			try{
				Attribute tmp_attribute = getASWebDataService().getAttribute(value);
				bean.setDescription(tmp_attribute.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand aswebdataBoxAttributesDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Box boxCurr = getASWebDataService().getBox(id);
		canUpdateBoxs(boxCurr, req);
		checkBoxs(boxCurr, req);
		int position = getIntParameter(req, "pPosition");
		Box box = getASWebDataService().getBox(id);
		box.removeAttributesElement(position);
		getASWebDataService().updateBox(box);
		return aswebdataBoxAttributesShow(mapping, req, res);
	}

	public ActionCommand aswebdataBoxAttributesMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		Box box = getASWebDataService().getBox(id);
		canUpdateBoxs(box, req);
		checkBoxs(box, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(box, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(box, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(box, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(box, position);
		return aswebdataBoxAttributesShow(mapping, req, res);
	}

	private void moveUp(Box box, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		box.swapAttributesElement(position, position-1);
		getASWebDataService().updateBox(box);
	}

	private void moveTop(Box box, int position) throws ASGRuntimeException {
		List<String> targetList = box.getAttributes();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		box.setAttributes(targetList);
		getASWebDataService().updateBox(box);
	}

	private void moveDown(Box box, int position) throws ASGRuntimeException {
		if (position<box.getAttributesSize()-1){
			box.swapAttributesElement(position, position+1);
			getASWebDataService().updateBox(box);
		}
	}

	private void moveBottom(Box box, int position) throws ASGRuntimeException {
		List<String> targetList = box.getAttributes();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		box.setAttributes(targetList);
		getASWebDataService().updateBox(box);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand aswebdataBoxAttributesAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		AttributesElementFB form = new AttributesElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Box box;
		box = getASWebDataService().getBox(id);
		canUpdateBoxs(box, req);
		checkBoxs(box, req);
		box.addAttributesElement(form.getAttribute());
		getASWebDataService().updateBox(box);
		return aswebdataBoxAttributesShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand aswebdataBoxAttributesQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		AttributesQuickAddFB form = new AttributesQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Box box;
		box = getASWebDataService().getBox(id);
		canUpdateBoxs(box, req);
		checkBoxs(box, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				box.addAttributesElement(""+i);
			}
		}
		getASWebDataService().updateBox(box);
		return aswebdataBoxAttributesShow(mapping, req, res);
	}

}
