/**
 ********************************************************************************
 *** MultiOpAttributesGuardsAction.java                                       ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.action;

import java.util.List;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.aswebdata.data.AttributeFactory;
import net.anotheria.anosite.gen.aswebdata.data.Attribute;
import net.anotheria.anosite.gen.aswebdata.bean.GuardsElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.aswebdata.bean.GuardsQuickAddFB;
import net.anotheria.anosite.gen.asfederateddata.data.GuardDef;
import net.anotheria.anosite.gen.asfederateddata.data.GuardDefSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpAttributesGuardsAction extends BaseAttributeAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("aswebdataAttributeGuardsShow"))
			return aswebdataAttributeGuardsShow(mapping, req, res);
		if (path.equals("aswebdataAttributeGuardsAdd"))
			return aswebdataAttributeGuardsAdd(mapping, req, res);
		if (path.equals("aswebdataAttributeGuardsDelete"))
			return aswebdataAttributeGuardsDelete(mapping, req, res);
		if (path.equals("aswebdataAttributeGuardsMove"))
			return aswebdataAttributeGuardsMove(mapping, req, res);
		if (path.equals("aswebdataAttributeGuardsQuickAdd"))
			return aswebdataAttributeGuardsQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand aswebdataAttributeGuardsShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Attribute attribute = getASWebDataService().getAttribute(id);
		addBeanToRequest(req, "ownerId", id);
		checkAttributes(attribute, req);

		GuardsElementFB form = new GuardsElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(attribute.getId());
		addBeanToRequest(req, "aswebdataAttributeGuardsElementForm", form);

		GuardsQuickAddFB quickAddForm = new GuardsQuickAddFB() ;
		quickAddForm.setOwnerId(attribute.getId());
		addBeanToRequest(req, "aswebdataAttributeGuardsQuickAddForm", quickAddForm);


		//link guard to ASFederatedData.GuardDef
		List<GuardDef> guarddefs = getASFederatedDataService().getGuardDefs(new GuardDefSortType(GuardDefSortType.SORT_BY_NAME));
		List<LabelValueBean> guarddefsValues = new ArrayList<LabelValueBean>(guarddefs.size());
		for (int i=0; i<guarddefs.size(); i++){
			net.anotheria.anosite.gen.asfederateddata.data.GuardDef tmp_guarddef = (net.anotheria.anosite.gen.asfederateddata.data.GuardDef) guarddefs.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_guarddef.getId(), tmp_guarddef.getName()+" ["+tmp_guarddef.getId()+"]" );
			guarddefsValues.add(bean);
		}
		addBeanToRequest(req, "guardValuesCollection", guarddefsValues);
		// generate list ...
		int size = attribute.getGuardsSize();
		List<GuardsElementFB> beans = new ArrayList<GuardsElementFB>(size);
		for (int i=0; i<size; i++){
			String value = attribute.getGuardsElement(i);
			GuardsElementFB bean = new GuardsElementFB();
			bean.setOwnerId(attribute.getId());
			bean.setPosition(i);
			bean.setGuard(value);
			try{
				GuardDef tmp_guarddef = getASFederatedDataService().getGuardDef(value);
				bean.setDescription(tmp_guarddef.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand aswebdataAttributeGuardsDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Attribute attributeCurr = getASWebDataService().getAttribute(id);
		canUpdateAttributes(attributeCurr, req);
		checkAttributes(attributeCurr, req);
		int position = getIntParameter(req, "pPosition");
		Attribute attribute = getASWebDataService().getAttribute(id);
		attribute.removeGuardsElement(position);
		getASWebDataService().updateAttribute(attribute);
		return aswebdataAttributeGuardsShow(mapping, req, res);
	}

	public ActionCommand aswebdataAttributeGuardsMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		Attribute attribute = getASWebDataService().getAttribute(id);
		canUpdateAttributes(attribute, req);
		checkAttributes(attribute, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(attribute, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(attribute, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(attribute, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(attribute, position);
		return aswebdataAttributeGuardsShow(mapping, req, res);
	}

	private void moveUp(Attribute attribute, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		attribute.swapGuardsElement(position, position-1);
		getASWebDataService().updateAttribute(attribute);
	}

	private void moveTop(Attribute attribute, int position) throws ASGRuntimeException {
		List<String> targetList = attribute.getGuards();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		attribute.setGuards(targetList);
		getASWebDataService().updateAttribute(attribute);
	}

	private void moveDown(Attribute attribute, int position) throws ASGRuntimeException {
		if (position<attribute.getGuardsSize()-1){
			attribute.swapGuardsElement(position, position+1);
			getASWebDataService().updateAttribute(attribute);
		}
	}

	private void moveBottom(Attribute attribute, int position) throws ASGRuntimeException {
		List<String> targetList = attribute.getGuards();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		attribute.setGuards(targetList);
		getASWebDataService().updateAttribute(attribute);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand aswebdataAttributeGuardsAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		GuardsElementFB form = new GuardsElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Attribute attribute;
		attribute = getASWebDataService().getAttribute(id);
		canUpdateAttributes(attribute, req);
		checkAttributes(attribute, req);
		attribute.addGuardsElement(form.getGuard());
		getASWebDataService().updateAttribute(attribute);
		return aswebdataAttributeGuardsShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand aswebdataAttributeGuardsQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		GuardsQuickAddFB form = new GuardsQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Attribute attribute;
		attribute = getASWebDataService().getAttribute(id);
		canUpdateAttributes(attribute, req);
		checkAttributes(attribute, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				attribute.addGuardsElement(""+i);
			}
		}
		getASWebDataService().updateAttribute(attribute);
		return aswebdataAttributeGuardsShow(mapping, req, res);
	}

}
