/**
 ********************************************************************************
 *** ASSiteDataServiceImpl.java                                               ***
 *** The implementation of the IASSiteDataService.                            ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.service;

import java.nio.charset.Charset;
import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import net.anotheria.anodoc.data.Module;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;
import net.anotheria.util.slicer.Segment;
import net.anotheria.util.slicer.Slicer;
import net.anotheria.anosite.gen.assitedata.data.ModuleASSiteData;
import net.anotheria.anosite.gen.shared.service.BasicCMSService;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryResultEntry;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.util.StringUtils;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.asg.util.listener.IModuleListener;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import net.anotheria.anodoc.util.mapper.ObjectMapperUtil;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.anosite.gen.assitedata.data.PageTemplate;
import net.anotheria.anosite.gen.assitedata.data.PageTemplateXMLHelper;
import net.anotheria.anosite.gen.assitedata.data.PageTemplateDocument;
import net.anotheria.anosite.gen.aswebdata.service.ASWebDataServiceException;
import net.anotheria.anosite.gen.assitedata.service.ASSiteDataServiceException;
import net.anotheria.anosite.gen.asresourcedata.service.ASResourceDataServiceException;
import net.anotheria.anosite.gen.aslayoutdata.service.ASLayoutDataServiceException;
import net.anotheria.anosite.gen.assitedata.data.MediaLink;
import net.anotheria.anosite.gen.assitedata.data.MediaLinkXMLHelper;
import net.anotheria.anosite.gen.assitedata.data.MediaLinkDocument;
import net.anotheria.anosite.gen.asfederateddata.service.ASFederatedDataServiceException;
import net.anotheria.anosite.gen.assitedata.data.Script;
import net.anotheria.anosite.gen.assitedata.data.ScriptXMLHelper;
import net.anotheria.anosite.gen.assitedata.data.ScriptDocument;
import net.anotheria.anosite.gen.assitedata.data.Site;
import net.anotheria.anosite.gen.assitedata.data.SiteXMLHelper;
import net.anotheria.anosite.gen.assitedata.data.SiteDocument;
import net.anotheria.anosite.gen.assitedata.data.NaviItem;
import net.anotheria.anosite.gen.assitedata.data.NaviItemXMLHelper;
import net.anotheria.anosite.gen.assitedata.data.NaviItemDocument;
import net.anotheria.webutils.filehandling.actions.FileStorage;
import java.io.File;
import java.io.FileNotFoundException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.anotheria.anosite.util.staticutil.JerseyClientUtil;
import net.anotheria.anosite.config.DocumentTransferConfig;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import net.anotheria.anosite.gen.anoaccessconfiguration.service.AnoAccessConfigurationServiceException;
import net.anotheria.anosite.gen.assitedata.data.EntryPoint;
import net.anotheria.anosite.gen.assitedata.data.EntryPointXMLHelper;
import net.anotheria.anosite.gen.assitedata.data.EntryPointDocument;
import net.anotheria.anosite.gen.assitedata.data.PageAlias;
import net.anotheria.anosite.gen.assitedata.data.PageAliasXMLHelper;
import net.anotheria.anosite.gen.assitedata.data.PageAliasDocument;
import net.anotheria.anosite.gen.assitedata.data.RedirectUrl;
import net.anotheria.anosite.gen.assitedata.data.RedirectUrlXMLHelper;
import net.anotheria.anosite.gen.assitedata.data.RedirectUrlDocument;

public class ASSiteDataServiceImpl extends BasicCMSService implements IASSiteDataService, IModuleListener{

	// Generated by: class net.anotheria.asg.generator.model.docs.CMSBasedServiceGenerator.generateImplementation

	private static ASSiteDataServiceImpl instance;

	private ASSiteDataServiceImpl(){
		addServiceListener(new net.anotheria.anosite.cms.listener.CRUDLogListener());
		addServiceListener(new net.anotheria.anosite.cms.listener.AutoTransferSiteDataListener());
		addModuleListener(ModuleASSiteData.MODULE_ID, this);
	}

	static final ASSiteDataServiceImpl getInstance(){
		if (instance==null){
			instance = new ASSiteDataServiceImpl();
		}
		return instance;
	}

	private ModuleASSiteData _getModuleASSiteData(){
		return (ModuleASSiteData) getModule(ModuleASSiteData.MODULE_ID);
	}

	@Override
	public void moduleLoaded(Module module){
		firePersistenceChangedEvent();
	}

	@Override
	public List<PageTemplate> getPageTemplates(){
		List<PageTemplate> pagetemplates = new ArrayList<>();
		pagetemplates.addAll(_getModuleASSiteData().getPageTemplates());
		return pagetemplates;
	}

	@Override
	public List<PageTemplate> getPageTemplates(SortType sortType){
		return StaticQuickSorter.sort(getPageTemplates(), sortType);
	}

	/**
	 * Returns the PageTemplate objects with the specified ids.
	 */
	public List<PageTemplate> getPageTemplates(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<PageTemplate> all = getPageTemplates();
		List<PageTemplate> ret = new ArrayList<>();
		for (PageTemplate pagetemplate : all){
			if(ids.contains(pagetemplate.getId())){
				ret.add(pagetemplate);
			}
		}
		return ret;
	}

	/**
	 * Returns the PageTemplate objects with the specified ids, sorted by given sorttype.
	 */
	public List<PageTemplate> getPageTemplates(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getPageTemplates(ids), sortType);
	}

	@Override
	public void deletePageTemplate(PageTemplate pagetemplate){
		deletePageTemplate(pagetemplate.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(pagetemplate);
		}
	}

	@Override
	public void deletePageTemplate(String id){
		ModuleASSiteData module = _getModuleASSiteData();
		PageTemplate varValue = hasServiceListeners()?module.getPageTemplate(id):null;
		module.deletePageTemplate(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deletePageTemplates(List<PageTemplate> list){
		ModuleASSiteData module = _getModuleASSiteData();
		for (PageTemplate pagetemplate : list){
			module.deletePageTemplate(pagetemplate.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public PageTemplate getPageTemplate(String id){
		return _getModuleASSiteData().getPageTemplate(id);
	}

	@Override
	public PageTemplate importPageTemplate(PageTemplate pagetemplate){
		ModuleASSiteData module = _getModuleASSiteData();
		module.importPageTemplate((PageTemplateDocument)pagetemplate);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(pagetemplate);
		}
		return pagetemplate;
	}

	@Override
	public List<PageTemplate> importPageTemplates(List<PageTemplate> list){
		ModuleASSiteData module = _getModuleASSiteData();
		List<PageTemplate> ret = new ArrayList<>();
		for (PageTemplate pagetemplate : list){
			PageTemplate imported = module.importPageTemplate((PageTemplateDocument)pagetemplate);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (PageTemplate pagetemplate : ret)
				fireObjectImportedEvent(pagetemplate);
		}
		return ret;
	}

	@Override
	public PageTemplate createPageTemplate(PageTemplate pagetemplate){
		ModuleASSiteData module = _getModuleASSiteData();
		module.createPageTemplate((PageTemplateDocument)pagetemplate);
		updateModule(module);
		fireObjectCreatedEvent(pagetemplate);
		return pagetemplate;
	}

	@Override
	/**
	 * Creates multiple new PageTemplate objects.
	 * Returns the created versions.
	 */
	public List<PageTemplate> createPageTemplates(List<PageTemplate> list){
		ModuleASSiteData module = _getModuleASSiteData();
		List<PageTemplate> ret = new ArrayList<>();
		for (PageTemplate pagetemplate : list){
			PageTemplate created = module.createPageTemplate((PageTemplateDocument)pagetemplate);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (PageTemplate pagetemplate : ret)
				fireObjectCreatedEvent(pagetemplate);
		}
		return ret;
	}

	@Override
	public PageTemplate updatePageTemplate(PageTemplate pagetemplate){
		PageTemplate oldVersion = null;
		ModuleASSiteData module = _getModuleASSiteData();
		if (hasServiceListeners())
			oldVersion = module.getPageTemplate(pagetemplate.getId());
		module.updatePageTemplate((PageTemplateDocument)pagetemplate);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, pagetemplate);
		}
		return pagetemplate;
	}

	@Override
	public List<PageTemplate> updatePageTemplates(List<PageTemplate> list){
		List<PageTemplate> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASSiteData module = _getModuleASSiteData();
		for (PageTemplate pagetemplate : list){
			if (oldList!=null)
				oldList.add(module.getPageTemplate(pagetemplate.getId()));
			module.updatePageTemplate((PageTemplateDocument)pagetemplate);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<PageTemplate> getPageTemplatesByProperty(String propertyName, Object value){
		List<PageTemplate> allPageTemplates = getPageTemplates();
		List<PageTemplate> ret = new ArrayList<>();
		for (int i=0; i<allPageTemplates.size(); i++){
			PageTemplate pagetemplate = allPageTemplates.get(i);
			try{
				Property property = ((PageTemplateDocument)pagetemplate).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(pagetemplate);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(pagetemplate);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(pagetemplate);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<PageTemplate> getPageTemplatesByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getPageTemplatesByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on PageTemplates
	 */
	public QueryResult executeQueryOnPageTemplates(DocumentQuery query){
		List<PageTemplate> allPageTemplates = getPageTemplates();
		QueryResult result = new QueryResult();
		for (int i=0; i<allPageTemplates.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allPageTemplates.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all PageTemplate objects, where property matches.
	 */
	public List<PageTemplate> getPageTemplatesByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<PageTemplate> ret = new ArrayList<>();
		List<PageTemplate> src = getPageTemplates();
		for ( PageTemplate pagetemplate : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(pagetemplate.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(pagetemplate);
		}
		return ret;
	}

	/**
	 * Returns all PageTemplate objects, where property matches, sorted
	 */
	public List<PageTemplate> getPageTemplatesByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getPageTemplatesByProperty(property), sortType);
	}

	/**
	 * Returns PageTemplate objects count.
	 */
	public int getPageTemplatesCount() {
		return _getModuleASSiteData().getPageTemplates().size();
	}

	/**
	 * Returns PageTemplate objects segment.
	 */
	public List<PageTemplate> getPageTemplates(Segment aSegment) {
		return Slicer.slice(aSegment, getPageTemplates()).getSliceData();
	}

	/**
	 * Returns PageTemplate objects segment, where property matched.
	 */
	public List<PageTemplate> getPageTemplatesByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<PageTemplate> ret = new ArrayList<>();
		List<PageTemplate> src = getPageTemplates();
		for (PageTemplate pagetemplate : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(pagetemplate.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(pagetemplate);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns PageTemplate objects segment, where property matched, sorted.
	 */
	public List<PageTemplate> getPageTemplatesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getPageTemplatesByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchPageTemplate(final String id, Set<String> addedDocuments, JSONArray data) throws ASSiteDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("PageTemplate" + id))
			return;

		try {
			final PageTemplateDocument pagetemplate = _getModuleASSiteData().getPageTemplate(id);
			addedDocuments.add("PageTemplate" + id);

			if (!StringUtils.isEmpty(pagetemplate.getLayout()))
				getASLayoutDataService().fetchPageLayout(pagetemplate.getLayout(), addedDocuments, data);
			if (!StringUtils.isEmpty(pagetemplate.getSite()))
				getASSiteDataService().fetchSite(pagetemplate.getSite(), addedDocuments, data);

			if (!pagetemplate.getMediaLinks().isEmpty()) {
				for (String aMediaLinksId: pagetemplate.getMediaLinks()) {
					getASSiteDataService().fetchMediaLink(aMediaLinksId, addedDocuments, data);
				}
			}
			if (!pagetemplate.getScripts().isEmpty()) {
				for (String aScriptsId: pagetemplate.getScripts()) {
					getASSiteDataService().fetchScript(aScriptsId, addedDocuments, data);
				}
			}
			if (!pagetemplate.getC1first().isEmpty()) {
				for (String aC1firstId: pagetemplate.getC1first()) {
					getASWebDataService().fetchBox(aC1firstId, addedDocuments, data);
				}
			}
			if (!pagetemplate.getC2first().isEmpty()) {
				for (String aC2firstId: pagetemplate.getC2first()) {
					getASWebDataService().fetchBox(aC2firstId, addedDocuments, data);
				}
			}
			if (!pagetemplate.getC3first().isEmpty()) {
				for (String aC3firstId: pagetemplate.getC3first()) {
					getASWebDataService().fetchBox(aC3firstId, addedDocuments, data);
				}
			}
			if (!pagetemplate.getC1last().isEmpty()) {
				for (String aC1lastId: pagetemplate.getC1last()) {
					getASWebDataService().fetchBox(aC1lastId, addedDocuments, data);
				}
			}
			if (!pagetemplate.getC2last().isEmpty()) {
				for (String aC2lastId: pagetemplate.getC2last()) {
					getASWebDataService().fetchBox(aC2lastId, addedDocuments, data);
				}
			}
			if (!pagetemplate.getC3last().isEmpty()) {
				for (String aC3lastId: pagetemplate.getC3last()) {
					getASWebDataService().fetchBox(aC3lastId, addedDocuments, data);
				}
			}
			if (!pagetemplate.getMeta().isEmpty()) {
				for (String aMetaId: pagetemplate.getMeta()) {
					getASWebDataService().fetchBox(aMetaId, addedDocuments, data);
				}
			}
			if (!pagetemplate.getHeader().isEmpty()) {
				for (String aHeaderId: pagetemplate.getHeader()) {
					getASWebDataService().fetchBox(aHeaderId, addedDocuments, data);
				}
			}
			if (!pagetemplate.getFooter().isEmpty()) {
				for (String aFooterId: pagetemplate.getFooter()) {
					getASWebDataService().fetchBox(aFooterId, addedDocuments, data);
				}
			}
			if (!pagetemplate.getLocalizations().isEmpty()) {
				for (String aLocalizationsId: pagetemplate.getLocalizations()) {
					getASResourceDataService().fetchLocalizationBundle(aLocalizationsId, addedDocuments, data);
				}
			}

			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(pagetemplate);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASSiteData");
			dataObject.put("document", "ASSiteData_PageTemplate");

			data.put(dataObject);

		}catch(ASWebDataServiceException e){
			throw new ASSiteDataServiceException("Problem with getting document from ASWebData" + e.getMessage());
		}catch(ASSiteDataServiceException e){
			throw new ASSiteDataServiceException("Problem with getting document from ASSiteData" + e.getMessage());
		}catch(ASResourceDataServiceException e){
			throw new ASSiteDataServiceException("Problem with getting document from ASResourceData" + e.getMessage());
		}catch(ASLayoutDataServiceException e){
			throw new ASSiteDataServiceException("Problem with getting document from ASLayoutData" + e.getMessage());
		}catch(IOException e){
			throw new ASSiteDataServiceException ("Problem with fetching data for this PageTemplate instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASSiteDataServiceException ("Problem with fetching data for this PageTemplate instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredPageTemplate(final JSONObject data) throws ASSiteDataServiceException {
		try {
			String objectData = data.getString("object");
			PageTemplate pagetemplate = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), PageTemplateDocument.class);

			try {
				updatePageTemplate(pagetemplate);
			}catch(Exception e){
				importPageTemplate(pagetemplate);
			}
		}catch(JSONException e){
			throw new ASSiteDataServiceException("Problem with getting data from json PageTemplate instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASSiteDataServiceException("Problem with parsing data for this PageTemplate instance :" + e.getMessage());
		}
	}

	@Override
	public List<MediaLink> getMediaLinks(){
		List<MediaLink> medialinks = new ArrayList<>();
		medialinks.addAll(_getModuleASSiteData().getMediaLinks());
		return medialinks;
	}

	@Override
	public List<MediaLink> getMediaLinks(SortType sortType){
		return StaticQuickSorter.sort(getMediaLinks(), sortType);
	}

	/**
	 * Returns the MediaLink objects with the specified ids.
	 */
	public List<MediaLink> getMediaLinks(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<MediaLink> all = getMediaLinks();
		List<MediaLink> ret = new ArrayList<>();
		for (MediaLink medialink : all){
			if(ids.contains(medialink.getId())){
				ret.add(medialink);
			}
		}
		return ret;
	}

	/**
	 * Returns the MediaLink objects with the specified ids, sorted by given sorttype.
	 */
	public List<MediaLink> getMediaLinks(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getMediaLinks(ids), sortType);
	}

	@Override
	public void deleteMediaLink(MediaLink medialink){
		deleteMediaLink(medialink.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(medialink);
		}
	}

	@Override
	public void deleteMediaLink(String id){
		ModuleASSiteData module = _getModuleASSiteData();
		MediaLink varValue = hasServiceListeners()?module.getMediaLink(id):null;
		module.deleteMediaLink(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteMediaLinks(List<MediaLink> list){
		ModuleASSiteData module = _getModuleASSiteData();
		for (MediaLink medialink : list){
			module.deleteMediaLink(medialink.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public MediaLink getMediaLink(String id){
		return _getModuleASSiteData().getMediaLink(id);
	}

	@Override
	public MediaLink importMediaLink(MediaLink medialink){
		ModuleASSiteData module = _getModuleASSiteData();
		module.importMediaLink((MediaLinkDocument)medialink);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(medialink);
		}
		return medialink;
	}

	@Override
	public List<MediaLink> importMediaLinks(List<MediaLink> list){
		ModuleASSiteData module = _getModuleASSiteData();
		List<MediaLink> ret = new ArrayList<>();
		for (MediaLink medialink : list){
			MediaLink imported = module.importMediaLink((MediaLinkDocument)medialink);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (MediaLink medialink : ret)
				fireObjectImportedEvent(medialink);
		}
		return ret;
	}

	@Override
	public MediaLink createMediaLink(MediaLink medialink){
		ModuleASSiteData module = _getModuleASSiteData();
		module.createMediaLink((MediaLinkDocument)medialink);
		updateModule(module);
		fireObjectCreatedEvent(medialink);
		return medialink;
	}

	@Override
	/**
	 * Creates multiple new MediaLink objects.
	 * Returns the created versions.
	 */
	public List<MediaLink> createMediaLinks(List<MediaLink> list){
		ModuleASSiteData module = _getModuleASSiteData();
		List<MediaLink> ret = new ArrayList<>();
		for (MediaLink medialink : list){
			MediaLink created = module.createMediaLink((MediaLinkDocument)medialink);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (MediaLink medialink : ret)
				fireObjectCreatedEvent(medialink);
		}
		return ret;
	}

	@Override
	public MediaLink updateMediaLink(MediaLink medialink){
		MediaLink oldVersion = null;
		ModuleASSiteData module = _getModuleASSiteData();
		if (hasServiceListeners())
			oldVersion = module.getMediaLink(medialink.getId());
		module.updateMediaLink((MediaLinkDocument)medialink);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, medialink);
		}
		return medialink;
	}

	@Override
	public List<MediaLink> updateMediaLinks(List<MediaLink> list){
		List<MediaLink> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASSiteData module = _getModuleASSiteData();
		for (MediaLink medialink : list){
			if (oldList!=null)
				oldList.add(module.getMediaLink(medialink.getId()));
			module.updateMediaLink((MediaLinkDocument)medialink);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<MediaLink> getMediaLinksByProperty(String propertyName, Object value){
		List<MediaLink> allMediaLinks = getMediaLinks();
		List<MediaLink> ret = new ArrayList<>();
		for (int i=0; i<allMediaLinks.size(); i++){
			MediaLink medialink = allMediaLinks.get(i);
			try{
				Property property = ((MediaLinkDocument)medialink).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(medialink);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(medialink);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(medialink);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<MediaLink> getMediaLinksByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getMediaLinksByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on MediaLinks
	 */
	public QueryResult executeQueryOnMediaLinks(DocumentQuery query){
		List<MediaLink> allMediaLinks = getMediaLinks();
		QueryResult result = new QueryResult();
		for (int i=0; i<allMediaLinks.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allMediaLinks.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all MediaLink objects, where property matches.
	 */
	public List<MediaLink> getMediaLinksByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<MediaLink> ret = new ArrayList<>();
		List<MediaLink> src = getMediaLinks();
		for ( MediaLink medialink : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(medialink.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(medialink);
		}
		return ret;
	}

	/**
	 * Returns all MediaLink objects, where property matches, sorted
	 */
	public List<MediaLink> getMediaLinksByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getMediaLinksByProperty(property), sortType);
	}

	/**
	 * Returns MediaLink objects count.
	 */
	public int getMediaLinksCount() {
		return _getModuleASSiteData().getMediaLinks().size();
	}

	/**
	 * Returns MediaLink objects segment.
	 */
	public List<MediaLink> getMediaLinks(Segment aSegment) {
		return Slicer.slice(aSegment, getMediaLinks()).getSliceData();
	}

	/**
	 * Returns MediaLink objects segment, where property matched.
	 */
	public List<MediaLink> getMediaLinksByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<MediaLink> ret = new ArrayList<>();
		List<MediaLink> src = getMediaLinks();
		for (MediaLink medialink : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(medialink.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(medialink);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns MediaLink objects segment, where property matched, sorted.
	 */
	public List<MediaLink> getMediaLinksByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getMediaLinksByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchMediaLink(final String id, Set<String> addedDocuments, JSONArray data) throws ASSiteDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("MediaLink" + id))
			return;

		try {
			final MediaLinkDocument medialink = _getModuleASSiteData().getMediaLink(id);
			addedDocuments.add("MediaLink" + id);

			if (!StringUtils.isEmpty(medialink.getFile()))
				getASResourceDataService().fetchFileLink(medialink.getFile(), addedDocuments, data);

			if (!medialink.getGuards().isEmpty()) {
				for (String aGuardsId: medialink.getGuards()) {
					getASFederatedDataService().fetchGuardDef(aGuardsId, addedDocuments, data);
				}
			}

			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(medialink);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASSiteData");
			dataObject.put("document", "ASSiteData_MediaLink");

			data.put(dataObject);

		}catch(ASResourceDataServiceException e){
			throw new ASSiteDataServiceException("Problem with getting document from ASResourceData" + e.getMessage());
		}catch(ASFederatedDataServiceException e){
			throw new ASSiteDataServiceException("Problem with getting document from ASFederatedData" + e.getMessage());
		}catch(IOException e){
			throw new ASSiteDataServiceException ("Problem with fetching data for this MediaLink instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASSiteDataServiceException ("Problem with fetching data for this MediaLink instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredMediaLink(final JSONObject data) throws ASSiteDataServiceException {
		try {
			String objectData = data.getString("object");
			MediaLink medialink = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), MediaLinkDocument.class);

			try {
				updateMediaLink(medialink);
			}catch(Exception e){
				importMediaLink(medialink);
			}
		}catch(JSONException e){
			throw new ASSiteDataServiceException("Problem with getting data from json MediaLink instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASSiteDataServiceException("Problem with parsing data for this MediaLink instance :" + e.getMessage());
		}
	}

	@Override
	public List<Script> getScripts(){
		List<Script> scripts = new ArrayList<>();
		scripts.addAll(_getModuleASSiteData().getScripts());
		return scripts;
	}

	@Override
	public List<Script> getScripts(SortType sortType){
		return StaticQuickSorter.sort(getScripts(), sortType);
	}

	/**
	 * Returns the Script objects with the specified ids.
	 */
	public List<Script> getScripts(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<Script> all = getScripts();
		List<Script> ret = new ArrayList<>();
		for (Script script : all){
			if(ids.contains(script.getId())){
				ret.add(script);
			}
		}
		return ret;
	}

	/**
	 * Returns the Script objects with the specified ids, sorted by given sorttype.
	 */
	public List<Script> getScripts(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getScripts(ids), sortType);
	}

	@Override
	public void deleteScript(Script script){
		deleteScript(script.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(script);
		}
	}

	@Override
	public void deleteScript(String id){
		ModuleASSiteData module = _getModuleASSiteData();
		Script varValue = hasServiceListeners()?module.getScript(id):null;
		module.deleteScript(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteScripts(List<Script> list){
		ModuleASSiteData module = _getModuleASSiteData();
		for (Script script : list){
			module.deleteScript(script.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public Script getScript(String id){
		return _getModuleASSiteData().getScript(id);
	}

	@Override
	public Script importScript(Script script){
		ModuleASSiteData module = _getModuleASSiteData();
		module.importScript((ScriptDocument)script);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(script);
		}
		return script;
	}

	@Override
	public List<Script> importScripts(List<Script> list){
		ModuleASSiteData module = _getModuleASSiteData();
		List<Script> ret = new ArrayList<>();
		for (Script script : list){
			Script imported = module.importScript((ScriptDocument)script);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Script script : ret)
				fireObjectImportedEvent(script);
		}
		return ret;
	}

	@Override
	public Script createScript(Script script){
		ModuleASSiteData module = _getModuleASSiteData();
		module.createScript((ScriptDocument)script);
		updateModule(module);
		fireObjectCreatedEvent(script);
		return script;
	}

	@Override
	/**
	 * Creates multiple new Script objects.
	 * Returns the created versions.
	 */
	public List<Script> createScripts(List<Script> list){
		ModuleASSiteData module = _getModuleASSiteData();
		List<Script> ret = new ArrayList<>();
		for (Script script : list){
			Script created = module.createScript((ScriptDocument)script);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Script script : ret)
				fireObjectCreatedEvent(script);
		}
		return ret;
	}

	@Override
	public Script updateScript(Script script){
		Script oldVersion = null;
		ModuleASSiteData module = _getModuleASSiteData();
		if (hasServiceListeners())
			oldVersion = module.getScript(script.getId());
		module.updateScript((ScriptDocument)script);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, script);
		}
		return script;
	}

	@Override
	public List<Script> updateScripts(List<Script> list){
		List<Script> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASSiteData module = _getModuleASSiteData();
		for (Script script : list){
			if (oldList!=null)
				oldList.add(module.getScript(script.getId()));
			module.updateScript((ScriptDocument)script);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<Script> getScriptsByProperty(String propertyName, Object value){
		List<Script> allScripts = getScripts();
		List<Script> ret = new ArrayList<>();
		for (int i=0; i<allScripts.size(); i++){
			Script script = allScripts.get(i);
			try{
				Property property = ((ScriptDocument)script).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(script);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(script);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(script);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<Script> getScriptsByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getScriptsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on Scripts
	 */
	public QueryResult executeQueryOnScripts(DocumentQuery query){
		List<Script> allScripts = getScripts();
		QueryResult result = new QueryResult();
		for (int i=0; i<allScripts.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allScripts.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all Script objects, where property matches.
	 */
	public List<Script> getScriptsByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<Script> ret = new ArrayList<>();
		List<Script> src = getScripts();
		for ( Script script : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(script.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(script);
		}
		return ret;
	}

	/**
	 * Returns all Script objects, where property matches, sorted
	 */
	public List<Script> getScriptsByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getScriptsByProperty(property), sortType);
	}

	/**
	 * Returns Script objects count.
	 */
	public int getScriptsCount() {
		return _getModuleASSiteData().getScripts().size();
	}

	/**
	 * Returns Script objects segment.
	 */
	public List<Script> getScripts(Segment aSegment) {
		return Slicer.slice(aSegment, getScripts()).getSliceData();
	}

	/**
	 * Returns Script objects segment, where property matched.
	 */
	public List<Script> getScriptsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<Script> ret = new ArrayList<>();
		List<Script> src = getScripts();
		for (Script script : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(script.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(script);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns Script objects segment, where property matched, sorted.
	 */
	public List<Script> getScriptsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getScriptsByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchScript(final String id, Set<String> addedDocuments, JSONArray data) throws ASSiteDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("Script" + id))
			return;

		try {
			final ScriptDocument script = _getModuleASSiteData().getScript(id);
			addedDocuments.add("Script" + id);

			if (!StringUtils.isEmpty(script.getFile()))
				getASResourceDataService().fetchFileLink(script.getFile(), addedDocuments, data);

			if (!script.getGuards().isEmpty()) {
				for (String aGuardsId: script.getGuards()) {
					getASFederatedDataService().fetchGuardDef(aGuardsId, addedDocuments, data);
				}
			}

			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(script);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASSiteData");
			dataObject.put("document", "ASSiteData_Script");

			data.put(dataObject);

		}catch(ASResourceDataServiceException e){
			throw new ASSiteDataServiceException("Problem with getting document from ASResourceData" + e.getMessage());
		}catch(ASFederatedDataServiceException e){
			throw new ASSiteDataServiceException("Problem with getting document from ASFederatedData" + e.getMessage());
		}catch(IOException e){
			throw new ASSiteDataServiceException ("Problem with fetching data for this Script instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASSiteDataServiceException ("Problem with fetching data for this Script instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredScript(final JSONObject data) throws ASSiteDataServiceException {
		try {
			String objectData = data.getString("object");
			Script script = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), ScriptDocument.class);

			try {
				updateScript(script);
			}catch(Exception e){
				importScript(script);
			}
		}catch(JSONException e){
			throw new ASSiteDataServiceException("Problem with getting data from json Script instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASSiteDataServiceException("Problem with parsing data for this Script instance :" + e.getMessage());
		}
	}

	@Override
	public List<Site> getSites(){
		List<Site> sites = new ArrayList<>();
		sites.addAll(_getModuleASSiteData().getSites());
		return sites;
	}

	@Override
	public List<Site> getSites(SortType sortType){
		return StaticQuickSorter.sort(getSites(), sortType);
	}

	/**
	 * Returns the Site objects with the specified ids.
	 */
	public List<Site> getSites(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<Site> all = getSites();
		List<Site> ret = new ArrayList<>();
		for (Site site : all){
			if(ids.contains(site.getId())){
				ret.add(site);
			}
		}
		return ret;
	}

	/**
	 * Returns the Site objects with the specified ids, sorted by given sorttype.
	 */
	public List<Site> getSites(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getSites(ids), sortType);
	}

	@Override
	public void deleteSite(Site site){
		deleteSite(site.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(site);
		}
	}

	@Override
	public void deleteSite(String id){
		ModuleASSiteData module = _getModuleASSiteData();
		Site varValue = hasServiceListeners()?module.getSite(id):null;
		module.deleteSite(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteSites(List<Site> list){
		ModuleASSiteData module = _getModuleASSiteData();
		for (Site site : list){
			module.deleteSite(site.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public Site getSite(String id){
		return _getModuleASSiteData().getSite(id);
	}

	@Override
	public Site importSite(Site site){
		ModuleASSiteData module = _getModuleASSiteData();
		module.importSite((SiteDocument)site);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(site);
		}
		return site;
	}

	@Override
	public List<Site> importSites(List<Site> list){
		ModuleASSiteData module = _getModuleASSiteData();
		List<Site> ret = new ArrayList<>();
		for (Site site : list){
			Site imported = module.importSite((SiteDocument)site);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Site site : ret)
				fireObjectImportedEvent(site);
		}
		return ret;
	}

	@Override
	public Site createSite(Site site){
		ModuleASSiteData module = _getModuleASSiteData();
		module.createSite((SiteDocument)site);
		updateModule(module);
		fireObjectCreatedEvent(site);
		return site;
	}

	@Override
	/**
	 * Creates multiple new Site objects.
	 * Returns the created versions.
	 */
	public List<Site> createSites(List<Site> list){
		ModuleASSiteData module = _getModuleASSiteData();
		List<Site> ret = new ArrayList<>();
		for (Site site : list){
			Site created = module.createSite((SiteDocument)site);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Site site : ret)
				fireObjectCreatedEvent(site);
		}
		return ret;
	}

	@Override
	public Site updateSite(Site site){
		Site oldVersion = null;
		ModuleASSiteData module = _getModuleASSiteData();
		if (hasServiceListeners())
			oldVersion = module.getSite(site.getId());
		module.updateSite((SiteDocument)site);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, site);
		}
		return site;
	}

	@Override
	public List<Site> updateSites(List<Site> list){
		List<Site> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASSiteData module = _getModuleASSiteData();
		for (Site site : list){
			if (oldList!=null)
				oldList.add(module.getSite(site.getId()));
			module.updateSite((SiteDocument)site);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<Site> getSitesByProperty(String propertyName, Object value){
		List<Site> allSites = getSites();
		List<Site> ret = new ArrayList<>();
		for (int i=0; i<allSites.size(); i++){
			Site site = allSites.get(i);
			try{
				Property property = ((SiteDocument)site).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(site);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(site);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(site);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<Site> getSitesByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getSitesByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on Sites
	 */
	public QueryResult executeQueryOnSites(DocumentQuery query){
		List<Site> allSites = getSites();
		QueryResult result = new QueryResult();
		for (int i=0; i<allSites.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allSites.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all Site objects, where property matches.
	 */
	public List<Site> getSitesByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<Site> ret = new ArrayList<>();
		List<Site> src = getSites();
		for ( Site site : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(site.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(site);
		}
		return ret;
	}

	/**
	 * Returns all Site objects, where property matches, sorted
	 */
	public List<Site> getSitesByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getSitesByProperty(property), sortType);
	}

	/**
	 * Returns Site objects count.
	 */
	public int getSitesCount() {
		return _getModuleASSiteData().getSites().size();
	}

	/**
	 * Returns Site objects segment.
	 */
	public List<Site> getSites(Segment aSegment) {
		return Slicer.slice(aSegment, getSites()).getSliceData();
	}

	/**
	 * Returns Site objects segment, where property matched.
	 */
	public List<Site> getSitesByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<Site> ret = new ArrayList<>();
		List<Site> src = getSites();
		for (Site site : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(site.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(site);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns Site objects segment, where property matched, sorted.
	 */
	public List<Site> getSitesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getSitesByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchSite(final String id, Set<String> addedDocuments, JSONArray data) throws ASSiteDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("Site" + id))
			return;

		try {
			final SiteDocument site = _getModuleASSiteData().getSite(id);
			addedDocuments.add("Site" + id);

			if (!StringUtils.isEmpty(site.getStartpage()))
				getASWebDataService().fetchPagex(site.getStartpage(), addedDocuments, data);
			if (!StringUtils.isEmpty(site.getSearchpage()))
				getASWebDataService().fetchPagex(site.getSearchpage(), addedDocuments, data);
			if (!StringUtils.isEmpty(site.getHeaderBackground()))
				getASResourceDataService().fetchImage(site.getHeaderBackground(), addedDocuments, data);
			if (!StringUtils.isEmpty(site.getSiteLogo()))
				getASResourceDataService().fetchImage(site.getSiteLogo(), addedDocuments, data);

			if (!site.getMainNavi().isEmpty()) {
				for (String aMainNaviId: site.getMainNavi()) {
					getASSiteDataService().fetchNaviItem(aMainNaviId, addedDocuments, data);
				}
			}
			if (!site.getTopNavi().isEmpty()) {
				for (String aTopNaviId: site.getTopNavi()) {
					getASSiteDataService().fetchNaviItem(aTopNaviId, addedDocuments, data);
				}
			}

			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(site);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASSiteData");
			dataObject.put("document", "ASSiteData_Site");

			data.put(dataObject);

		}catch(ASWebDataServiceException e){
			throw new ASSiteDataServiceException("Problem with getting document from ASWebData" + e.getMessage());
		}catch(ASSiteDataServiceException e){
			throw new ASSiteDataServiceException("Problem with getting document from ASSiteData" + e.getMessage());
		}catch(ASResourceDataServiceException e){
			throw new ASSiteDataServiceException("Problem with getting document from ASResourceData" + e.getMessage());
		}catch(IOException e){
			throw new ASSiteDataServiceException ("Problem with fetching data for this Site instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASSiteDataServiceException ("Problem with fetching data for this Site instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredSite(final JSONObject data) throws ASSiteDataServiceException {
		try {
			String objectData = data.getString("object");
			Site site = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), SiteDocument.class);

			try {
				updateSite(site);
			}catch(Exception e){
				importSite(site);
			}
		}catch(JSONException e){
			throw new ASSiteDataServiceException("Problem with getting data from json Site instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASSiteDataServiceException("Problem with parsing data for this Site instance :" + e.getMessage());
		}
	}

	// This method is not very fast, since it makes an update (eff. save) after each doc.
	public void copyMultilingualAttributesInAllSites(String sourceLanguage, String targetLanguage){
		List<Site> allDocumentsSrc = getSites();
		List<Site> allDocuments = new ArrayList<>(allDocumentsSrc.size());
		allDocuments.addAll(allDocumentsSrc);
		for (Site document : allDocuments){
			document.copyLANG2LANG(sourceLanguage, targetLanguage);
		}
		updateSites(allDocuments);
	}

	@Override
	public List<NaviItem> getNaviItems(){
		List<NaviItem> naviitems = new ArrayList<>();
		naviitems.addAll(_getModuleASSiteData().getNaviItems());
		return naviitems;
	}

	@Override
	public List<NaviItem> getNaviItems(SortType sortType){
		return StaticQuickSorter.sort(getNaviItems(), sortType);
	}

	/**
	 * Returns the NaviItem objects with the specified ids.
	 */
	public List<NaviItem> getNaviItems(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<NaviItem> all = getNaviItems();
		List<NaviItem> ret = new ArrayList<>();
		for (NaviItem naviitem : all){
			if(ids.contains(naviitem.getId())){
				ret.add(naviitem);
			}
		}
		return ret;
	}

	/**
	 * Returns the NaviItem objects with the specified ids, sorted by given sorttype.
	 */
	public List<NaviItem> getNaviItems(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getNaviItems(ids), sortType);
	}

	@Override
	public void deleteNaviItem(NaviItem naviitem){
		deleteNaviItem(naviitem.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(naviitem);
		}
	}

	@Override
	public void deleteNaviItem(String id){
		ModuleASSiteData module = _getModuleASSiteData();
		NaviItem varValue = hasServiceListeners()?module.getNaviItem(id):null;
		module.deleteNaviItem(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteNaviItems(List<NaviItem> list){
		ModuleASSiteData module = _getModuleASSiteData();
		for (NaviItem naviitem : list){
			module.deleteNaviItem(naviitem.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public NaviItem getNaviItem(String id){
		return _getModuleASSiteData().getNaviItem(id);
	}

	@Override
	public NaviItem importNaviItem(NaviItem naviitem){
		ModuleASSiteData module = _getModuleASSiteData();
		module.importNaviItem((NaviItemDocument)naviitem);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(naviitem);
		}
		return naviitem;
	}

	@Override
	public List<NaviItem> importNaviItems(List<NaviItem> list){
		ModuleASSiteData module = _getModuleASSiteData();
		List<NaviItem> ret = new ArrayList<>();
		for (NaviItem naviitem : list){
			NaviItem imported = module.importNaviItem((NaviItemDocument)naviitem);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (NaviItem naviitem : ret)
				fireObjectImportedEvent(naviitem);
		}
		return ret;
	}

	@Override
	public NaviItem createNaviItem(NaviItem naviitem){
		ModuleASSiteData module = _getModuleASSiteData();
		module.createNaviItem((NaviItemDocument)naviitem);
		updateModule(module);
		fireObjectCreatedEvent(naviitem);
		return naviitem;
	}

	@Override
	/**
	 * Creates multiple new NaviItem objects.
	 * Returns the created versions.
	 */
	public List<NaviItem> createNaviItems(List<NaviItem> list){
		ModuleASSiteData module = _getModuleASSiteData();
		List<NaviItem> ret = new ArrayList<>();
		for (NaviItem naviitem : list){
			NaviItem created = module.createNaviItem((NaviItemDocument)naviitem);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (NaviItem naviitem : ret)
				fireObjectCreatedEvent(naviitem);
		}
		return ret;
	}

	@Override
	public NaviItem updateNaviItem(NaviItem naviitem){
		NaviItem oldVersion = null;
		ModuleASSiteData module = _getModuleASSiteData();
		if (hasServiceListeners())
			oldVersion = module.getNaviItem(naviitem.getId());
		module.updateNaviItem((NaviItemDocument)naviitem);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, naviitem);
		}
		return naviitem;
	}

	@Override
	public List<NaviItem> updateNaviItems(List<NaviItem> list){
		List<NaviItem> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASSiteData module = _getModuleASSiteData();
		for (NaviItem naviitem : list){
			if (oldList!=null)
				oldList.add(module.getNaviItem(naviitem.getId()));
			module.updateNaviItem((NaviItemDocument)naviitem);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<NaviItem> getNaviItemsByProperty(String propertyName, Object value){
		List<NaviItem> allNaviItems = getNaviItems();
		List<NaviItem> ret = new ArrayList<>();
		for (int i=0; i<allNaviItems.size(); i++){
			NaviItem naviitem = allNaviItems.get(i);
			try{
				Property property = ((NaviItemDocument)naviitem).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(naviitem);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(naviitem);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(naviitem);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<NaviItem> getNaviItemsByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getNaviItemsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on NaviItems
	 */
	public QueryResult executeQueryOnNaviItems(DocumentQuery query){
		List<NaviItem> allNaviItems = getNaviItems();
		QueryResult result = new QueryResult();
		for (int i=0; i<allNaviItems.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allNaviItems.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all NaviItem objects, where property matches.
	 */
	public List<NaviItem> getNaviItemsByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<NaviItem> ret = new ArrayList<>();
		List<NaviItem> src = getNaviItems();
		for ( NaviItem naviitem : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(naviitem.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(naviitem);
		}
		return ret;
	}

	/**
	 * Returns all NaviItem objects, where property matches, sorted
	 */
	public List<NaviItem> getNaviItemsByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getNaviItemsByProperty(property), sortType);
	}

	/**
	 * Returns NaviItem objects count.
	 */
	public int getNaviItemsCount() {
		return _getModuleASSiteData().getNaviItems().size();
	}

	/**
	 * Returns NaviItem objects segment.
	 */
	public List<NaviItem> getNaviItems(Segment aSegment) {
		return Slicer.slice(aSegment, getNaviItems()).getSliceData();
	}

	/**
	 * Returns NaviItem objects segment, where property matched.
	 */
	public List<NaviItem> getNaviItemsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<NaviItem> ret = new ArrayList<>();
		List<NaviItem> src = getNaviItems();
		for (NaviItem naviitem : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(naviitem.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(naviitem);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns NaviItem objects segment, where property matched, sorted.
	 */
	public List<NaviItem> getNaviItemsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getNaviItemsByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchNaviItem(final String id, Set<String> addedDocuments, JSONArray data) throws ASSiteDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("NaviItem" + id))
			return;

		try {
			final NaviItemDocument naviitem = _getModuleASSiteData().getNaviItem(id);
			addedDocuments.add("NaviItem" + id);

			if (!StringUtils.isEmpty(naviitem.getInternalLink()))
				getASWebDataService().fetchPagex(naviitem.getInternalLink(), addedDocuments, data);
			if (!StringUtils.isEmpty(naviitem.getPageAlias()))
				getASSiteDataService().fetchPageAlias(naviitem.getPageAlias(), addedDocuments, data);
			if (!StringUtils.isEmpty(naviitem.getAccessOperation()))
				getAnoAccessConfigurationService().fetchAccessOperation(naviitem.getAccessOperation(), addedDocuments, data);

			if (!naviitem.getSubNavi().isEmpty()) {
				for (String aSubNaviId: naviitem.getSubNavi()) {
					getASSiteDataService().fetchNaviItem(aSubNaviId, addedDocuments, data);
				}
			}
			if (!naviitem.getGuards().isEmpty()) {
				for (String aGuardsId: naviitem.getGuards()) {
					getASFederatedDataService().fetchGuardDef(aGuardsId, addedDocuments, data);
				}
			}

			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(naviitem);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASSiteData");
			dataObject.put("document", "ASSiteData_NaviItem");

			data.put(dataObject);

			File imageFile = FileStorage.getFile(naviitem.getIcon());
			Client client = JerseyClientUtil.getClientInstance();
			for (String domain :DocumentTransferConfig.getInstance().getDomains()) {
				final FileDataBodyPart filePart = new FileDataBodyPart("file", imageFile);
				FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
				final FormDataMultiPart multipart = (FormDataMultiPart) formDataMultiPart.bodyPart(filePart);
				final WebTarget target = client.target(domain + "/api/asgimage/upload");
				final Response response = target.request().post(Entity.entity(multipart, multipart.getMediaType()));
				String responseResult = response.readEntity(String.class);
				log.info(responseResult);
				formDataMultiPart.close();
				multipart.close();
			}
		}catch(FileNotFoundException e){
			throw new ASSiteDataServiceException ("Problem with getting image file for NaviItem" + e.getMessage());
		}catch(ASWebDataServiceException e){
			throw new ASSiteDataServiceException("Problem with getting document from ASWebData" + e.getMessage());
		}catch(ASSiteDataServiceException e){
			throw new ASSiteDataServiceException("Problem with getting document from ASSiteData" + e.getMessage());
		}catch(AnoAccessConfigurationServiceException e){
			throw new ASSiteDataServiceException("Problem with getting document from AnoAccessConfiguration" + e.getMessage());
		}catch(ASFederatedDataServiceException e){
			throw new ASSiteDataServiceException("Problem with getting document from ASFederatedData" + e.getMessage());
		}catch(IOException e){
			throw new ASSiteDataServiceException ("Problem with fetching data for this NaviItem instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASSiteDataServiceException ("Problem with fetching data for this NaviItem instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredNaviItem(final JSONObject data) throws ASSiteDataServiceException {
		try {
			String objectData = data.getString("object");
			NaviItem naviitem = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), NaviItemDocument.class);

			try {
				updateNaviItem(naviitem);
			}catch(Exception e){
				importNaviItem(naviitem);
			}
		}catch(JSONException e){
			throw new ASSiteDataServiceException("Problem with getting data from json NaviItem instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASSiteDataServiceException("Problem with parsing data for this NaviItem instance :" + e.getMessage());
		}
	}

	// This method is not very fast, since it makes an update (eff. save) after each doc.
	public void copyMultilingualAttributesInAllNaviItems(String sourceLanguage, String targetLanguage){
		List<NaviItem> allDocumentsSrc = getNaviItems();
		List<NaviItem> allDocuments = new ArrayList<>(allDocumentsSrc.size());
		allDocuments.addAll(allDocumentsSrc);
		for (NaviItem document : allDocuments){
			document.copyLANG2LANG(sourceLanguage, targetLanguage);
		}
		updateNaviItems(allDocuments);
	}

	@Override
	public List<EntryPoint> getEntryPoints(){
		List<EntryPoint> entrypoints = new ArrayList<>();
		entrypoints.addAll(_getModuleASSiteData().getEntryPoints());
		return entrypoints;
	}

	@Override
	public List<EntryPoint> getEntryPoints(SortType sortType){
		return StaticQuickSorter.sort(getEntryPoints(), sortType);
	}

	/**
	 * Returns the EntryPoint objects with the specified ids.
	 */
	public List<EntryPoint> getEntryPoints(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<EntryPoint> all = getEntryPoints();
		List<EntryPoint> ret = new ArrayList<>();
		for (EntryPoint entrypoint : all){
			if(ids.contains(entrypoint.getId())){
				ret.add(entrypoint);
			}
		}
		return ret;
	}

	/**
	 * Returns the EntryPoint objects with the specified ids, sorted by given sorttype.
	 */
	public List<EntryPoint> getEntryPoints(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getEntryPoints(ids), sortType);
	}

	@Override
	public void deleteEntryPoint(EntryPoint entrypoint){
		deleteEntryPoint(entrypoint.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(entrypoint);
		}
	}

	@Override
	public void deleteEntryPoint(String id){
		ModuleASSiteData module = _getModuleASSiteData();
		EntryPoint varValue = hasServiceListeners()?module.getEntryPoint(id):null;
		module.deleteEntryPoint(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteEntryPoints(List<EntryPoint> list){
		ModuleASSiteData module = _getModuleASSiteData();
		for (EntryPoint entrypoint : list){
			module.deleteEntryPoint(entrypoint.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public EntryPoint getEntryPoint(String id){
		return _getModuleASSiteData().getEntryPoint(id);
	}

	@Override
	public EntryPoint importEntryPoint(EntryPoint entrypoint){
		ModuleASSiteData module = _getModuleASSiteData();
		module.importEntryPoint((EntryPointDocument)entrypoint);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(entrypoint);
		}
		return entrypoint;
	}

	@Override
	public List<EntryPoint> importEntryPoints(List<EntryPoint> list){
		ModuleASSiteData module = _getModuleASSiteData();
		List<EntryPoint> ret = new ArrayList<>();
		for (EntryPoint entrypoint : list){
			EntryPoint imported = module.importEntryPoint((EntryPointDocument)entrypoint);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (EntryPoint entrypoint : ret)
				fireObjectImportedEvent(entrypoint);
		}
		return ret;
	}

	@Override
	public EntryPoint createEntryPoint(EntryPoint entrypoint){
		ModuleASSiteData module = _getModuleASSiteData();
		module.createEntryPoint((EntryPointDocument)entrypoint);
		updateModule(module);
		fireObjectCreatedEvent(entrypoint);
		return entrypoint;
	}

	@Override
	/**
	 * Creates multiple new EntryPoint objects.
	 * Returns the created versions.
	 */
	public List<EntryPoint> createEntryPoints(List<EntryPoint> list){
		ModuleASSiteData module = _getModuleASSiteData();
		List<EntryPoint> ret = new ArrayList<>();
		for (EntryPoint entrypoint : list){
			EntryPoint created = module.createEntryPoint((EntryPointDocument)entrypoint);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (EntryPoint entrypoint : ret)
				fireObjectCreatedEvent(entrypoint);
		}
		return ret;
	}

	@Override
	public EntryPoint updateEntryPoint(EntryPoint entrypoint){
		EntryPoint oldVersion = null;
		ModuleASSiteData module = _getModuleASSiteData();
		if (hasServiceListeners())
			oldVersion = module.getEntryPoint(entrypoint.getId());
		module.updateEntryPoint((EntryPointDocument)entrypoint);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, entrypoint);
		}
		return entrypoint;
	}

	@Override
	public List<EntryPoint> updateEntryPoints(List<EntryPoint> list){
		List<EntryPoint> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASSiteData module = _getModuleASSiteData();
		for (EntryPoint entrypoint : list){
			if (oldList!=null)
				oldList.add(module.getEntryPoint(entrypoint.getId()));
			module.updateEntryPoint((EntryPointDocument)entrypoint);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<EntryPoint> getEntryPointsByProperty(String propertyName, Object value){
		List<EntryPoint> allEntryPoints = getEntryPoints();
		List<EntryPoint> ret = new ArrayList<>();
		for (int i=0; i<allEntryPoints.size(); i++){
			EntryPoint entrypoint = allEntryPoints.get(i);
			try{
				Property property = ((EntryPointDocument)entrypoint).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(entrypoint);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(entrypoint);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(entrypoint);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<EntryPoint> getEntryPointsByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getEntryPointsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on EntryPoints
	 */
	public QueryResult executeQueryOnEntryPoints(DocumentQuery query){
		List<EntryPoint> allEntryPoints = getEntryPoints();
		QueryResult result = new QueryResult();
		for (int i=0; i<allEntryPoints.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allEntryPoints.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all EntryPoint objects, where property matches.
	 */
	public List<EntryPoint> getEntryPointsByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<EntryPoint> ret = new ArrayList<>();
		List<EntryPoint> src = getEntryPoints();
		for ( EntryPoint entrypoint : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(entrypoint.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(entrypoint);
		}
		return ret;
	}

	/**
	 * Returns all EntryPoint objects, where property matches, sorted
	 */
	public List<EntryPoint> getEntryPointsByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getEntryPointsByProperty(property), sortType);
	}

	/**
	 * Returns EntryPoint objects count.
	 */
	public int getEntryPointsCount() {
		return _getModuleASSiteData().getEntryPoints().size();
	}

	/**
	 * Returns EntryPoint objects segment.
	 */
	public List<EntryPoint> getEntryPoints(Segment aSegment) {
		return Slicer.slice(aSegment, getEntryPoints()).getSliceData();
	}

	/**
	 * Returns EntryPoint objects segment, where property matched.
	 */
	public List<EntryPoint> getEntryPointsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<EntryPoint> ret = new ArrayList<>();
		List<EntryPoint> src = getEntryPoints();
		for (EntryPoint entrypoint : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(entrypoint.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(entrypoint);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns EntryPoint objects segment, where property matched, sorted.
	 */
	public List<EntryPoint> getEntryPointsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getEntryPointsByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchEntryPoint(final String id, Set<String> addedDocuments, JSONArray data) throws ASSiteDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("EntryPoint" + id))
			return;

		try {
			final EntryPointDocument entrypoint = _getModuleASSiteData().getEntryPoint(id);
			addedDocuments.add("EntryPoint" + id);

			if (!StringUtils.isEmpty(entrypoint.getStartPage()))
				getASWebDataService().fetchPagex(entrypoint.getStartPage(), addedDocuments, data);
			if (!StringUtils.isEmpty(entrypoint.getStartSite()))
				getASSiteDataService().fetchSite(entrypoint.getStartSite(), addedDocuments, data);


			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(entrypoint);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASSiteData");
			dataObject.put("document", "ASSiteData_EntryPoint");

			data.put(dataObject);

		}catch(ASWebDataServiceException e){
			throw new ASSiteDataServiceException("Problem with getting document from ASWebData" + e.getMessage());
		}catch(ASSiteDataServiceException e){
			throw new ASSiteDataServiceException("Problem with getting document from ASSiteData" + e.getMessage());
		}catch(IOException e){
			throw new ASSiteDataServiceException ("Problem with fetching data for this EntryPoint instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASSiteDataServiceException ("Problem with fetching data for this EntryPoint instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredEntryPoint(final JSONObject data) throws ASSiteDataServiceException {
		try {
			String objectData = data.getString("object");
			EntryPoint entrypoint = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), EntryPointDocument.class);

			try {
				updateEntryPoint(entrypoint);
			}catch(Exception e){
				importEntryPoint(entrypoint);
			}
		}catch(JSONException e){
			throw new ASSiteDataServiceException("Problem with getting data from json EntryPoint instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASSiteDataServiceException("Problem with parsing data for this EntryPoint instance :" + e.getMessage());
		}
	}

	@Override
	public List<PageAlias> getPageAliass(){
		List<PageAlias> pagealiass = new ArrayList<>();
		pagealiass.addAll(_getModuleASSiteData().getPageAliass());
		return pagealiass;
	}

	@Override
	public List<PageAlias> getPageAliass(SortType sortType){
		return StaticQuickSorter.sort(getPageAliass(), sortType);
	}

	/**
	 * Returns the PageAlias objects with the specified ids.
	 */
	public List<PageAlias> getPageAliass(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<PageAlias> all = getPageAliass();
		List<PageAlias> ret = new ArrayList<>();
		for (PageAlias pagealias : all){
			if(ids.contains(pagealias.getId())){
				ret.add(pagealias);
			}
		}
		return ret;
	}

	/**
	 * Returns the PageAlias objects with the specified ids, sorted by given sorttype.
	 */
	public List<PageAlias> getPageAliass(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getPageAliass(ids), sortType);
	}

	@Override
	public void deletePageAlias(PageAlias pagealias){
		deletePageAlias(pagealias.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(pagealias);
		}
	}

	@Override
	public void deletePageAlias(String id){
		ModuleASSiteData module = _getModuleASSiteData();
		PageAlias varValue = hasServiceListeners()?module.getPageAlias(id):null;
		module.deletePageAlias(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deletePageAliass(List<PageAlias> list){
		ModuleASSiteData module = _getModuleASSiteData();
		for (PageAlias pagealias : list){
			module.deletePageAlias(pagealias.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public PageAlias getPageAlias(String id){
		return _getModuleASSiteData().getPageAlias(id);
	}

	@Override
	public PageAlias importPageAlias(PageAlias pagealias){
		ModuleASSiteData module = _getModuleASSiteData();
		module.importPageAlias((PageAliasDocument)pagealias);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(pagealias);
		}
		return pagealias;
	}

	@Override
	public List<PageAlias> importPageAliass(List<PageAlias> list){
		ModuleASSiteData module = _getModuleASSiteData();
		List<PageAlias> ret = new ArrayList<>();
		for (PageAlias pagealias : list){
			PageAlias imported = module.importPageAlias((PageAliasDocument)pagealias);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (PageAlias pagealias : ret)
				fireObjectImportedEvent(pagealias);
		}
		return ret;
	}

	@Override
	public PageAlias createPageAlias(PageAlias pagealias){
		ModuleASSiteData module = _getModuleASSiteData();
		module.createPageAlias((PageAliasDocument)pagealias);
		updateModule(module);
		fireObjectCreatedEvent(pagealias);
		return pagealias;
	}

	@Override
	/**
	 * Creates multiple new PageAlias objects.
	 * Returns the created versions.
	 */
	public List<PageAlias> createPageAliass(List<PageAlias> list){
		ModuleASSiteData module = _getModuleASSiteData();
		List<PageAlias> ret = new ArrayList<>();
		for (PageAlias pagealias : list){
			PageAlias created = module.createPageAlias((PageAliasDocument)pagealias);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (PageAlias pagealias : ret)
				fireObjectCreatedEvent(pagealias);
		}
		return ret;
	}

	@Override
	public PageAlias updatePageAlias(PageAlias pagealias){
		PageAlias oldVersion = null;
		ModuleASSiteData module = _getModuleASSiteData();
		if (hasServiceListeners())
			oldVersion = module.getPageAlias(pagealias.getId());
		module.updatePageAlias((PageAliasDocument)pagealias);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, pagealias);
		}
		return pagealias;
	}

	@Override
	public List<PageAlias> updatePageAliass(List<PageAlias> list){
		List<PageAlias> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASSiteData module = _getModuleASSiteData();
		for (PageAlias pagealias : list){
			if (oldList!=null)
				oldList.add(module.getPageAlias(pagealias.getId()));
			module.updatePageAlias((PageAliasDocument)pagealias);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<PageAlias> getPageAliassByProperty(String propertyName, Object value){
		List<PageAlias> allPageAliass = getPageAliass();
		List<PageAlias> ret = new ArrayList<>();
		for (int i=0; i<allPageAliass.size(); i++){
			PageAlias pagealias = allPageAliass.get(i);
			try{
				Property property = ((PageAliasDocument)pagealias).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(pagealias);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(pagealias);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(pagealias);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<PageAlias> getPageAliassByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getPageAliassByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on PageAliass
	 */
	public QueryResult executeQueryOnPageAliass(DocumentQuery query){
		List<PageAlias> allPageAliass = getPageAliass();
		QueryResult result = new QueryResult();
		for (int i=0; i<allPageAliass.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allPageAliass.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all PageAlias objects, where property matches.
	 */
	public List<PageAlias> getPageAliassByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<PageAlias> ret = new ArrayList<>();
		List<PageAlias> src = getPageAliass();
		for ( PageAlias pagealias : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(pagealias.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(pagealias);
		}
		return ret;
	}

	/**
	 * Returns all PageAlias objects, where property matches, sorted
	 */
	public List<PageAlias> getPageAliassByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getPageAliassByProperty(property), sortType);
	}

	/**
	 * Returns PageAlias objects count.
	 */
	public int getPageAliassCount() {
		return _getModuleASSiteData().getPageAliass().size();
	}

	/**
	 * Returns PageAlias objects segment.
	 */
	public List<PageAlias> getPageAliass(Segment aSegment) {
		return Slicer.slice(aSegment, getPageAliass()).getSliceData();
	}

	/**
	 * Returns PageAlias objects segment, where property matched.
	 */
	public List<PageAlias> getPageAliassByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<PageAlias> ret = new ArrayList<>();
		List<PageAlias> src = getPageAliass();
		for (PageAlias pagealias : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(pagealias.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(pagealias);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns PageAlias objects segment, where property matched, sorted.
	 */
	public List<PageAlias> getPageAliassByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getPageAliassByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchPageAlias(final String id, Set<String> addedDocuments, JSONArray data) throws ASSiteDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("PageAlias" + id))
			return;

		try {
			final PageAliasDocument pagealias = _getModuleASSiteData().getPageAlias(id);
			addedDocuments.add("PageAlias" + id);

			if (!StringUtils.isEmpty(pagealias.getTargetPage()))
				getASWebDataService().fetchPagex(pagealias.getTargetPage(), addedDocuments, data);


			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(pagealias);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASSiteData");
			dataObject.put("document", "ASSiteData_PageAlias");

			data.put(dataObject);

		}catch(ASWebDataServiceException e){
			throw new ASSiteDataServiceException("Problem with getting document from ASWebData" + e.getMessage());
		}catch(IOException e){
			throw new ASSiteDataServiceException ("Problem with fetching data for this PageAlias instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASSiteDataServiceException ("Problem with fetching data for this PageAlias instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredPageAlias(final JSONObject data) throws ASSiteDataServiceException {
		try {
			String objectData = data.getString("object");
			PageAlias pagealias = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), PageAliasDocument.class);

			try {
				updatePageAlias(pagealias);
			}catch(Exception e){
				importPageAlias(pagealias);
			}
		}catch(JSONException e){
			throw new ASSiteDataServiceException("Problem with getting data from json PageAlias instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASSiteDataServiceException("Problem with parsing data for this PageAlias instance :" + e.getMessage());
		}
	}

	@Override
	public List<RedirectUrl> getRedirectUrls(){
		List<RedirectUrl> redirecturls = new ArrayList<>();
		redirecturls.addAll(_getModuleASSiteData().getRedirectUrls());
		return redirecturls;
	}

	@Override
	public List<RedirectUrl> getRedirectUrls(SortType sortType){
		return StaticQuickSorter.sort(getRedirectUrls(), sortType);
	}

	/**
	 * Returns the RedirectUrl objects with the specified ids.
	 */
	public List<RedirectUrl> getRedirectUrls(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<RedirectUrl> all = getRedirectUrls();
		List<RedirectUrl> ret = new ArrayList<>();
		for (RedirectUrl redirecturl : all){
			if(ids.contains(redirecturl.getId())){
				ret.add(redirecturl);
			}
		}
		return ret;
	}

	/**
	 * Returns the RedirectUrl objects with the specified ids, sorted by given sorttype.
	 */
	public List<RedirectUrl> getRedirectUrls(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getRedirectUrls(ids), sortType);
	}

	@Override
	public void deleteRedirectUrl(RedirectUrl redirecturl){
		deleteRedirectUrl(redirecturl.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(redirecturl);
		}
	}

	@Override
	public void deleteRedirectUrl(String id){
		ModuleASSiteData module = _getModuleASSiteData();
		RedirectUrl varValue = hasServiceListeners()?module.getRedirectUrl(id):null;
		module.deleteRedirectUrl(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteRedirectUrls(List<RedirectUrl> list){
		ModuleASSiteData module = _getModuleASSiteData();
		for (RedirectUrl redirecturl : list){
			module.deleteRedirectUrl(redirecturl.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public RedirectUrl getRedirectUrl(String id){
		return _getModuleASSiteData().getRedirectUrl(id);
	}

	@Override
	public RedirectUrl importRedirectUrl(RedirectUrl redirecturl){
		ModuleASSiteData module = _getModuleASSiteData();
		module.importRedirectUrl((RedirectUrlDocument)redirecturl);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(redirecturl);
		}
		return redirecturl;
	}

	@Override
	public List<RedirectUrl> importRedirectUrls(List<RedirectUrl> list){
		ModuleASSiteData module = _getModuleASSiteData();
		List<RedirectUrl> ret = new ArrayList<>();
		for (RedirectUrl redirecturl : list){
			RedirectUrl imported = module.importRedirectUrl((RedirectUrlDocument)redirecturl);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (RedirectUrl redirecturl : ret)
				fireObjectImportedEvent(redirecturl);
		}
		return ret;
	}

	@Override
	public RedirectUrl createRedirectUrl(RedirectUrl redirecturl){
		ModuleASSiteData module = _getModuleASSiteData();
		module.createRedirectUrl((RedirectUrlDocument)redirecturl);
		updateModule(module);
		fireObjectCreatedEvent(redirecturl);
		return redirecturl;
	}

	@Override
	/**
	 * Creates multiple new RedirectUrl objects.
	 * Returns the created versions.
	 */
	public List<RedirectUrl> createRedirectUrls(List<RedirectUrl> list){
		ModuleASSiteData module = _getModuleASSiteData();
		List<RedirectUrl> ret = new ArrayList<>();
		for (RedirectUrl redirecturl : list){
			RedirectUrl created = module.createRedirectUrl((RedirectUrlDocument)redirecturl);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (RedirectUrl redirecturl : ret)
				fireObjectCreatedEvent(redirecturl);
		}
		return ret;
	}

	@Override
	public RedirectUrl updateRedirectUrl(RedirectUrl redirecturl){
		RedirectUrl oldVersion = null;
		ModuleASSiteData module = _getModuleASSiteData();
		if (hasServiceListeners())
			oldVersion = module.getRedirectUrl(redirecturl.getId());
		module.updateRedirectUrl((RedirectUrlDocument)redirecturl);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, redirecturl);
		}
		return redirecturl;
	}

	@Override
	public List<RedirectUrl> updateRedirectUrls(List<RedirectUrl> list){
		List<RedirectUrl> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASSiteData module = _getModuleASSiteData();
		for (RedirectUrl redirecturl : list){
			if (oldList!=null)
				oldList.add(module.getRedirectUrl(redirecturl.getId()));
			module.updateRedirectUrl((RedirectUrlDocument)redirecturl);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<RedirectUrl> getRedirectUrlsByProperty(String propertyName, Object value){
		List<RedirectUrl> allRedirectUrls = getRedirectUrls();
		List<RedirectUrl> ret = new ArrayList<>();
		for (int i=0; i<allRedirectUrls.size(); i++){
			RedirectUrl redirecturl = allRedirectUrls.get(i);
			try{
				Property property = ((RedirectUrlDocument)redirecturl).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(redirecturl);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(redirecturl);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(redirecturl);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<RedirectUrl> getRedirectUrlsByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getRedirectUrlsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on RedirectUrls
	 */
	public QueryResult executeQueryOnRedirectUrls(DocumentQuery query){
		List<RedirectUrl> allRedirectUrls = getRedirectUrls();
		QueryResult result = new QueryResult();
		for (int i=0; i<allRedirectUrls.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allRedirectUrls.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all RedirectUrl objects, where property matches.
	 */
	public List<RedirectUrl> getRedirectUrlsByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<RedirectUrl> ret = new ArrayList<>();
		List<RedirectUrl> src = getRedirectUrls();
		for ( RedirectUrl redirecturl : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(redirecturl.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(redirecturl);
		}
		return ret;
	}

	/**
	 * Returns all RedirectUrl objects, where property matches, sorted
	 */
	public List<RedirectUrl> getRedirectUrlsByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getRedirectUrlsByProperty(property), sortType);
	}

	/**
	 * Returns RedirectUrl objects count.
	 */
	public int getRedirectUrlsCount() {
		return _getModuleASSiteData().getRedirectUrls().size();
	}

	/**
	 * Returns RedirectUrl objects segment.
	 */
	public List<RedirectUrl> getRedirectUrls(Segment aSegment) {
		return Slicer.slice(aSegment, getRedirectUrls()).getSliceData();
	}

	/**
	 * Returns RedirectUrl objects segment, where property matched.
	 */
	public List<RedirectUrl> getRedirectUrlsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<RedirectUrl> ret = new ArrayList<>();
		List<RedirectUrl> src = getRedirectUrls();
		for (RedirectUrl redirecturl : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(redirecturl.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(redirecturl);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns RedirectUrl objects segment, where property matched, sorted.
	 */
	public List<RedirectUrl> getRedirectUrlsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getRedirectUrlsByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchRedirectUrl(final String id, Set<String> addedDocuments, JSONArray data) throws ASSiteDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("RedirectUrl" + id))
			return;

		try {
			final RedirectUrlDocument redirecturl = _getModuleASSiteData().getRedirectUrl(id);
			addedDocuments.add("RedirectUrl" + id);



			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(redirecturl);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASSiteData");
			dataObject.put("document", "ASSiteData_RedirectUrl");

			data.put(dataObject);

		}catch(IOException e){
			throw new ASSiteDataServiceException ("Problem with fetching data for this RedirectUrl instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASSiteDataServiceException ("Problem with fetching data for this RedirectUrl instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredRedirectUrl(final JSONObject data) throws ASSiteDataServiceException {
		try {
			String objectData = data.getString("object");
			RedirectUrl redirecturl = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), RedirectUrlDocument.class);

			try {
				updateRedirectUrl(redirecturl);
			}catch(Exception e){
				importRedirectUrl(redirecturl);
			}
		}catch(JSONException e){
			throw new ASSiteDataServiceException("Problem with getting data from json RedirectUrl instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASSiteDataServiceException("Problem with parsing data for this RedirectUrl instance :" + e.getMessage());
		}
	}

	public void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ASSiteDataServiceException {
		switch(documentName) {
			case DOCUMENT_ASSITEDATA_PAGETEMPLATE:
				saveTransferredPageTemplate(data);
				break;
			case DOCUMENT_ASSITEDATA_MEDIALINK:
				saveTransferredMediaLink(data);
				break;
			case DOCUMENT_ASSITEDATA_SCRIPT:
				saveTransferredScript(data);
				break;
			case DOCUMENT_ASSITEDATA_SITE:
				saveTransferredSite(data);
				break;
			case DOCUMENT_ASSITEDATA_NAVIITEM:
				saveTransferredNaviItem(data);
				break;
			case DOCUMENT_ASSITEDATA_ENTRYPOINT:
				saveTransferredEntryPoint(data);
				break;
			case DOCUMENT_ASSITEDATA_PAGEALIAS:
				saveTransferredPageAlias(data);
				break;
			case DOCUMENT_ASSITEDATA_REDIRECTURL:
				saveTransferredRedirectUrl(data);
				break;
			default:
				log.info("There is no correct document: " + documentName + "in this service");
				throw new ASSiteDataServiceException("No such document");
		}
	}

	/**
	 * Copies all multilingual fields from sourceLanguage to targetLanguage in all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public void copyMultilingualAttributesInAllObjects(String sourceLanguage, String targetLanguage){
		copyMultilingualAttributesInAllSites(sourceLanguage, targetLanguage);
		copyMultilingualAttributesInAllNaviItems(sourceLanguage, targetLanguage);
	}

	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public QueryResult executeQueryOnAllObjects(DocumentQuery query){
		QueryResult ret = new QueryResult();
		ret.add(executeQueryOnPageTemplates(query).getEntries());
		ret.add(executeQueryOnMediaLinks(query).getEntries());
		ret.add(executeQueryOnScripts(query).getEntries());
		ret.add(executeQueryOnSites(query).getEntries());
		ret.add(executeQueryOnNaviItems(query).getEntries());
		ret.add(executeQueryOnEntryPoints(query).getEntries());
		ret.add(executeQueryOnPageAliass(query).getEntries());
		ret.add(executeQueryOnRedirectUrls(query).getEntries());
		return ret;
	} //executeQueryOnAllObjects


	public XMLNode exportPageTemplatesToXML(){
		XMLNode ret = new XMLNode("PageTemplates");
		List<PageTemplate> list = getPageTemplates();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (PageTemplate object : list)
			ret.addChildNode(PageTemplateXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportPageTemplatesToXML(List<PageTemplate> list){
		XMLNode ret = new XMLNode("PageTemplates");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (PageTemplate object : list)
			ret.addChildNode(PageTemplateXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportPageTemplatesToXML(String[] languages){
		XMLNode ret = new XMLNode("PageTemplates");
		List<PageTemplate> list = getPageTemplates();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (PageTemplate object : list)
			ret.addChildNode(PageTemplateXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportPageTemplatesToXML(String[] languages, List<PageTemplate> list){
		XMLNode ret = new XMLNode("PageTemplates");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (PageTemplate object : list)
			ret.addChildNode(PageTemplateXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportMediaLinksToXML(){
		XMLNode ret = new XMLNode("MediaLinks");
		List<MediaLink> list = getMediaLinks();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (MediaLink object : list)
			ret.addChildNode(MediaLinkXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportMediaLinksToXML(List<MediaLink> list){
		XMLNode ret = new XMLNode("MediaLinks");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (MediaLink object : list)
			ret.addChildNode(MediaLinkXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportMediaLinksToXML(String[] languages){
		XMLNode ret = new XMLNode("MediaLinks");
		List<MediaLink> list = getMediaLinks();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (MediaLink object : list)
			ret.addChildNode(MediaLinkXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportMediaLinksToXML(String[] languages, List<MediaLink> list){
		XMLNode ret = new XMLNode("MediaLinks");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (MediaLink object : list)
			ret.addChildNode(MediaLinkXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportScriptsToXML(){
		XMLNode ret = new XMLNode("Scripts");
		List<Script> list = getScripts();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Script object : list)
			ret.addChildNode(ScriptXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportScriptsToXML(List<Script> list){
		XMLNode ret = new XMLNode("Scripts");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Script object : list)
			ret.addChildNode(ScriptXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportScriptsToXML(String[] languages){
		XMLNode ret = new XMLNode("Scripts");
		List<Script> list = getScripts();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Script object : list)
			ret.addChildNode(ScriptXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportScriptsToXML(String[] languages, List<Script> list){
		XMLNode ret = new XMLNode("Scripts");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Script object : list)
			ret.addChildNode(ScriptXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportSitesToXML(){
		XMLNode ret = new XMLNode("Sites");
		List<Site> list = getSites();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Site object : list)
			ret.addChildNode(SiteXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportSitesToXML(List<Site> list){
		XMLNode ret = new XMLNode("Sites");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Site object : list)
			ret.addChildNode(SiteXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportSitesToXML(String[] languages){
		XMLNode ret = new XMLNode("Sites");
		List<Site> list = getSites();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Site object : list)
			ret.addChildNode(SiteXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportSitesToXML(String[] languages, List<Site> list){
		XMLNode ret = new XMLNode("Sites");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Site object : list)
			ret.addChildNode(SiteXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportNaviItemsToXML(){
		XMLNode ret = new XMLNode("NaviItems");
		List<NaviItem> list = getNaviItems();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (NaviItem object : list)
			ret.addChildNode(NaviItemXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportNaviItemsToXML(List<NaviItem> list){
		XMLNode ret = new XMLNode("NaviItems");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (NaviItem object : list)
			ret.addChildNode(NaviItemXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportNaviItemsToXML(String[] languages){
		XMLNode ret = new XMLNode("NaviItems");
		List<NaviItem> list = getNaviItems();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (NaviItem object : list)
			ret.addChildNode(NaviItemXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportNaviItemsToXML(String[] languages, List<NaviItem> list){
		XMLNode ret = new XMLNode("NaviItems");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (NaviItem object : list)
			ret.addChildNode(NaviItemXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportEntryPointsToXML(){
		XMLNode ret = new XMLNode("EntryPoints");
		List<EntryPoint> list = getEntryPoints();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (EntryPoint object : list)
			ret.addChildNode(EntryPointXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportEntryPointsToXML(List<EntryPoint> list){
		XMLNode ret = new XMLNode("EntryPoints");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (EntryPoint object : list)
			ret.addChildNode(EntryPointXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportEntryPointsToXML(String[] languages){
		XMLNode ret = new XMLNode("EntryPoints");
		List<EntryPoint> list = getEntryPoints();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (EntryPoint object : list)
			ret.addChildNode(EntryPointXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportEntryPointsToXML(String[] languages, List<EntryPoint> list){
		XMLNode ret = new XMLNode("EntryPoints");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (EntryPoint object : list)
			ret.addChildNode(EntryPointXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportPageAliassToXML(){
		XMLNode ret = new XMLNode("PageAliass");
		List<PageAlias> list = getPageAliass();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (PageAlias object : list)
			ret.addChildNode(PageAliasXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportPageAliassToXML(List<PageAlias> list){
		XMLNode ret = new XMLNode("PageAliass");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (PageAlias object : list)
			ret.addChildNode(PageAliasXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportPageAliassToXML(String[] languages){
		XMLNode ret = new XMLNode("PageAliass");
		List<PageAlias> list = getPageAliass();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (PageAlias object : list)
			ret.addChildNode(PageAliasXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportPageAliassToXML(String[] languages, List<PageAlias> list){
		XMLNode ret = new XMLNode("PageAliass");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (PageAlias object : list)
			ret.addChildNode(PageAliasXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportRedirectUrlsToXML(){
		XMLNode ret = new XMLNode("RedirectUrls");
		List<RedirectUrl> list = getRedirectUrls();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (RedirectUrl object : list)
			ret.addChildNode(RedirectUrlXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportRedirectUrlsToXML(List<RedirectUrl> list){
		XMLNode ret = new XMLNode("RedirectUrls");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (RedirectUrl object : list)
			ret.addChildNode(RedirectUrlXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportRedirectUrlsToXML(String[] languages){
		XMLNode ret = new XMLNode("RedirectUrls");
		List<RedirectUrl> list = getRedirectUrls();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (RedirectUrl object : list)
			ret.addChildNode(RedirectUrlXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportRedirectUrlsToXML(String[] languages, List<RedirectUrl> list){
		XMLNode ret = new XMLNode("RedirectUrls");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (RedirectUrl object : list)
			ret.addChildNode(RedirectUrlXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportToXML(){
		XMLNode ret = new XMLNode("ASSiteData");

		ret.addChildNode(exportPageTemplatesToXML());
		ret.addChildNode(exportMediaLinksToXML());
		ret.addChildNode(exportScriptsToXML());
		ret.addChildNode(exportSitesToXML());
		ret.addChildNode(exportNaviItemsToXML());
		ret.addChildNode(exportEntryPointsToXML());
		ret.addChildNode(exportPageAliassToXML());
		ret.addChildNode(exportRedirectUrlsToXML());

		return ret;
	}
	public XMLNode exportToXML(String[] languages){
		XMLNode ret = new XMLNode("ASSiteData");

		ret.addChildNode(exportPageTemplatesToXML(languages));
		ret.addChildNode(exportMediaLinksToXML(languages));
		ret.addChildNode(exportScriptsToXML(languages));
		ret.addChildNode(exportSitesToXML(languages));
		ret.addChildNode(exportNaviItemsToXML(languages));
		ret.addChildNode(exportEntryPointsToXML(languages));
		ret.addChildNode(exportPageAliassToXML(languages));
		ret.addChildNode(exportRedirectUrlsToXML(languages));

		return ret;
	}
}
