/**
 ********************************************************************************
 *** SiteDocument.java                                                        ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.data;

import net.anotheria.asg.data.AbstractASGDocument;
import java.util.List;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.anodoc.util.context.ContextManager;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.anodoc.data.BooleanProperty;
import net.anotheria.util.crypt.MD5Util;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.BasicComparable;
import net.anotheria.asg.data.MultilingualObject;

public class SiteDocument extends AbstractASGDocument implements Site, IComparable, MultilingualObject{

	public SiteDocument() {
		super("");
	}

	public SiteDocument(String id){
		super(id);
	}

	public SiteDocument(SiteDocument toClone){
		super(toClone);
	}

	SiteDocument(SiteBuilder builder){
		super("");
		setName(builder.name);
		setTitle(builder.title);
		setKeywords(builder.keywords);
		setDescription(builder.description);
		setSubtitle(builder.subtitle);
		setMainNavi(builder.mainNavi);
		setTopNavi(builder.topNavi);
		setLanguageselector(builder.languageselector);
		setStartpage(builder.startpage);
		setSearchpage(builder.searchpage);
		setHeaderBackground(builder.headerBackground);
		setSiteLogo(builder.siteLogo);
	}

	public String getName(){
		return getString(PROP_NAME);
	}

	public void setName(String value){
		setString(PROP_NAME, value);
	}

	public String getTitleEN(){
		return getString(PROP_TITLE_EN);
	}

	public String getTitle(){
		return getString("title_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage()));
	}


	public void setTitleEN(String value){
		setString(PROP_TITLE_EN, value);
	}

	public void setTitle(String value){
		setString(("title_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage())), value);
	}


	public String getKeywordsEN(){
		return getString(PROP_KEYWORDS_EN);
	}

	public String getKeywords(){
		return getString("keywords_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage()));
	}


	public void setKeywordsEN(String value){
		setString(PROP_KEYWORDS_EN, value);
	}

	public void setKeywords(String value){
		setString(("keywords_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage())), value);
	}


	public String getDescriptionEN(){
		return getString(PROP_DESCRIPTION_EN);
	}

	public String getDescription(){
		return getString("description_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage()));
	}


	public void setDescriptionEN(String value){
		setString(PROP_DESCRIPTION_EN, value);
	}

	public void setDescription(String value){
		setString(("description_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage())), value);
	}


	public String getSubtitleEN(){
		return getString(PROP_SUBTITLE_EN);
	}

	public String getSubtitle(){
		return getString("subtitle_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage()));
	}


	public void setSubtitleEN(String value){
		setString(PROP_SUBTITLE_EN, value);
	}

	public void setSubtitle(String value){
		setString(("subtitle_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage())), value);
	}


	public List<String> getMainNavi(){
		return copyToStringList(getList(PROP_MAIN_NAVI));
	}

	public void setMainNavi(List<String> value){
		setList(PROP_MAIN_NAVI, copyFromStringList(value));
	}

	public List<String> getTopNavi(){
		return copyToStringList(getList(PROP_TOP_NAVI));
	}

	public void setTopNavi(List<String> value){
		setList(PROP_TOP_NAVI, copyFromStringList(value));
	}

	public boolean getLanguageselector(){
		return getBoolean(PROP_LANGUAGESELECTOR);
	}

	public void setLanguageselector(boolean value){
		setBoolean(PROP_LANGUAGESELECTOR, value);
	}

	public String getStartpage(){
		return getString(LINK_PROP_STARTPAGE);
	}

	public void setStartpage(String value){
		setString(LINK_PROP_STARTPAGE, value);
	}

	public String getSearchpage(){
		return getString(LINK_PROP_SEARCHPAGE);
	}

	public void setSearchpage(String value){
		setString(LINK_PROP_SEARCHPAGE, value);
	}

	public String getHeaderBackground(){
		return getString(LINK_PROP_HEADER_BACKGROUND);
	}

	public void setHeaderBackground(String value){
		setString(LINK_PROP_HEADER_BACKGROUND, value);
	}

	public String getSiteLogo(){
		return getString(LINK_PROP_SITE_LOGO);
	}

	public void setSiteLogo(String value){
		setString(LINK_PROP_SITE_LOGO, value);
	}


	public String toString(){
		String ret = "Site ";
		ret += "["+getId()+"] ";
		ret += "name: "+getName();
		ret += ", ";
		ret += "title: "+getTitle();
		ret += ", ";
		ret += "keywords: "+getKeywords();
		ret += ", ";
		ret += "description: "+getDescription();
		ret += ", ";
		ret += "subtitle: "+getSubtitle();
		ret += ", ";
		ret += "mainNavi: "+getMainNavi();
		ret += ", ";
		ret += "topNavi: "+getTopNavi();
		ret += ", ";
		ret += "languageselector: "+getLanguageselector();
		return ret;
	}

	public int getMainNaviSize(){
		return getList(PROP_MAIN_NAVI).size();
	}

	public void addMainNaviElement(String item){
		getListPropertyAnyCase(PROP_MAIN_NAVI).add(new StringProperty("" + item, item));
	} //method

	public void removeMainNaviElement(int index){
		getListProperty(PROP_MAIN_NAVI).remove(index);
	} //method

	public void swapMainNaviElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_MAIN_NAVI).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_MAIN_NAVI).get(index2)).getString();
		((StringProperty)getList(PROP_MAIN_NAVI).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_MAIN_NAVI).get(index2)).setString(tmp1);
	} //method

	public String getMainNaviElement(int index){
		StringProperty p = (StringProperty)getList(PROP_MAIN_NAVI).get(index);
		return p.getString();
	} //method

	public int getTopNaviSize(){
		return getList(PROP_TOP_NAVI).size();
	}

	public void addTopNaviElement(String item){
		getListPropertyAnyCase(PROP_TOP_NAVI).add(new StringProperty("" + item, item));
	} //method

	public void removeTopNaviElement(int index){
		getListProperty(PROP_TOP_NAVI).remove(index);
	} //method

	public void swapTopNaviElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_TOP_NAVI).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_TOP_NAVI).get(index2)).getString();
		((StringProperty)getList(PROP_TOP_NAVI).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_TOP_NAVI).get(index2)).setString(tmp1);
	} //method

	public String getTopNaviElement(int index){
		StringProperty p = (StringProperty)getList(PROP_TOP_NAVI).get(index);
		return p.getString();
	} //method


	public int compareTo(Site comparable){
		return compareTo(comparable, SiteSortType.SORT_BY_DEFAULT);
	}

	public int compareTo(IComparable anotherComparable, int method){
		SiteDocument anotherDoc = (SiteDocument) anotherComparable;
		switch(method){
			case SiteSortType.SORT_BY_ID:
				return BasicComparable.compareString(getId(), anotherDoc.getId());
			case SiteSortType.SORT_BY_NAME:
				return BasicComparable.compareString(getName(), anotherDoc.getName());
			case SiteSortType.SORT_BY_TITLE:
				return BasicComparable.compareString(getTitle(), anotherDoc.getTitle());
			case SiteSortType.SORT_BY_KEYWORDS:
				return BasicComparable.compareString(getKeywords(), anotherDoc.getKeywords());
			case SiteSortType.SORT_BY_DESCRIPTION:
				return BasicComparable.compareString(getDescription(), anotherDoc.getDescription());
			case SiteSortType.SORT_BY_SUBTITLE:
				return BasicComparable.compareString(getSubtitle(), anotherDoc.getSubtitle());
			case SiteSortType.SORT_BY_LANGUAGESELECTOR:
				return BasicComparable.compareBoolean(getLanguageselector(), anotherDoc.getLanguageselector());
			case SiteSortType.SORT_BY_STARTPAGE:
				return BasicComparable.compareString(getStartpage(), anotherDoc.getStartpage());
			case SiteSortType.SORT_BY_SEARCHPAGE:
				return BasicComparable.compareString(getSearchpage(), anotherDoc.getSearchpage());
			case SiteSortType.SORT_BY_HEADERBACKGROUND:
				return BasicComparable.compareString(getHeaderBackground(), anotherDoc.getHeaderBackground());
			case SiteSortType.SORT_BY_SITELOGO:
				return BasicComparable.compareString(getSiteLogo(), anotherDoc.getSiteLogo());
			default:
				throw new RuntimeException("Sort method "+method+" is not supported.");
		}
	}

	public String getDefinedName(){
		return "Site";
	}

	public String getDefinedParentName(){
		return "ASSiteData";
	}

	public String getFootprint(){
		StringBuilder footprint = new StringBuilder();
		footprint.append(getName());
		footprint.append(getTitleEN());
		footprint.append(getKeywordsEN());
		footprint.append(getDescriptionEN());
		footprint.append(getSubtitleEN());
		footprint.append(getMainNavi());
		footprint.append(getTopNavi());
		footprint.append(getLanguageselector());
		footprint.append(getStartpage());
		footprint.append(getSearchpage());
		footprint.append(getHeaderBackground());
		footprint.append(getSiteLogo());
		return MD5Util.getMD5Hash(footprint);
	}
	public void copyLANG2LANG(String sourceLanguage, String destLanguage){
	}


	public boolean isMultilingualDisabledInstance(){
		try{
			return ((BooleanProperty)getInternalProperty(INT_PROPERTY_MULTILINGUAL_DISABLED)).getboolean();
		}catch(NoSuchPropertyException e){
			return false;
		}
	}

	public void setMultilingualDisabledInstance(boolean value){
		setInternalProperty(new BooleanProperty(INT_PROPERTY_MULTILINGUAL_DISABLED, value));
	}

	public boolean equals(Object o){
		return o == this || ((o instanceof SiteDocument) && ((SiteDocument)o).getId().equals(getId()));
	}
}
