/**
 ********************************************************************************
 *** MultiOpEntryPointsDomainsAction.java                                     ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import java.util.List;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.assitedata.data.EntryPointFactory;
import net.anotheria.anosite.gen.assitedata.data.EntryPoint;
import net.anotheria.anosite.gen.assitedata.bean.DomainsElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpEntryPointsDomainsAction extends BaseEntryPointAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("assitedataEntryPointDomainsShow"))
			return assitedataEntryPointDomainsShow(mapping, req, res);
		if (path.equals("assitedataEntryPointDomainsAdd"))
			return assitedataEntryPointDomainsAdd(mapping, req, res);
		if (path.equals("assitedataEntryPointDomainsDelete"))
			return assitedataEntryPointDomainsDelete(mapping, req, res);
		if (path.equals("assitedataEntryPointDomainsMove"))
			return assitedataEntryPointDomainsMove(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand assitedataEntryPointDomainsShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		EntryPoint entrypoint = getASSiteDataService().getEntryPoint(id);
		addBeanToRequest(req, "ownerId", id);
		checkEntryPoints(entrypoint, req);

		DomainsElementFB form = new DomainsElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(entrypoint.getId());
		addBeanToRequest(req, "assitedataEntryPointDomainsElementForm", form);

		// generate list ...
		int size = entrypoint.getDomainsSize();
		List<DomainsElementFB> beans = new ArrayList<DomainsElementFB>(size);
		for (int i=0; i<size; i++){
			String value = entrypoint.getDomainsElement(i);
			DomainsElementFB bean = new DomainsElementFB();
			bean.setOwnerId(entrypoint.getId());
			bean.setPosition(i);
			bean.setDomain(value);
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand assitedataEntryPointDomainsDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		EntryPoint entrypointCurr = getASSiteDataService().getEntryPoint(id);
		canUpdateEntryPoints(entrypointCurr, req);
		checkEntryPoints(entrypointCurr, req);
		int position = getIntParameter(req, "pPosition");
		EntryPoint entrypoint = getASSiteDataService().getEntryPoint(id);
		entrypoint.removeDomainsElement(position);
		getASSiteDataService().updateEntryPoint(entrypoint);
		return assitedataEntryPointDomainsShow(mapping, req, res);
	}

	public ActionCommand assitedataEntryPointDomainsMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		EntryPoint entrypoint = getASSiteDataService().getEntryPoint(id);
		canUpdateEntryPoints(entrypoint, req);
		checkEntryPoints(entrypoint, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(entrypoint, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(entrypoint, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(entrypoint, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(entrypoint, position);
		return assitedataEntryPointDomainsShow(mapping, req, res);
	}

	private void moveUp(EntryPoint entrypoint, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		entrypoint.swapDomainsElement(position, position-1);
		getASSiteDataService().updateEntryPoint(entrypoint);
	}

	private void moveTop(EntryPoint entrypoint, int position) throws ASGRuntimeException {
		List<String> targetList = entrypoint.getDomains();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		entrypoint.setDomains(targetList);
		getASSiteDataService().updateEntryPoint(entrypoint);
	}

	private void moveDown(EntryPoint entrypoint, int position) throws ASGRuntimeException {
		if (position<entrypoint.getDomainsSize()-1){
			entrypoint.swapDomainsElement(position, position+1);
			getASSiteDataService().updateEntryPoint(entrypoint);
		}
	}

	private void moveBottom(EntryPoint entrypoint, int position) throws ASGRuntimeException {
		List<String> targetList = entrypoint.getDomains();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		entrypoint.setDomains(targetList);
		getASSiteDataService().updateEntryPoint(entrypoint);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand assitedataEntryPointDomainsAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		DomainsElementFB form = new DomainsElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		EntryPoint entrypoint;
		entrypoint = getASSiteDataService().getEntryPoint(id);
		canUpdateEntryPoints(entrypoint, req);
		checkEntryPoints(entrypoint, req);
		entrypoint.addDomainsElement(form.getDomain());
		getASSiteDataService().updateEntryPoint(entrypoint);
		return assitedataEntryPointDomainsShow(mapping, req, res);
	}

}
