/**
 ********************************************************************************
 *** MultiOpDialogPageTemplatesAction.java                                    ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import net.anotheria.util.NumberUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.assitedata.data.PageTemplateFactory;
import net.anotheria.anosite.gen.assitedata.data.PageTemplate;
import net.anotheria.anosite.gen.assitedata.bean.EditPageTemplateFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;

public class MultiOpDialogPageTemplatesAction extends BasePageTemplateAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("assitedataPageTemplateDelete"))
			return assitedataPageTemplateDelete(mapping, req, res);
		if (path.equals("assitedataPageTemplateDuplicate"))
			return assitedataPageTemplateDuplicate(mapping, req, res);
		if (path.equals("assitedataPageTemplateUpdate"))
			return assitedataPageTemplateUpdate(mapping, req, res);
		if (path.equals("assitedataPageTemplateClose"))
			return assitedataPageTemplateClose(mapping, req, res);
		if (path.equals("assitedataPageTemplateLock"))
			return assitedataPageTemplateLock(mapping, req, res);
		if (path.equals("assitedataPageTemplateUnLock"))
			return assitedataPageTemplateUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand assitedataPageTemplateDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			PageTemplate pagetemplateCurr = getASSiteDataService().getPageTemplate(id);
			if (pagetemplateCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)pagetemplateCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASSiteDataService().deletePageTemplate(id);
		}
		res.sendRedirect("assitedataPageTemplateShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand assitedataPageTemplateDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		PageTemplate pagetemplateSrc = getASSiteDataService().getPageTemplate(id);
		PageTemplate pagetemplateDest = PageTemplateFactory.createPageTemplate(pagetemplateSrc);














		PageTemplate pagetemplateCreated = getASSiteDataService().createPageTemplate(pagetemplateDest);
		res.sendRedirect("assitedataPageTemplateEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+pagetemplateCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand assitedataPageTemplateUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditPageTemplateFB form = new EditPageTemplateFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		PageTemplate pagetemplate = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		pagetemplate = (PageTemplate)getASSiteDataService().getPageTemplate(form.getId()).clone();
	}else{
		pagetemplate = PageTemplateFactory.createPageTemplate();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	pagetemplate.setName(form.getName());
	pagetemplate.setLayout(form.getLayout());
	pagetemplate.setSite(form.getSite());
	// skipped container mediaLinks
	// skipped container scripts
	// skipped container localizations
	// skipped container c1first
	// skipped container c2first
	// skipped container c3first
	// skipped container c1last
	// skipped container c2last
	// skipped container c3last
	// skipped container meta
	// skipped container header
	// skipped container footer
	pagetemplate.setDescription(form.getDescription());

	PageTemplate updatedCopy = null;
	if (create){
		updatedCopy = getASSiteDataService().createPageTemplate(pagetemplate);
	}else{
		canUpdatePageTemplates(pagetemplate, req);
		checkPageTemplates(pagetemplate, req);
		updatedCopy = getASSiteDataService().updatePageTemplate(pagetemplate);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("assitedataPageTemplateEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(pagetemplate, req);
		res.sendRedirect("assitedataPageTemplateShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(PageTemplate pagetemplate, HttpServletRequest req) throws Exception{
	if(((LockableObject)pagetemplate).isLocked())
		unLockPageTemplates(pagetemplate, req, false);
}

public ActionCommand assitedataPageTemplateLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	PageTemplate pagetemplateCurr = id != null && !id.equals("") ? getASSiteDataService().getPageTemplate(id) : null;
	if(pagetemplateCurr != null && pagetemplateCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)pagetemplateCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockPageTemplates(pagetemplateCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, pagetemplateCurr));
	return null;
}

public ActionCommand assitedataPageTemplateUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	PageTemplate pagetemplateCurr = id != null && !id.equals("") ? getASSiteDataService().getPageTemplate(id) : null;
	if(pagetemplateCurr != null && pagetemplateCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)pagetemplateCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockPageTemplates(pagetemplateCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, pagetemplateCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, PageTemplate item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "assitedataPageTemplateShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "assitedataPageTemplateEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "assitedataPageTemplateShow?ts="+System.currentTimeMillis();
}

public ActionCommand assitedataPageTemplateClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	PageTemplate pagetemplateCurr = id != null && !id.equals("") ? getASSiteDataService().getPageTemplate(id) : null;
	if(pagetemplateCurr != null && pagetemplateCurr instanceof LockableObject && ((LockableObject)pagetemplateCurr).isLocked()) 
		unLockPageTemplates(pagetemplateCurr, req, false);
	res.sendRedirect("assitedataPageTemplateShow?ts="+System.currentTimeMillis());
	return null;
}

}
