/**
 ********************************************************************************
 *** BasePageTemplateAction.java                                              ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import net.anotheria.anosite.gen.shared.action.BaseSitexAction;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.assitedata.data.PageTemplate;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BasePageTemplateAction extends BaseSitexAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Template";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASSiteData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "PageTemplate";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, PageTemplate pagetemplate) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASSiteData.PageTemplate").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.PageTemplate", pagetemplate, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.PageTemplate", pagetemplate, "mediaLinks");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.mediaLinks", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.PageTemplate", pagetemplate, "scripts");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.scripts", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.PageTemplate", pagetemplate, "c1first");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.c1first", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.PageTemplate", pagetemplate, "c2first");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.c2first", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.PageTemplate", pagetemplate, "c3first");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.c3first", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.PageTemplate", pagetemplate, "c1last");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.c1last", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.PageTemplate", pagetemplate, "c2last");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.c2last", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.PageTemplate", pagetemplate, "c3last");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.c3last", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.PageTemplate", pagetemplate, "meta");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.meta", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.PageTemplate", pagetemplate, "header");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.header", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.PageTemplate", pagetemplate, "footer");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.footer", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.PageTemplate", pagetemplate, "localizations");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.localizations", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.PageTemplate", pagetemplate, "description");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.description", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockPageTemplates(PageTemplate pagetemplate, HttpServletRequest req) throws Exception{
		if(pagetemplate instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)pagetemplate;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASSiteDataService().updatePageTemplate( pagetemplate);
			logger.info("Lock-OPERATION, document with id : ["+pagetemplate.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockPageTemplates(PageTemplate pagetemplate, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(pagetemplate instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)pagetemplate;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASSiteDataService().updatePageTemplate( pagetemplate);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+pagetemplate.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+pagetemplate.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkPageTemplates(PageTemplate pagetemplate, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = pagetemplate instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)pagetemplate).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)pagetemplate).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockPageTemplates(pagetemplate, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdatePageTemplates(PageTemplate pagetemplate, HttpServletRequest req) throws Exception{
		if(pagetemplate instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)pagetemplate, false, getUserId(req));
		}
		if (isTimeoutReached(pagetemplate)) {
			checkPageTemplates(pagetemplate, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(pagetemplate, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(PageTemplate pagetemplate){
		if (pagetemplate instanceof LockableObject) {
			LockableObject lock = (LockableObject)pagetemplate;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(PageTemplate pagetemplate, HttpServletRequest req){
		if (pagetemplate instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)pagetemplate;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
