/**
 ********************************************************************************
 *** BasePageAliasAction.java                                                 ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import net.anotheria.anosite.gen.shared.action.BaseSitexAction;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.assitedata.data.PageAlias;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BasePageAliasAction extends BaseSitexAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "PageAlias";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASSiteData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "PageAlias";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, PageAlias pagealias) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASSiteData.PageAlias").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.PageAlias", pagealias, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.PageAlias", pagealias, "parameters");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameters", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.PageAlias", pagealias, "type");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.type", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.PageAlias", pagealias, "pathes");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.pathes", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockPageAliass(PageAlias pagealias, HttpServletRequest req) throws Exception{
		if(pagealias instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)pagealias;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASSiteDataService().updatePageAlias( pagealias);
			logger.info("Lock-OPERATION, document with id : ["+pagealias.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockPageAliass(PageAlias pagealias, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(pagealias instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)pagealias;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASSiteDataService().updatePageAlias( pagealias);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+pagealias.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+pagealias.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkPageAliass(PageAlias pagealias, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = pagealias instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)pagealias).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)pagealias).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockPageAliass(pagealias, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdatePageAliass(PageAlias pagealias, HttpServletRequest req) throws Exception{
		if(pagealias instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)pagealias, false, getUserId(req));
		}
		if (isTimeoutReached(pagealias)) {
			checkPageAliass(pagealias, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(pagealias, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(PageAlias pagealias){
		if (pagealias instanceof LockableObject) {
			LockableObject lock = (LockableObject)pagealias;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(PageAlias pagealias, HttpServletRequest req){
		if (pagealias instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)pagealias;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
