/**
 ********************************************************************************
 *** BasePdfTemplateAction.java                                               ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.action;

import net.anotheria.anosite.gen.shared.action.BaseResourcesAction;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.asresourcedata.data.PdfTemplate;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BasePdfTemplateAction extends BaseResourcesAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Pdf Templates";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASResourceData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "PdfTemplate";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, PdfTemplate pdftemplate) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASResourceData.PdfTemplate").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.PdfTemplate", pdftemplate, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.PdfTemplate", pdftemplate, "showPageNumbers");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.showPageNumbers", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.PdfTemplate", pdftemplate, "applyBackgroundStyles");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.applyBackgroundStyles", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.PdfTemplate", pdftemplate, "headerTemplate");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.headerTemplate", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.PdfTemplate", pdftemplate, "headerMargin");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.headerMargin", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.PdfTemplate", pdftemplate, "footerTemplate");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.footerTemplate", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.PdfTemplate", pdftemplate, "footerMargin");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.footerMargin", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.PdfTemplate", pdftemplate, "contentTemplate");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.contentTemplate", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.PdfTemplate", pdftemplate, "localizations");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.localizations", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockPdfTemplates(PdfTemplate pdftemplate, HttpServletRequest req) throws Exception{
		if(pdftemplate instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)pdftemplate;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASResourceDataService().updatePdfTemplate( pdftemplate);
			logger.info("Lock-OPERATION, document with id : ["+pdftemplate.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockPdfTemplates(PdfTemplate pdftemplate, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(pdftemplate instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)pdftemplate;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASResourceDataService().updatePdfTemplate( pdftemplate);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+pdftemplate.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+pdftemplate.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkPdfTemplates(PdfTemplate pdftemplate, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = pdftemplate instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)pdftemplate).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)pdftemplate).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockPdfTemplates(pdftemplate, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdatePdfTemplates(PdfTemplate pdftemplate, HttpServletRequest req) throws Exception{
		if(pdftemplate instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)pdftemplate, false, getUserId(req));
		}
		if (isTimeoutReached(pdftemplate)) {
			checkPdfTemplates(pdftemplate, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(pdftemplate, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(PdfTemplate pdftemplate){
		if (pdftemplate instanceof LockableObject) {
			LockableObject lock = (LockableObject)pdftemplate;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(PdfTemplate pdftemplate, HttpServletRequest req){
		if (pdftemplate instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)pdftemplate;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
