/**
 ********************************************************************************
 *** BaseImageAction.java                                                     ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.action;

import net.anotheria.anosite.gen.shared.action.BaseResourcesAction;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.asresourcedata.data.Image;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseImageAction extends BaseResourcesAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Pictures";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASResourceData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "Image";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, Image image) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASResourceData.Image").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.Image", image, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.Image", image, "title");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.title", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.Image", image, "alias");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.alias", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.Image", image, "alt");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.alt", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.Image", image, "image");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.image", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.Image", image, "size");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.size", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.Image", image, "pixels");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.pixels", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockImages(Image image, HttpServletRequest req) throws Exception{
		if(image instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)image;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASResourceDataService().updateImage( image);
			logger.info("Lock-OPERATION, document with id : ["+image.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockImages(Image image, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(image instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)image;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASResourceDataService().updateImage( image);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+image.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+image.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkImages(Image image, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = image instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)image).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)image).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockImages(image, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateImages(Image image, HttpServletRequest req) throws Exception{
		if(image instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)image, false, getUserId(req));
		}
		if (isTimeoutReached(image)) {
			checkImages(image, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(image, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(Image image){
		if (image instanceof LockableObject) {
			LockableObject lock = (LockableObject)image;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(Image image, HttpServletRequest req){
		if (image instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)image;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
