/**
 ********************************************************************************
 *** MultiOpDialogPageStylesAction.java                                       ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aslayoutdata.action;

import net.anotheria.util.NumberUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.aslayoutdata.data.PageStyleFactory;
import net.anotheria.anosite.gen.aslayoutdata.data.PageStyle;
import net.anotheria.anosite.gen.aslayoutdata.bean.EditPageStyleFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;

public class MultiOpDialogPageStylesAction extends BasePageStyleAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("aslayoutdataPageStyleDelete"))
			return aslayoutdataPageStyleDelete(mapping, req, res);
		if (path.equals("aslayoutdataPageStyleDuplicate"))
			return aslayoutdataPageStyleDuplicate(mapping, req, res);
		if (path.equals("aslayoutdataPageStyleUpdate"))
			return aslayoutdataPageStyleUpdate(mapping, req, res);
		if (path.equals("aslayoutdataPageStyleClose"))
			return aslayoutdataPageStyleClose(mapping, req, res);
		if (path.equals("aslayoutdataPageStyleLock"))
			return aslayoutdataPageStyleLock(mapping, req, res);
		if (path.equals("aslayoutdataPageStyleUnLock"))
			return aslayoutdataPageStyleUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand aslayoutdataPageStyleDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			PageStyle pagestyleCurr = getASLayoutDataService().getPageStyle(id);
			if (pagestyleCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)pagestyleCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASLayoutDataService().deletePageStyle(id);
		}
		res.sendRedirect("aslayoutdataPageStyleShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand aslayoutdataPageStyleDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		PageStyle pagestyleSrc = getASLayoutDataService().getPageStyle(id);
		PageStyle pagestyleDest = PageStyleFactory.createPageStyle(pagestyleSrc);


		PageStyle pagestyleCreated = getASLayoutDataService().createPageStyle(pagestyleDest);
		res.sendRedirect("aslayoutdataPageStyleEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+pagestyleCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand aslayoutdataPageStyleUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditPageStyleFB form = new EditPageStyleFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		PageStyle pagestyle = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		pagestyle = (PageStyle)getASLayoutDataService().getPageStyle(form.getId()).clone();
	}else{
		pagestyle = PageStyleFactory.createPageStyle();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	pagestyle.setName(form.getName());
	pagestyle.setCss(form.getCss());
	pagestyle.setDescription(form.getDescription());

	PageStyle updatedCopy = null;
	if (create){
		updatedCopy = getASLayoutDataService().createPageStyle(pagestyle);
	}else{
		canUpdatePageStyles(pagestyle, req);
		checkPageStyles(pagestyle, req);
		updatedCopy = getASLayoutDataService().updatePageStyle(pagestyle);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("aslayoutdataPageStyleEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(pagestyle, req);
		res.sendRedirect("aslayoutdataPageStyleShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(PageStyle pagestyle, HttpServletRequest req) throws Exception{
	if(((LockableObject)pagestyle).isLocked())
		unLockPageStyles(pagestyle, req, false);
}

public ActionCommand aslayoutdataPageStyleLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	PageStyle pagestyleCurr = id != null && !id.equals("") ? getASLayoutDataService().getPageStyle(id) : null;
	if(pagestyleCurr != null && pagestyleCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)pagestyleCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockPageStyles(pagestyleCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, pagestyleCurr));
	return null;
}

public ActionCommand aslayoutdataPageStyleUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	PageStyle pagestyleCurr = id != null && !id.equals("") ? getASLayoutDataService().getPageStyle(id) : null;
	if(pagestyleCurr != null && pagestyleCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)pagestyleCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockPageStyles(pagestyleCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, pagestyleCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, PageStyle item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "aslayoutdataPageStyleShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "aslayoutdataPageStyleEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "aslayoutdataPageStyleShow?ts="+System.currentTimeMillis();
}

public ActionCommand aslayoutdataPageStyleClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	PageStyle pagestyleCurr = id != null && !id.equals("") ? getASLayoutDataService().getPageStyle(id) : null;
	if(pagestyleCurr != null && pagestyleCurr instanceof LockableObject && ((LockableObject)pagestyleCurr).isLocked()) 
		unLockPageStyles(pagestyleCurr, req, false);
	res.sendRedirect("aslayoutdataPageStyleShow?ts="+System.currentTimeMillis());
	return null;
}

}
