/**
 ********************************************************************************
 *** BaseGenericBoxTypeAction.java                                            ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asgenericdata.action;

import net.anotheria.anosite.gen.shared.action.BaseDefinitionsAction;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.asgenericdata.data.GenericBoxType;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseGenericBoxTypeAction extends BaseDefinitionsAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Generic BoxType";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASGenericData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "GenericBoxType";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, GenericBoxType genericboxtype) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASGenericData.GenericBoxType").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASGenericData.GenericBoxType", genericboxtype, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASGenericData.GenericBoxType", genericboxtype, "rendererpage");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.rendererpage", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockGenericBoxTypes(GenericBoxType genericboxtype, HttpServletRequest req) throws Exception{
		if(genericboxtype instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)genericboxtype;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASGenericDataService().updateGenericBoxType( genericboxtype);
			logger.info("Lock-OPERATION, document with id : ["+genericboxtype.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockGenericBoxTypes(GenericBoxType genericboxtype, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(genericboxtype instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)genericboxtype;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASGenericDataService().updateGenericBoxType( genericboxtype);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+genericboxtype.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+genericboxtype.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkGenericBoxTypes(GenericBoxType genericboxtype, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = genericboxtype instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)genericboxtype).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)genericboxtype).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockGenericBoxTypes(genericboxtype, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateGenericBoxTypes(GenericBoxType genericboxtype, HttpServletRequest req) throws Exception{
		if(genericboxtype instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)genericboxtype, false, getUserId(req));
		}
		if (isTimeoutReached(genericboxtype)) {
			checkGenericBoxTypes(genericboxtype, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(genericboxtype, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(GenericBoxType genericboxtype){
		if (genericboxtype instanceof LockableObject) {
			LockableObject lock = (LockableObject)genericboxtype;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(GenericBoxType genericboxtype, HttpServletRequest req){
		if (genericboxtype instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)genericboxtype;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
