/**
 ********************************************************************************
 *** ShowBrandFeaturesAction.java                                             ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asfeature.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asfeature.data.BrandFeature;
import net.anotheria.anosite.gen.asfeature.bean.BrandFeatureListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.asfeature.bean.BrandFeatureListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;

public class ShowBrandFeaturesAction extends BaseBrandFeatureAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"BrandFeature";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"BrandFeature";
	private static Logger log = LoggerFactory.getLogger(ShowBrandFeaturesAction.class);
	private Sorter<BrandFeatureListItemBean> sorter;

	private IAttributeDecorator idDecorator;
	private IAttributeDecorator nameDecorator;

	private DocumentFilter nameFilterAZ;

	public ShowBrandFeaturesAction(){
		sorter = new QuickSorter<BrandFeatureListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
			nameDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = BrandFeatureListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = BrandFeatureListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		BrandFeatureListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new BrandFeatureListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (BrandFeatureListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new BrandFeatureListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<BrandFeature> _unfiltered_brandfeatures = getASFeatureService().getBrandFeatures();
		List<BrandFeature> brandfeatures = new ArrayList<BrandFeature>();
		for (int i=0; i<_unfiltered_brandfeatures.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_brandfeatures.get(i), "name", filterParameter0));
			if (mayPass)
				brandfeatures.add(_unfiltered_brandfeatures.get(i));
		}
		List<BrandFeatureListItemBean> beans = new ArrayList<BrandFeatureListItemBean>(brandfeatures.size());
		for (BrandFeature brandfeature : brandfeatures){
			checkBrandFeatures(brandfeature, req);
			BrandFeatureListItemBean bean = makeBrandFeatureListItemBean(brandfeature);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "brandfeatures", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		return mapping.success();
	}

	protected BrandFeatureListItemBean makeBrandFeatureListItemBean(BrandFeature brandfeature) {
		BrandFeatureListItemBean bean = new BrandFeatureListItemBean();
		bean.setPlainId(brandfeature.getId());
		bean.setIdForSorting(brandfeature.getId());
		bean.setId(idDecorator.decorate(brandfeature, "id", "3"));
		bean.setNameForSorting(brandfeature.getName());
		bean.setName(nameDecorator.decorate(brandfeature, "name", "null"));
		bean.setEnabled(brandfeature.getEnabled());
		bean.setActiveInProduction(brandfeature.getActiveInProduction());
		bean.setObsolete(brandfeature.getObsolete());
		bean.setLocked(((LockableObject)brandfeature).isLocked());
		bean.setLockerId(((LockableObject)brandfeature).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)brandfeature).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)brandfeature).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(brandfeature.getLastUpdateTimestamp()));
		return bean;
	}
}
