/**
 ********************************************************************************
 *** BaseFeatureAction.java                                                   ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asfeature.action;

import net.anotheria.anosite.gen.shared.action.BaseFeaturesAction;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.asfeature.data.Feature;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseFeatureAction extends BaseFeaturesAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Features";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASFeature";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "Feature";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, Feature feature) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASFeature.Feature").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASFeature.Feature", feature, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASFeature.Feature", feature, "enabled");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.enabled", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASFeature.Feature", feature, "activeInProduction");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.activeInProduction", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASFeature.Feature", feature, "obsolete");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.obsolete", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASFeature.Feature", feature, "description");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.description", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASFeature.Feature", feature, "guards");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.guards", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockFeatures(Feature feature, HttpServletRequest req) throws Exception{
		if(feature instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)feature;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASFeatureService().updateFeature( feature);
			logger.info("Lock-OPERATION, document with id : ["+feature.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockFeatures(Feature feature, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(feature instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)feature;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASFeatureService().updateFeature( feature);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+feature.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+feature.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkFeatures(Feature feature, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = feature instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)feature).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)feature).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockFeatures(feature, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateFeatures(Feature feature, HttpServletRequest req) throws Exception{
		if(feature instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)feature, false, getUserId(req));
		}
		if (isTimeoutReached(feature)) {
			checkFeatures(feature, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(feature, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(Feature feature){
		if (feature instanceof LockableObject) {
			LockableObject lock = (LockableObject)feature;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(Feature feature, HttpServletRequest req){
		if (feature instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)feature;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
