/**
 ********************************************************************************
 *** ShowExperimentsAction.java                                               ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asexperiment.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asexperiment.data.Experiment;
import net.anotheria.anosite.gen.asexperiment.bean.ExperimentListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.shared.data.ExperimentDistributionEnum;
import net.anotheria.anosite.gen.asexperiment.bean.ExperimentListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;
import net.anotheria.asg.exception.ConstantNotFoundException;

public class ShowExperimentsAction extends BaseExperimentAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"Experiment";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"Experiment";
	private static Logger log = LoggerFactory.getLogger(ShowExperimentsAction.class);
	private Sorter<ExperimentListItemBean> sorter;

	private IAttributeDecorator idDecorator;
	private IAttributeDecorator nameDecorator;

	private DocumentFilter nameFilterAZ;

	public ShowExperimentsAction(){
		sorter = new QuickSorter<ExperimentListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
			nameDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = ExperimentListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = ExperimentListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		ExperimentListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new ExperimentListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (ExperimentListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new ExperimentListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<Experiment> _unfiltered_experiments = getASExperimentService().getExperiments();
		List<Experiment> experiments = new ArrayList<Experiment>();
		for (int i=0; i<_unfiltered_experiments.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_experiments.get(i), "name", filterParameter0));
			if (mayPass)
				experiments.add(_unfiltered_experiments.get(i));
		}
		List<ExperimentListItemBean> beans = new ArrayList<ExperimentListItemBean>(experiments.size());
		for (Experiment experiment : experiments){
			checkExperiments(experiment, req);
			ExperimentListItemBean bean = makeExperimentListItemBean(experiment);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "experiments", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		return mapping.success();
	}

	protected ExperimentListItemBean makeExperimentListItemBean(Experiment experiment) {
		ExperimentListItemBean bean = new ExperimentListItemBean();
		bean.setPlainId(experiment.getId());
		bean.setIdForSorting(experiment.getId());
		bean.setId(idDecorator.decorate(experiment, "id", "3"));
		bean.setNameForSorting(experiment.getName());
		bean.setName(nameDecorator.decorate(experiment, "name", "null"));
		bean.setActive(experiment.getActive());
		try {
			bean.setDistribution(ExperimentDistributionEnum.getConstantByValue(experiment.getDistribution()).name());
		}catch(net.anotheria.asg.exception.ConstantNotFoundException e){
			bean.setDistribution("-----");
		} //try
		bean.setLocked(((LockableObject)experiment).isLocked());
		bean.setLockerId(((LockableObject)experiment).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)experiment).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)experiment).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(experiment.getLastUpdateTimestamp()));
		return bean;
	}
}
