/**
 ********************************************************************************
 *** BaseBrandAction.java                                                     ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asbrand.action;

import net.anotheria.anosite.gen.shared.action.BaseBrandsAction;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.asbrand.data.Brand;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseBrandAction extends BaseBrandsAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Brands";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASBrand";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "Brand";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, Brand brand) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASBrand.Brand").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASBrand.Brand", brand, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASBrand.Brand", brand, "defaultBrand");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.defaultBrand", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASBrand.Brand", brand, "urlsToMap");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.urlsToMap", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASBrand.Brand", brand, "localizations");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.localizations", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASBrand.Brand", brand, "mediaLinks");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.mediaLinks", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASBrand.Brand", brand, "attributes");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.attributes", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockBrands(Brand brand, HttpServletRequest req) throws Exception{
		if(brand instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)brand;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASBrandService().updateBrand( brand);
			logger.info("Lock-OPERATION, document with id : ["+brand.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockBrands(Brand brand, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(brand instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)brand;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASBrandService().updateBrand( brand);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+brand.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+brand.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkBrands(Brand brand, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = brand instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)brand).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)brand).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockBrands(brand, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateBrands(Brand brand, HttpServletRequest req) throws Exception{
		if(brand instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)brand, false, getUserId(req));
		}
		if (isTimeoutReached(brand)) {
			checkBrands(brand, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(brand, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(Brand brand){
		if (brand instanceof LockableObject) {
			LockableObject lock = (LockableObject)brand;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(Brand brand, HttpServletRequest req){
		if (brand instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)brand;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
