/**
 ********************************************************************************
 *** MultiOpDialogRolesAction.java                                            ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessconfiguration.action;

import net.anotheria.util.NumberUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.RoleFactory;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.Role;
import net.anotheria.anosite.gen.anoaccessconfiguration.bean.EditRoleFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;

public class MultiOpDialogRolesAction extends BaseRoleAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("anoaccessconfigurationRoleDelete"))
			return anoaccessconfigurationRoleDelete(mapping, req, res);
		if (path.equals("anoaccessconfigurationRoleDuplicate"))
			return anoaccessconfigurationRoleDuplicate(mapping, req, res);
		if (path.equals("anoaccessconfigurationRoleUpdate"))
			return anoaccessconfigurationRoleUpdate(mapping, req, res);
		if (path.equals("anoaccessconfigurationRoleClose"))
			return anoaccessconfigurationRoleClose(mapping, req, res);
		if (path.equals("anoaccessconfigurationRoleLock"))
			return anoaccessconfigurationRoleLock(mapping, req, res);
		if (path.equals("anoaccessconfigurationRoleUnLock"))
			return anoaccessconfigurationRoleUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand anoaccessconfigurationRoleDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			Role roleCurr = getAnoAccessConfigurationService().getRole(id);
			if (roleCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)roleCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getAnoAccessConfigurationService().deleteRole(id);
		}
		res.sendRedirect("anoaccessconfigurationRoleShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand anoaccessconfigurationRoleDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		Role roleSrc = getAnoAccessConfigurationService().getRole(id);
		Role roleDest = RoleFactory.createRole(roleSrc);




		Role roleCreated = getAnoAccessConfigurationService().createRole(roleDest);
		res.sendRedirect("anoaccessconfigurationRoleEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+roleCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand anoaccessconfigurationRoleUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditRoleFB form = new EditRoleFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		Role role = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		role = (Role)getAnoAccessConfigurationService().getRole(form.getId()).clone();
	}else{
		role = RoleFactory.createRole();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	role.setName(form.getName());
	// skipped container permissions
	// skipped container contextInitializers
	role.setDescription(form.getDescription());

	Role updatedCopy = null;
	if (create){
		updatedCopy = getAnoAccessConfigurationService().createRole(role);
	}else{
		canUpdateRoles(role, req);
		checkRoles(role, req);
		updatedCopy = getAnoAccessConfigurationService().updateRole(role);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("anoaccessconfigurationRoleEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(role, req);
		res.sendRedirect("anoaccessconfigurationRoleShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(Role role, HttpServletRequest req) throws Exception{
	if(((LockableObject)role).isLocked())
		unLockRoles(role, req, false);
}

public ActionCommand anoaccessconfigurationRoleLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Role roleCurr = id != null && !id.equals("") ? getAnoAccessConfigurationService().getRole(id) : null;
	if(roleCurr != null && roleCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)roleCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockRoles(roleCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, roleCurr));
	return null;
}

public ActionCommand anoaccessconfigurationRoleUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Role roleCurr = id != null && !id.equals("") ? getAnoAccessConfigurationService().getRole(id) : null;
	if(roleCurr != null && roleCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)roleCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockRoles(roleCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, roleCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, Role item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "anoaccessconfigurationRoleShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "anoaccessconfigurationRoleEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "anoaccessconfigurationRoleShow?ts="+System.currentTimeMillis();
}

public ActionCommand anoaccessconfigurationRoleClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Role roleCurr = id != null && !id.equals("") ? getAnoAccessConfigurationService().getRole(id) : null;
	if(roleCurr != null && roleCurr instanceof LockableObject && ((LockableObject)roleCurr).isLocked()) 
		unLockRoles(roleCurr, req, false);
	res.sendRedirect("anoaccessconfigurationRoleShow?ts="+System.currentTimeMillis());
	return null;
}

}
