/**
 ********************************************************************************
 *** MultiOpDialogPermissionsAction.java                                      ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessconfiguration.action;

import net.anotheria.util.NumberUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.PermissionFactory;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.Permission;
import net.anotheria.anosite.gen.anoaccessconfiguration.bean.EditPermissionFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;

public class MultiOpDialogPermissionsAction extends BasePermissionAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("anoaccessconfigurationPermissionDelete"))
			return anoaccessconfigurationPermissionDelete(mapping, req, res);
		if (path.equals("anoaccessconfigurationPermissionDuplicate"))
			return anoaccessconfigurationPermissionDuplicate(mapping, req, res);
		if (path.equals("anoaccessconfigurationPermissionUpdate"))
			return anoaccessconfigurationPermissionUpdate(mapping, req, res);
		if (path.equals("anoaccessconfigurationPermissionClose"))
			return anoaccessconfigurationPermissionClose(mapping, req, res);
		if (path.equals("anoaccessconfigurationPermissionLock"))
			return anoaccessconfigurationPermissionLock(mapping, req, res);
		if (path.equals("anoaccessconfigurationPermissionUnLock"))
			return anoaccessconfigurationPermissionUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand anoaccessconfigurationPermissionDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			Permission permissionCurr = getAnoAccessConfigurationService().getPermission(id);
			if (permissionCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)permissionCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getAnoAccessConfigurationService().deletePermission(id);
		}
		res.sendRedirect("anoaccessconfigurationPermissionShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand anoaccessconfigurationPermissionDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		Permission permissionSrc = getAnoAccessConfigurationService().getPermission(id);
		Permission permissionDest = PermissionFactory.createPermission(permissionSrc);



		Permission permissionCreated = getAnoAccessConfigurationService().createPermission(permissionDest);
		res.sendRedirect("anoaccessconfigurationPermissionEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+permissionCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand anoaccessconfigurationPermissionUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditPermissionFB form = new EditPermissionFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		Permission permission = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		permission = (Permission)getAnoAccessConfigurationService().getPermission(form.getId()).clone();
	}else{
		permission = PermissionFactory.createPermission();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	permission.setName(form.getName());
	permission.setAccessOperation(form.getAccessOperation());
	permission.setPriority(form.getPriority());
	permission.setDeny(form.isDeny());
	// skipped container constraints
	permission.setDescription(form.getDescription());

	Permission updatedCopy = null;
	if (create){
		updatedCopy = getAnoAccessConfigurationService().createPermission(permission);
	}else{
		canUpdatePermissions(permission, req);
		checkPermissions(permission, req);
		updatedCopy = getAnoAccessConfigurationService().updatePermission(permission);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("anoaccessconfigurationPermissionEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(permission, req);
		res.sendRedirect("anoaccessconfigurationPermissionShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(Permission permission, HttpServletRequest req) throws Exception{
	if(((LockableObject)permission).isLocked())
		unLockPermissions(permission, req, false);
}

public ActionCommand anoaccessconfigurationPermissionLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Permission permissionCurr = id != null && !id.equals("") ? getAnoAccessConfigurationService().getPermission(id) : null;
	if(permissionCurr != null && permissionCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)permissionCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockPermissions(permissionCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, permissionCurr));
	return null;
}

public ActionCommand anoaccessconfigurationPermissionUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Permission permissionCurr = id != null && !id.equals("") ? getAnoAccessConfigurationService().getPermission(id) : null;
	if(permissionCurr != null && permissionCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)permissionCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockPermissions(permissionCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, permissionCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, Permission item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "anoaccessconfigurationPermissionShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "anoaccessconfigurationPermissionEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "anoaccessconfigurationPermissionShow?ts="+System.currentTimeMillis();
}

public ActionCommand anoaccessconfigurationPermissionClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Permission permissionCurr = id != null && !id.equals("") ? getAnoAccessConfigurationService().getPermission(id) : null;
	if(permissionCurr != null && permissionCurr instanceof LockableObject && ((LockableObject)permissionCurr).isLocked()) 
		unLockPermissions(permissionCurr, req, false);
	res.sendRedirect("anoaccessconfigurationPermissionShow?ts="+System.currentTimeMillis());
	return null;
}

}
