/**
 ********************************************************************************
 *** MultiOpDialogConstraintsAction.java                                      ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessconfiguration.action;

import net.anotheria.util.NumberUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.ConstraintFactory;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.Constraint;
import net.anotheria.anosite.gen.anoaccessconfiguration.bean.EditConstraintFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;

public class MultiOpDialogConstraintsAction extends BaseConstraintAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("anoaccessconfigurationConstraintDelete"))
			return anoaccessconfigurationConstraintDelete(mapping, req, res);
		if (path.equals("anoaccessconfigurationConstraintDuplicate"))
			return anoaccessconfigurationConstraintDuplicate(mapping, req, res);
		if (path.equals("anoaccessconfigurationConstraintUpdate"))
			return anoaccessconfigurationConstraintUpdate(mapping, req, res);
		if (path.equals("anoaccessconfigurationConstraintClose"))
			return anoaccessconfigurationConstraintClose(mapping, req, res);
		if (path.equals("anoaccessconfigurationConstraintLock"))
			return anoaccessconfigurationConstraintLock(mapping, req, res);
		if (path.equals("anoaccessconfigurationConstraintUnLock"))
			return anoaccessconfigurationConstraintUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand anoaccessconfigurationConstraintDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			Constraint constraintCurr = getAnoAccessConfigurationService().getConstraint(id);
			if (constraintCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)constraintCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getAnoAccessConfigurationService().deleteConstraint(id);
		}
		res.sendRedirect("anoaccessconfigurationConstraintShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand anoaccessconfigurationConstraintDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		Constraint constraintSrc = getAnoAccessConfigurationService().getConstraint(id);
		Constraint constraintDest = ConstraintFactory.createConstraint(constraintSrc);



		Constraint constraintCreated = getAnoAccessConfigurationService().createConstraint(constraintDest);
		res.sendRedirect("anoaccessconfigurationConstraintEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+constraintCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand anoaccessconfigurationConstraintUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditConstraintFB form = new EditConstraintFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		Constraint constraint = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		constraint = (Constraint)getAnoAccessConfigurationService().getConstraint(form.getId()).clone();
	}else{
		constraint = ConstraintFactory.createConstraint();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	constraint.setName(form.getName());
	constraint.setClassName(form.getClassName());
	// skipped container contextInitializers
	constraint.setParameter1(form.getParameter1());
	constraint.setParameter2(form.getParameter2());
	constraint.setParameter3(form.getParameter3());
	constraint.setParameter4(form.getParameter4());
	constraint.setParameter5(form.getParameter5());
	constraint.setDescription(form.getDescription());

	Constraint updatedCopy = null;
	if (create){
		updatedCopy = getAnoAccessConfigurationService().createConstraint(constraint);
	}else{
		canUpdateConstraints(constraint, req);
		checkConstraints(constraint, req);
		updatedCopy = getAnoAccessConfigurationService().updateConstraint(constraint);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("anoaccessconfigurationConstraintEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(constraint, req);
		res.sendRedirect("anoaccessconfigurationConstraintShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(Constraint constraint, HttpServletRequest req) throws Exception{
	if(((LockableObject)constraint).isLocked())
		unLockConstraints(constraint, req, false);
}

public ActionCommand anoaccessconfigurationConstraintLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Constraint constraintCurr = id != null && !id.equals("") ? getAnoAccessConfigurationService().getConstraint(id) : null;
	if(constraintCurr != null && constraintCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)constraintCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockConstraints(constraintCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, constraintCurr));
	return null;
}

public ActionCommand anoaccessconfigurationConstraintUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Constraint constraintCurr = id != null && !id.equals("") ? getAnoAccessConfigurationService().getConstraint(id) : null;
	if(constraintCurr != null && constraintCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)constraintCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockConstraints(constraintCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, constraintCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, Constraint item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "anoaccessconfigurationConstraintShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "anoaccessconfigurationConstraintEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "anoaccessconfigurationConstraintShow?ts="+System.currentTimeMillis();
}

public ActionCommand anoaccessconfigurationConstraintClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Constraint constraintCurr = id != null && !id.equals("") ? getAnoAccessConfigurationService().getConstraint(id) : null;
	if(constraintCurr != null && constraintCurr instanceof LockableObject && ((LockableObject)constraintCurr).isLocked()) 
		unLockConstraints(constraintCurr, req, false);
	res.sendRedirect("anoaccessconfigurationConstraintShow?ts="+System.currentTimeMillis());
	return null;
}

}
