/**
 ********************************************************************************
 *** ExportAccessOperationsAction.java                                        ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessconfiguration.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.xml.XMLNode;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.AccessOperation;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.AccessOperationSortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;
import net.anotheria.anosite.gen.anoaccessconfiguration.bean.AccessOperationListItemBeanSortType;

public class ExportAccessOperationsAction extends BaseAccessOperationAction{

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"AccessOperation";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"AccessOperation";
	private static final List<String> ITEMS_ON_PAGE_SELECTOR = java.util.Arrays.asList(new String[]{"5","10","20","25","50","100","500","1000"});
	private static final Logger log = LoggerFactory.getLogger(ExportAccessOperationsAction.class);
	private Sorter<AccessOperation> sorter;

	private DocumentFilter nameFilterAZ;

	public ExportAccessOperationsAction(){
		super();
		sorter = new QuickSorter<AccessOperation>();
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = AccessOperationListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = AccessOperationListItemBeanSortType.ASC;
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = AccessOperationListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			sortOrder = getStringParameter(req, PARAM_SORT_ORDER).equals("ASC") ? 
				AccessOperationListItemBeanSortType.ASC : AccessOperationListItemBeanSortType.DESC;
		}catch(Exception ignored){}

		AccessOperationListItemBeanSortType sessionSortType  = null;
		AccessOperationSortType sortType = null;
		if (sortParamSet){
			sessionSortType = new AccessOperationListItemBeanSortType(sortMethod, sortOrder);
			sortType = new AccessOperationSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sessionSortType);
		}else{
			sessionSortType = (AccessOperationListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			sortType = sessionSortType == null ? new AccessOperationSortType(sortMethod, sortOrder) : new AccessOperationSortType(sessionSortType.getSortBy(), sessionSortType.getSortOrder());
			sessionSortType = sessionSortType == null ? new AccessOperationListItemBeanSortType(sortMethod, sortOrder) : sessionSortType;
		}
		req.setAttribute("currentSortCode", sessionSortType.getMethodAndOrderCode());

		List<AccessOperation> _unfiltered_accessoperations = getAnoAccessConfigurationService().getAccessOperations();
		List<AccessOperation> accessoperations = new ArrayList<AccessOperation>();
		for (AccessOperation element : _unfiltered_accessoperations ){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass( element, "name", filterParameter0));
			if (mayPass)
				accessoperations.add(element);
		}
		accessoperations = sorter.sort(accessoperations, sortType);

		addBeanToRequest(req, "accessoperations", accessoperations);

		XMLNode beans = getAnoAccessConfigurationService().exportAccessOperationsToXML(accessoperations);


		/**
		 * for XML node - page
		 */
		addBeanToRequest(req, "accessoperationsXML", beans);
		/**
		 * for CSV - page
		 */
		addBeanToRequest(req, "accessoperationsCSV", accessoperations);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer(""));
		return mapping.success();
	}

}
