/**
 ********************************************************************************
 *** IAnoAccessApplicationDataService.java                                    ***
 *** Generator: net.anotheria.asg.generator.model.ServiceGenerator            ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessapplicationdata.service;

import java.util.List;
import net.anotheria.util.sorter.SortType;
import net.anotheria.anosite.gen.anoaccessapplicationdata.data.UserData;
import java.util.Set;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.slicer.Segment;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.asg.service.ASGService;

public interface IAnoAccessApplicationDataService extends ASGService{

// Generated by: class net.anotheria.asg.generator.model.ServiceGenerator.generateInterface

	/**
	 * Returns all UserDatas objects stored.
	 */
	List<UserData> getUserDatas() throws AnoAccessApplicationDataServiceException;

	/**
	 * Returns all UserDatas objects sorted by given sortType.
	 */
	List<UserData> getUserDatas(SortType sortType) throws AnoAccessApplicationDataServiceException;

	/**
	 * Deletes a UserData object by id.
	 */
	void deleteUserData(String id) throws AnoAccessApplicationDataServiceException;

	/**
	 * Deletes a UserData object.
	 */
	void deleteUserData(UserData userdata) throws AnoAccessApplicationDataServiceException;

	/**
	 * Deletes multiple UserData object.
	 */
	void deleteUserDatas(List<UserData> list) throws AnoAccessApplicationDataServiceException;

	/**
	 * Returns the UserData object with the specified id.
	 */
	UserData getUserData(String id) throws AnoAccessApplicationDataServiceException;

	/**
	 * Imports a new UserData object.
	 * Returns the created version.
	 */
	UserData importUserData(UserData userdata) throws AnoAccessApplicationDataServiceException;

	/**
	 * Imports multiple new  UserData object.
	 * Returns the created versions.
	 */
	List<UserData> importUserDatas(List<UserData> list) throws AnoAccessApplicationDataServiceException;

	/**
	 * Creates a new UserData object.
	 * Returns the created version.
	 */
	UserData createUserData(UserData userdata) throws AnoAccessApplicationDataServiceException;

	/**
	 * Creates multiple new UserData objects.
	 * Returns the created versions.
	 */
	List<UserData> createUserDatas(List<UserData> list) throws AnoAccessApplicationDataServiceException;

	/**
	 * Updates a UserData object.
	 * Returns the updated version.
	 */
	UserData updateUserData(UserData userdata) throws AnoAccessApplicationDataServiceException;

	/**
	 * Updates multiple UserData objects.
	 * Returns the updated versions.
	 */
	List<UserData> updateUserDatas(List<UserData> list) throws AnoAccessApplicationDataServiceException;

	/**
	 * Returns all UserData objects, where property with given name equals object.
	 */
	List<UserData> getUserDatasByProperty(String propertyName, Object value) throws AnoAccessApplicationDataServiceException;

	/**
	 * Returns all UserData objects, where property with given name equals object, sorted.
	 */
	List<UserData> getUserDatasByProperty(String propertyName, Object value, SortType sortType) throws AnoAccessApplicationDataServiceException;

	/**
	 * Executes a query.
	 */
	QueryResult executeQueryOnUserDatas(DocumentQuery query) throws AnoAccessApplicationDataServiceException;

	/**
	 * Returns all UserData objects, where property matches.
	 */
	List<UserData> getUserDatasByProperty(QueryProperty... property) throws AnoAccessApplicationDataServiceException;

	/**
	 * Returns all UserData objects, where property matches, sorted.
	 */
	List<UserData> getUserDatasByProperty(SortType sortType, QueryProperty... property) throws AnoAccessApplicationDataServiceException;

	/**
	 * Returns all UserDatas count.
	 */
	int getUserDatasCount() throws AnoAccessApplicationDataServiceException;

	/**
	 * Returns UserDatas objects segment.
	 */
	List<UserData> getUserDatas(Segment aSegment) throws AnoAccessApplicationDataServiceException;

	/**
	 * Returns UserData objects segment, where property matches.
	 */
	List<UserData> getUserDatasByProperty(Segment aSegment, QueryProperty... aProperty) throws AnoAccessApplicationDataServiceException;

	/**
	 * Returns UserData objects segment, where property matches, sorted.
	 */
	List<UserData> getUserDatasByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty) throws AnoAccessApplicationDataServiceException;

	/**
	 * Creates an xml element with selected contained data.
	 */
	XMLNode exportUserDatasToXML(List<UserData> listUserDatas)  throws AnoAccessApplicationDataServiceException;

	/**
	 * Create json object list dependencies for this UserData document.
	 */
	void fetchUserData(String id, Set<String> addedDocuments, JSONArray data) throws AnoAccessApplicationDataServiceException;

	/**
	 * Save transferred document by its own type.
	 */
	void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws AnoAccessApplicationDataServiceException;
	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service.
	 */
	QueryResult executeQueryOnAllObjects(DocumentQuery query) throws AnoAccessApplicationDataServiceException;
	/**
	 * creates an xml element with all contained data.
	 */
	XMLNode exportToXML() throws AnoAccessApplicationDataServiceException;

}
