/**
 ********************************************************************************
 *** CmsSearchAction.java                                                     ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.shared.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryResultEntry;
import net.anotheria.anodoc.query2.ResultEntryBean;
import net.anotheria.anodoc.query2.string.ContainsStringQuery;
import net.anotheria.asg.exception.ASGRuntimeException;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.maf.bean.FormBean;
import net.anotheria.webutils.bean.NavigationItemBean;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.data.DataObject;

public class CmsSearchAction extends BaseAdminapiAction{

// Generated by: class net.anotheria.asg.generator.view.action.CMSSearchActionsGenerator.generateSearchAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String pCriteria = getStringParameter(req, "criteria");
		String pModule = getStringParameter(req, "module");
		String pDocument = getStringParameter(req, "document");
		String pSearchArea = req.getParameter("searchArea");
		if (StringUtils.isEmpty(pSearchArea)) { pSearchArea = "cms";};
		DocumentQuery query = new ContainsStringQuery("*" + pCriteria + "*(\r\n)?");
		QueryResult result = executeQuery(pModule, pDocument, query, pSearchArea);
		addBeanToRequest(req, BEAN_DOCUMENT_DEF_NAME, pDocument);
		addBeanToRequest(req, BEAN_MODULE_DEF_NAME, pModule);
		req.getSession().setAttribute(BEAN_SEARCH_SCOPE, pSearchArea);
		if (result.getEntries().size()==0){
			req.setAttribute("srMessage", "Nothing found.");
		}else{
			List<ResultEntryBean> beans = new ArrayList<ResultEntryBean>(result.getEntries().size());
			for (QueryResultEntry entry: result.getEntries()){
				DataObject doc = (DataObject)entry.getMatchedDocument();
				ResultEntryBean bean = new ResultEntryBean();
				bean.setEditLink(doc.getDefinedParentName().toLowerCase() + StringUtils.capitalize(doc.getDefinedName()) + "Edit?pId=" + doc.getId() + "&ts=" + System.currentTimeMillis());
				bean.setDocumentId(entry.getMatchedDocument().getId());
				bean.setDocumentName(doc.getDefinedName());
				bean.setPropertyName(entry.getMatchedProperty().getId());
				bean.setInfo(entry.getInfo().toHtml());
				beans.add(bean);
			} //
			req.setAttribute("result", beans);
		} //
		req.setAttribute("criteria", pCriteria);
		return mapping.success();
	} //

	private QueryResult executeQuery(String sectionName, String documentName, DocumentQuery query, String searchArea) throws ASGRuntimeException{
		QueryResult ret = new QueryResult();
		boolean wholeCms = "cms".equals(searchArea);
		boolean wholeSection = wholeCms || "section".equals(searchArea);

		if(wholeCms || sectionName.equals("Content")){
				if(wholeSection || documentName.equals("Pagex"))
					ret.add(getASWebDataService().executeQueryOnPagexs(query).getEntries());
				if(wholeSection || documentName.equals("Box"))
					ret.add(getASWebDataService().executeQueryOnBoxs(query).getEntries());
				if(wholeSection || documentName.equals("Attribute"))
					ret.add(getASWebDataService().executeQueryOnAttributes(query).getEntries());
		} //if

		if(wholeCms || sectionName.equals("Site")){
				if(wholeSection || documentName.equals("Site"))
					ret.add(getASSiteDataService().executeQueryOnSites(query).getEntries());
				if(wholeSection || documentName.equals("NaviItem"))
					ret.add(getASSiteDataService().executeQueryOnNaviItems(query).getEntries());
				if(wholeSection || documentName.equals("PageTemplate"))
					ret.add(getASSiteDataService().executeQueryOnPageTemplates(query).getEntries());
				if(wholeSection || documentName.equals("MediaLink"))
					ret.add(getASSiteDataService().executeQueryOnMediaLinks(query).getEntries());
				if(wholeSection || documentName.equals("Script"))
					ret.add(getASSiteDataService().executeQueryOnScripts(query).getEntries());
				if(wholeSection || documentName.equals("EntryPoint"))
					ret.add(getASSiteDataService().executeQueryOnEntryPoints(query).getEntries());
				if(wholeSection || documentName.equals("PageAlias"))
					ret.add(getASSiteDataService().executeQueryOnPageAliass(query).getEntries());
				if(wholeSection || documentName.equals("RedirectUrl"))
					ret.add(getASSiteDataService().executeQueryOnRedirectUrls(query).getEntries());
		} //if

		if(wholeCms || sectionName.equals("Site Config")){
				if(wholeSection || documentName.equals("FilteredIP"))
					ret.add(getASSiteConfigService().executeQueryOnFilteredIPs(query).getEntries());
		} //if

		if(wholeCms || sectionName.equals("Layout")){
				if(wholeSection || documentName.equals("PageStyle"))
					ret.add(getASLayoutDataService().executeQueryOnPageStyles(query).getEntries());
				if(wholeSection || documentName.equals("PageLayout"))
					ret.add(getASLayoutDataService().executeQueryOnPageLayouts(query).getEntries());
		} //if

		if(wholeCms || sectionName.equals("Definitions")){
				if(wholeSection || documentName.equals("GenericBoxType"))
					ret.add(getASGenericDataService().executeQueryOnGenericBoxTypes(query).getEntries());
				if(wholeSection || documentName.equals("GenericBoxHandlerDef"))
					ret.add(getASGenericDataService().executeQueryOnGenericBoxHandlerDefs(query).getEntries());
				if(wholeSection || documentName.equals("GenericGuardDef"))
					ret.add(getASGenericDataService().executeQueryOnGenericGuardDefs(query).getEntries());
				if(wholeSection || documentName.equals("CustomBoxType"))
					ret.add(getASCustomDataService().executeQueryOnCustomBoxTypes(query).getEntries());
				if(wholeSection || documentName.equals("CustomBoxHandlerDef"))
					ret.add(getASCustomDataService().executeQueryOnCustomBoxHandlerDefs(query).getEntries());
				if(wholeSection || documentName.equals("CustomGuardDef"))
					ret.add(getASCustomDataService().executeQueryOnCustomGuardDefs(query).getEntries());
				if(wholeSection || documentName.equals("BoxType"))
					ret.add(getASFederatedDataService().executeQueryOnBoxTypes(query).getEntries());
				if(wholeSection || documentName.equals("BoxHandlerDef"))
					ret.add(getASFederatedDataService().executeQueryOnBoxHandlerDefs(query).getEntries());
				if(wholeSection || documentName.equals("GuardDef"))
					ret.add(getASFederatedDataService().executeQueryOnGuardDefs(query).getEntries());
		} //if

		if(wholeCms || sectionName.equals("Resources")){
				if(wholeSection || documentName.equals("TextResource"))
					ret.add(getASResourceDataService().executeQueryOnTextResources(query).getEntries());
				if(wholeSection || documentName.equals("LocalizationBundle"))
					ret.add(getASResourceDataService().executeQueryOnLocalizationBundles(query).getEntries());
				if(wholeSection || documentName.equals("MailTemplate"))
					ret.add(getASResourceDataService().executeQueryOnMailTemplates(query).getEntries());
				if(wholeSection || documentName.equals("PdfTemplate"))
					ret.add(getASResourceDataService().executeQueryOnPdfTemplates(query).getEntries());
				if(wholeSection || documentName.equals("PushNotificationTemplate"))
					ret.add(getASResourceDataService().executeQueryOnPushNotificationTemplates(query).getEntries());
				if(wholeSection || documentName.equals("Image"))
					ret.add(getASResourceDataService().executeQueryOnImages(query).getEntries());
				if(wholeSection || documentName.equals("FileLink"))
					ret.add(getASResourceDataService().executeQueryOnFileLinks(query).getEntries());
		} //if

		if(wholeCms || sectionName.equals("Actions")){
				if(wholeSection || documentName.equals("ActionMappingDef"))
					ret.add(getASCustomActionService().executeQueryOnActionMappingDefs(query).getEntries());
				if(wholeSection || documentName.equals("ActionDef"))
					ret.add(getASActionService().executeQueryOnActionDefs(query).getEntries());
				if(wholeSection || documentName.equals("CustomActionDef"))
					ret.add(getASCustomActionService().executeQueryOnCustomActionDefs(query).getEntries());
				if(wholeSection || documentName.equals("GenericActionDef"))
					ret.add(getASGenericActionService().executeQueryOnGenericActionDefs(query).getEntries());
		} //if

		if(wholeCms || sectionName.equals("Wizard")){
				if(wholeSection || documentName.equals("WizardDef"))
					ret.add(getASWizardDataService().executeQueryOnWizardDefs(query).getEntries());
				if(wholeSection || documentName.equals("WizardHandlerDef"))
					ret.add(getASWizardDataService().executeQueryOnWizardHandlerDefs(query).getEntries());
		} //if

		if(wholeCms || sectionName.equals("UserManagement")){
				if(wholeSection || documentName.equals("UserDef"))
					ret.add(getASUserDataService().executeQueryOnUserDefs(query).getEntries());
				if(wholeSection || documentName.equals("RoleDef"))
					ret.add(getASUserDataService().executeQueryOnRoleDefs(query).getEntries());
		} //if

		if(wholeCms || sectionName.equals("Ano-Access Configuration")){
				if(wholeSection || documentName.equals("AccessOperation"))
					ret.add(getAnoAccessConfigurationService().executeQueryOnAccessOperations(query).getEntries());
				if(wholeSection || documentName.equals("Role"))
					ret.add(getAnoAccessConfigurationService().executeQueryOnRoles(query).getEntries());
				if(wholeSection || documentName.equals("Permission"))
					ret.add(getAnoAccessConfigurationService().executeQueryOnPermissions(query).getEntries());
				if(wholeSection || documentName.equals("Constraint"))
					ret.add(getAnoAccessConfigurationService().executeQueryOnConstraints(query).getEntries());
				if(wholeSection || documentName.equals("ContextInitializer"))
					ret.add(getAnoAccessConfigurationService().executeQueryOnContextInitializers(query).getEntries());
		} //if

		if(wholeCms || sectionName.equals("Ano-Access Data")){
				if(wholeSection || documentName.equals("UserData"))
					ret.add(getAnoAccessApplicationDataService().executeQueryOnUserDatas(query).getEntries());
		} //if

		if(wholeCms || sectionName.equals("Features")){
				if(wholeSection || documentName.equals("Feature"))
					ret.add(getASFeatureService().executeQueryOnFeatures(query).getEntries());
				if(wholeSection || documentName.equals("BrandFeature"))
					ret.add(getASFeatureService().executeQueryOnBrandFeatures(query).getEntries());
				if(wholeSection || documentName.equals("Experiment"))
					ret.add(getASExperimentService().executeQueryOnExperiments(query).getEntries());
		} //if

		if(wholeCms || sectionName.equals("Brands")){
				if(wholeSection || documentName.equals("Brand"))
					ret.add(getASBrandService().executeQueryOnBrands(query).getEntries());
		} //if

		if(wholeCms || sectionName.equals("Tools")){
		} //if

		return ret;
	} //executeQuery

	@Override
	protected String getActiveMainNavi() {
		return null;
	} //

	@Override
	protected List<NavigationItemBean> getSubNavigation(){
		return Collections.emptyList();
	} //
	@Override
	protected String getCurrentDocumentDefName() {
		return null;
	} //getCurrentDocumentDefName

	@Override
	protected String getCurrentModuleDefName() {
		return null;
	} //getCurrentModuleDefName

}
