/**
 ********************************************************************************
 *** MultiOpPagexsMediaLinksAction.java                                       ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.action;

import java.util.List;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.aswebdata.data.PagexFactory;
import net.anotheria.anosite.gen.aswebdata.data.Pagex;
import net.anotheria.anosite.gen.aswebdata.bean.MediaLinksElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.aswebdata.bean.MediaLinksQuickAddFB;
import net.anotheria.anosite.gen.assitedata.data.MediaLink;
import net.anotheria.anosite.gen.assitedata.data.MediaLinkSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpPagexsMediaLinksAction extends BasePagexAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("aswebdataPagexMediaLinksShow"))
			return aswebdataPagexMediaLinksShow(mapping, req, res);
		if (path.equals("aswebdataPagexMediaLinksAdd"))
			return aswebdataPagexMediaLinksAdd(mapping, req, res);
		if (path.equals("aswebdataPagexMediaLinksDelete"))
			return aswebdataPagexMediaLinksDelete(mapping, req, res);
		if (path.equals("aswebdataPagexMediaLinksMove"))
			return aswebdataPagexMediaLinksMove(mapping, req, res);
		if (path.equals("aswebdataPagexMediaLinksQuickAdd"))
			return aswebdataPagexMediaLinksQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand aswebdataPagexMediaLinksShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Pagex pagex = getASWebDataService().getPagex(id);
		addBeanToRequest(req, "ownerId", id);
		checkPagexs(pagex, req);

		MediaLinksElementFB form = new MediaLinksElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(pagex.getId());
		addBeanToRequest(req, "aswebdataPagexMediaLinksElementForm", form);

		MediaLinksQuickAddFB quickAddForm = new MediaLinksQuickAddFB() ;
		quickAddForm.setOwnerId(pagex.getId());
		addBeanToRequest(req, "aswebdataPagexMediaLinksQuickAddForm", quickAddForm);


		//link mediaLink to ASSiteData.MediaLink
		List<MediaLink> medialinks = getASSiteDataService().getMediaLinks(new MediaLinkSortType(MediaLinkSortType.SORT_BY_NAME));
		List<LabelValueBean> medialinksValues = new ArrayList<LabelValueBean>(medialinks.size());
		for (int i=0; i<medialinks.size(); i++){
			net.anotheria.anosite.gen.assitedata.data.MediaLink tmp_medialink = (net.anotheria.anosite.gen.assitedata.data.MediaLink) medialinks.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_medialink.getId(), tmp_medialink.getName()+" ["+tmp_medialink.getId()+"]" );
			medialinksValues.add(bean);
		}
		addBeanToRequest(req, "medialinkValuesCollection", medialinksValues);
		// generate list ...
		int size = pagex.getMediaLinksSize();
		List<MediaLinksElementFB> beans = new ArrayList<MediaLinksElementFB>(size);
		for (int i=0; i<size; i++){
			String value = pagex.getMediaLinksElement(i);
			MediaLinksElementFB bean = new MediaLinksElementFB();
			bean.setOwnerId(pagex.getId());
			bean.setPosition(i);
			bean.setMediaLink(value);
			try{
				MediaLink tmp_medialink = getASSiteDataService().getMediaLink(value);
				bean.setDescription(tmp_medialink.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand aswebdataPagexMediaLinksDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Pagex pagexCurr = getASWebDataService().getPagex(id);
		canUpdatePagexs(pagexCurr, req);
		checkPagexs(pagexCurr, req);
		int position = getIntParameter(req, "pPosition");
		Pagex pagex = getASWebDataService().getPagex(id);
		pagex.removeMediaLinksElement(position);
		getASWebDataService().updatePagex(pagex);
		return aswebdataPagexMediaLinksShow(mapping, req, res);
	}

	public ActionCommand aswebdataPagexMediaLinksMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		Pagex pagex = getASWebDataService().getPagex(id);
		canUpdatePagexs(pagex, req);
		checkPagexs(pagex, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(pagex, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(pagex, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(pagex, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(pagex, position);
		return aswebdataPagexMediaLinksShow(mapping, req, res);
	}

	private void moveUp(Pagex pagex, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		pagex.swapMediaLinksElement(position, position-1);
		getASWebDataService().updatePagex(pagex);
	}

	private void moveTop(Pagex pagex, int position) throws ASGRuntimeException {
		List<String> targetList = pagex.getMediaLinks();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		pagex.setMediaLinks(targetList);
		getASWebDataService().updatePagex(pagex);
	}

	private void moveDown(Pagex pagex, int position) throws ASGRuntimeException {
		if (position<pagex.getMediaLinksSize()-1){
			pagex.swapMediaLinksElement(position, position+1);
			getASWebDataService().updatePagex(pagex);
		}
	}

	private void moveBottom(Pagex pagex, int position) throws ASGRuntimeException {
		List<String> targetList = pagex.getMediaLinks();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		pagex.setMediaLinks(targetList);
		getASWebDataService().updatePagex(pagex);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand aswebdataPagexMediaLinksAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		MediaLinksElementFB form = new MediaLinksElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Pagex pagex;
		pagex = getASWebDataService().getPagex(id);
		canUpdatePagexs(pagex, req);
		checkPagexs(pagex, req);
		pagex.addMediaLinksElement(form.getMediaLink());
		getASWebDataService().updatePagex(pagex);
		return aswebdataPagexMediaLinksShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand aswebdataPagexMediaLinksQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		MediaLinksQuickAddFB form = new MediaLinksQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Pagex pagex;
		pagex = getASWebDataService().getPagex(id);
		canUpdatePagexs(pagex, req);
		checkPagexs(pagex, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				pagex.addMediaLinksElement(""+i);
			}
		}
		getASWebDataService().updatePagex(pagex);
		return aswebdataPagexMediaLinksShow(mapping, req, res);
	}

}
