/**
 ********************************************************************************
 *** ShowMediaLinksAction.java                                                ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.assitedata.data.MediaLink;
import net.anotheria.anosite.gen.assitedata.bean.MediaLinkListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.shared.data.MediaDescEnum;
import net.anotheria.anosite.gen.shared.data.LinkTypesEnum;
import net.anotheria.anosite.gen.assitedata.bean.MediaLinkListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;
import net.anotheria.asg.exception.ConstantNotFoundException;

public class ShowMediaLinksAction extends BaseMediaLinkAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"MediaLink";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"MediaLink";
	private static Logger log = LoggerFactory.getLogger(ShowMediaLinksAction.class);
	private Sorter<MediaLinkListItemBean> sorter;

	private IAttributeDecorator idDecorator;
	private IAttributeDecorator nameDecorator;

	private DocumentFilter nameFilterAZ;

	public ShowMediaLinksAction(){
		sorter = new QuickSorter<MediaLinkListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
			nameDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = MediaLinkListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = MediaLinkListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		MediaLinkListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new MediaLinkListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (MediaLinkListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new MediaLinkListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<MediaLink> _unfiltered_medialinks = getASSiteDataService().getMediaLinks();
		List<MediaLink> medialinks = new ArrayList<MediaLink>();
		for (int i=0; i<_unfiltered_medialinks.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_medialinks.get(i), "name", filterParameter0));
			if (mayPass)
				medialinks.add(_unfiltered_medialinks.get(i));
		}
		List<MediaLinkListItemBean> beans = new ArrayList<MediaLinkListItemBean>(medialinks.size());
		for (MediaLink medialink : medialinks){
			checkMediaLinks(medialink, req);
			MediaLinkListItemBean bean = makeMediaLinkListItemBean(medialink);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "medialinks", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		return mapping.success();
	}

	protected MediaLinkListItemBean makeMediaLinkListItemBean(MediaLink medialink) {
		MediaLinkListItemBean bean = new MediaLinkListItemBean();
		bean.setPlainId(medialink.getId());
		bean.setIdForSorting(medialink.getId());
		bean.setId(idDecorator.decorate(medialink, "id", "3"));
		bean.setNameForSorting(medialink.getName());
		bean.setName(nameDecorator.decorate(medialink, "name", "null"));
		bean.setFile(medialink.getFile());
		bean.setHref(medialink.getHref());
		bean.setType(medialink.getType());
		try {
			bean.setMedia(MediaDescEnum.getConstantByValue(medialink.getMedia()).name());
		}catch(net.anotheria.asg.exception.ConstantNotFoundException e){
			bean.setMedia("-----");
		} //try
		try {
			bean.setRel(LinkTypesEnum.getConstantByValue(medialink.getRel()).name());
		}catch(net.anotheria.asg.exception.ConstantNotFoundException e){
			bean.setRel("-----");
		} //try
		try {
			bean.setRev(LinkTypesEnum.getConstantByValue(medialink.getRev()).name());
		}catch(net.anotheria.asg.exception.ConstantNotFoundException e){
			bean.setRev("-----");
		} //try
		bean.setHreflang(medialink.getHreflang());
		bean.setCharset(medialink.getCharset());
		bean.setBrowserFiltering(medialink.getBrowserFiltering());
		bean.setOnload(medialink.getOnload());
		bean.setLocked(((LockableObject)medialink).isLocked());
		bean.setLockerId(((LockableObject)medialink).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)medialink).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)medialink).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(medialink.getLastUpdateTimestamp()));
		return bean;
	}
}
