/**
 ********************************************************************************
 *** MultiOpScriptsGuardsAction.java                                          ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import java.util.List;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.assitedata.data.ScriptFactory;
import net.anotheria.anosite.gen.assitedata.data.Script;
import net.anotheria.anosite.gen.assitedata.bean.GuardsElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.assitedata.bean.GuardsQuickAddFB;
import net.anotheria.anosite.gen.asfederateddata.data.GuardDef;
import net.anotheria.anosite.gen.asfederateddata.data.GuardDefSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpScriptsGuardsAction extends BaseScriptAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("assitedataScriptGuardsShow"))
			return assitedataScriptGuardsShow(mapping, req, res);
		if (path.equals("assitedataScriptGuardsAdd"))
			return assitedataScriptGuardsAdd(mapping, req, res);
		if (path.equals("assitedataScriptGuardsDelete"))
			return assitedataScriptGuardsDelete(mapping, req, res);
		if (path.equals("assitedataScriptGuardsMove"))
			return assitedataScriptGuardsMove(mapping, req, res);
		if (path.equals("assitedataScriptGuardsQuickAdd"))
			return assitedataScriptGuardsQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand assitedataScriptGuardsShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Script script = getASSiteDataService().getScript(id);
		addBeanToRequest(req, "ownerId", id);
		checkScripts(script, req);

		GuardsElementFB form = new GuardsElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(script.getId());
		addBeanToRequest(req, "assitedataScriptGuardsElementForm", form);

		GuardsQuickAddFB quickAddForm = new GuardsQuickAddFB() ;
		quickAddForm.setOwnerId(script.getId());
		addBeanToRequest(req, "assitedataScriptGuardsQuickAddForm", quickAddForm);


		//link guard to ASFederatedData.GuardDef
		List<GuardDef> guarddefs = getASFederatedDataService().getGuardDefs(new GuardDefSortType(GuardDefSortType.SORT_BY_NAME));
		List<LabelValueBean> guarddefsValues = new ArrayList<LabelValueBean>(guarddefs.size());
		for (int i=0; i<guarddefs.size(); i++){
			net.anotheria.anosite.gen.asfederateddata.data.GuardDef tmp_guarddef = (net.anotheria.anosite.gen.asfederateddata.data.GuardDef) guarddefs.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_guarddef.getId(), tmp_guarddef.getName()+" ["+tmp_guarddef.getId()+"]" );
			guarddefsValues.add(bean);
		}
		addBeanToRequest(req, "guardValuesCollection", guarddefsValues);
		// generate list ...
		int size = script.getGuardsSize();
		List<GuardsElementFB> beans = new ArrayList<GuardsElementFB>(size);
		for (int i=0; i<size; i++){
			String value = script.getGuardsElement(i);
			GuardsElementFB bean = new GuardsElementFB();
			bean.setOwnerId(script.getId());
			bean.setPosition(i);
			bean.setGuard(value);
			try{
				GuardDef tmp_guarddef = getASFederatedDataService().getGuardDef(value);
				bean.setDescription(tmp_guarddef.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand assitedataScriptGuardsDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Script scriptCurr = getASSiteDataService().getScript(id);
		canUpdateScripts(scriptCurr, req);
		checkScripts(scriptCurr, req);
		int position = getIntParameter(req, "pPosition");
		Script script = getASSiteDataService().getScript(id);
		script.removeGuardsElement(position);
		getASSiteDataService().updateScript(script);
		return assitedataScriptGuardsShow(mapping, req, res);
	}

	public ActionCommand assitedataScriptGuardsMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		Script script = getASSiteDataService().getScript(id);
		canUpdateScripts(script, req);
		checkScripts(script, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(script, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(script, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(script, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(script, position);
		return assitedataScriptGuardsShow(mapping, req, res);
	}

	private void moveUp(Script script, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		script.swapGuardsElement(position, position-1);
		getASSiteDataService().updateScript(script);
	}

	private void moveTop(Script script, int position) throws ASGRuntimeException {
		List<String> targetList = script.getGuards();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		script.setGuards(targetList);
		getASSiteDataService().updateScript(script);
	}

	private void moveDown(Script script, int position) throws ASGRuntimeException {
		if (position<script.getGuardsSize()-1){
			script.swapGuardsElement(position, position+1);
			getASSiteDataService().updateScript(script);
		}
	}

	private void moveBottom(Script script, int position) throws ASGRuntimeException {
		List<String> targetList = script.getGuards();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		script.setGuards(targetList);
		getASSiteDataService().updateScript(script);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand assitedataScriptGuardsAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		GuardsElementFB form = new GuardsElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Script script;
		script = getASSiteDataService().getScript(id);
		canUpdateScripts(script, req);
		checkScripts(script, req);
		script.addGuardsElement(form.getGuard());
		getASSiteDataService().updateScript(script);
		return assitedataScriptGuardsShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand assitedataScriptGuardsQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		GuardsQuickAddFB form = new GuardsQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Script script;
		script = getASSiteDataService().getScript(id);
		canUpdateScripts(script, req);
		checkScripts(script, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				script.addGuardsElement(""+i);
			}
		}
		getASSiteDataService().updateScript(script);
		return assitedataScriptGuardsShow(mapping, req, res);
	}

}
