/**
 ********************************************************************************
 *** MultiOpDialogNaviItemsAction.java                                        ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import net.anotheria.util.NumberUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.assitedata.data.NaviItemFactory;
import net.anotheria.anosite.gen.assitedata.data.NaviItem;
import net.anotheria.anosite.gen.assitedata.bean.EditNaviItemFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import net.anotheria.asg.data.MultilingualObject;
import net.anotheria.webutils.filehandling.actions.FileStorage;
import net.anotheria.webutils.filehandling.beans.TemporaryFileHolder;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;
import net.anotheria.util.StringUtils;
import org.apache.commons.lang.WordUtils;

public class MultiOpDialogNaviItemsAction extends BaseNaviItemAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("assitedataNaviItemDelete"))
			return assitedataNaviItemDelete(mapping, req, res);
		if (path.equals("assitedataNaviItemDuplicate"))
			return assitedataNaviItemDuplicate(mapping, req, res);
		if (path.equals("assitedataNaviItemUpdate"))
			return assitedataNaviItemUpdate(mapping, req, res);
		if (path.equals("assitedataNaviItemClose"))
			return assitedataNaviItemClose(mapping, req, res);
		if (path.equals("assitedataNaviItemCopyLang"))
			return assitedataNaviItemCopyLang(mapping, req, res);
		if (path.equals("assitedataNaviItemSwitchMultilang"))
			return assitedataNaviItemSwitchMultilang(mapping, req, res);
		if (path.equals("assitedataNaviItemLock"))
			return assitedataNaviItemLock(mapping, req, res);
		if (path.equals("assitedataNaviItemUnLock"))
			return assitedataNaviItemUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand assitedataNaviItemDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			NaviItem naviitemCurr = getASSiteDataService().getNaviItem(id);
			if (naviitemCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)naviitemCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASSiteDataService().deleteNaviItem(id);
			FileStorage.removeFilePermanently( naviitemCurr.getIcon() );
		}
		res.sendRedirect("assitedataNaviItemShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand assitedataNaviItemDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		NaviItem naviitemSrc = getASSiteDataService().getNaviItem(id);
		NaviItem naviitemDest = NaviItemFactory.createNaviItem(naviitemSrc);

		naviitemDest.setIcon(FileStorage.cloneFilePermanently( naviitemDest.getIcon() ));



		NaviItem naviitemCreated = getASSiteDataService().createNaviItem(naviitemDest);
		res.sendRedirect("assitedataNaviItemEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+naviitemCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand assitedataNaviItemUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditNaviItemFB form = new EditNaviItemFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		NaviItem naviitem = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		naviitem = (NaviItem)getASSiteDataService().getNaviItem(form.getId()).clone();
	}else{
		naviitem = NaviItemFactory.createNaviItem();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	naviitem.setNameEN(form.getNameEN());
	naviitem.setTitleEN(form.getTitleEN());
	//handle image
	TemporaryFileHolder holder_icon = FileStorage.getTemporaryFile(req,"icon");
	if (holder_icon!=null && holder_icon.getData()!=null){
		FileStorage.removeFilePermanently( naviitem.getIcon() );
		FileStorage.storeFilePermanently(req, holder_icon.getFileName(),"icon");
		naviitem.setIcon(holder_icon.getFileName());
		FileStorage.removeTemporaryFile(req,"icon");
	}
	naviitem.setExternalLink(form.getExternalLink());
	naviitem.setInternalLink(form.getInternalLink());
	naviitem.setPageAlias(form.getPageAlias());
	naviitem.setClassName(form.getClassName());
	// skipped container subNavi
	naviitem.setPopup(form.isPopup());
	// skipped container guards
	naviitem.setAccessOperation(form.getAccessOperation());

	// delete image method start
	String fieldName = req.getParameter("fieldName");
	String fileName = req.getParameter("fileName");

	if (!StringUtils.isEmpty(fieldName) && !StringUtils.isEmpty(fileName)) {
		String setMethodName = "set"+WordUtils.capitalize(fieldName);
		Class<?> c = naviitem.getClass();
		try{
			Method m = c.getDeclaredMethod(setMethodName, new Class[]{String.class});
			m.invoke(naviitem, new Object[]{""});
			FileStorage.removeFilePermanently(fileName);
		}catch (NoSuchMethodException e){
			e.printStackTrace();
		}catch (InvocationTargetException ignored) {
			ignored.printStackTrace();
		}
	}
	// delete image method end


	NaviItem updatedCopy = null;
	if (create){
		updatedCopy = getASSiteDataService().createNaviItem(naviitem);
	}else{
		canUpdateNaviItems(naviitem, req);
		checkNaviItems(naviitem, req);
		updatedCopy = getASSiteDataService().updateNaviItem(naviitem);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("assitedataNaviItemEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(naviitem, req);
		res.sendRedirect("assitedataNaviItemShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(NaviItem naviitem, HttpServletRequest req) throws Exception{
	if(((LockableObject)naviitem).isLocked())
		unLockNaviItems(naviitem, req, false);
}

public ActionCommand assitedataNaviItemCopyLang(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String sourceLanguage = req.getParameter("pSrcLang");
	if (sourceLanguage==null || sourceLanguage.length()==0)
		throw new RuntimeException("No source language");

	String destLanguage = req.getParameter("pDestLang");
	if (destLanguage==null || destLanguage.length()==0)
		throw new RuntimeException("No destination language");

	String id = getStringParameter(req, PARAM_ID);
	NaviItem naviitem = getASSiteDataService().getNaviItem(id);
	canUpdateNaviItems(naviitem, req);
	checkNaviItems(naviitem, req);
	naviitem.copyLANG2LANG(sourceLanguage, destLanguage);
	getASSiteDataService().updateNaviItem(naviitem);
	res.sendRedirect("assitedataNaviItemEdit?ts="+System.currentTimeMillis()+"&pId="+id);
	return null;
}

public ActionCommand assitedataNaviItemSwitchMultilang(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	String value = getStringParameter(req, "value");
	NaviItem naviitem = getASSiteDataService().getNaviItem(id);
	canUpdateNaviItems(naviitem, req);
	checkNaviItems(naviitem, req);
	((MultilingualObject)naviitem).setMultilingualDisabledInstance(Boolean.valueOf(value));
	getASSiteDataService().updateNaviItem(naviitem);
	res.sendRedirect("assitedataNaviItemEdit?ts="+System.currentTimeMillis()+"&pId="+id);
	return null;
}

public ActionCommand assitedataNaviItemLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	NaviItem naviitemCurr = id != null && !id.equals("") ? getASSiteDataService().getNaviItem(id) : null;
	if(naviitemCurr != null && naviitemCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)naviitemCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockNaviItems(naviitemCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, naviitemCurr));
	return null;
}

public ActionCommand assitedataNaviItemUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	NaviItem naviitemCurr = id != null && !id.equals("") ? getASSiteDataService().getNaviItem(id) : null;
	if(naviitemCurr != null && naviitemCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)naviitemCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockNaviItems(naviitemCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, naviitemCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, NaviItem item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "assitedataNaviItemShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "assitedataNaviItemEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "assitedataNaviItemShow?ts="+System.currentTimeMillis();
}

public ActionCommand assitedataNaviItemClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	NaviItem naviitemCurr = id != null && !id.equals("") ? getASSiteDataService().getNaviItem(id) : null;
	if(naviitemCurr != null && naviitemCurr instanceof LockableObject && ((LockableObject)naviitemCurr).isLocked()) 
		unLockNaviItems(naviitemCurr, req, false);
	res.sendRedirect("assitedataNaviItemShow?ts="+System.currentTimeMillis());
	return null;
}

}
