/**
 ********************************************************************************
 *** MultiOpDialogMediaLinksAction.java                                       ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import net.anotheria.util.NumberUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.assitedata.data.MediaLinkFactory;
import net.anotheria.anosite.gen.assitedata.data.MediaLink;
import net.anotheria.anosite.gen.assitedata.bean.EditMediaLinkFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;

public class MultiOpDialogMediaLinksAction extends BaseMediaLinkAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("assitedataMediaLinkDelete"))
			return assitedataMediaLinkDelete(mapping, req, res);
		if (path.equals("assitedataMediaLinkDuplicate"))
			return assitedataMediaLinkDuplicate(mapping, req, res);
		if (path.equals("assitedataMediaLinkUpdate"))
			return assitedataMediaLinkUpdate(mapping, req, res);
		if (path.equals("assitedataMediaLinkClose"))
			return assitedataMediaLinkClose(mapping, req, res);
		if (path.equals("assitedataMediaLinkLock"))
			return assitedataMediaLinkLock(mapping, req, res);
		if (path.equals("assitedataMediaLinkUnLock"))
			return assitedataMediaLinkUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand assitedataMediaLinkDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			MediaLink medialinkCurr = getASSiteDataService().getMediaLink(id);
			if (medialinkCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)medialinkCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASSiteDataService().deleteMediaLink(id);
		}
		res.sendRedirect("assitedataMediaLinkShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand assitedataMediaLinkDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		MediaLink medialinkSrc = getASSiteDataService().getMediaLink(id);
		MediaLink medialinkDest = MediaLinkFactory.createMediaLink(medialinkSrc);



		MediaLink medialinkCreated = getASSiteDataService().createMediaLink(medialinkDest);
		res.sendRedirect("assitedataMediaLinkEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+medialinkCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand assitedataMediaLinkUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditMediaLinkFB form = new EditMediaLinkFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		MediaLink medialink = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		medialink = (MediaLink)getASSiteDataService().getMediaLink(form.getId()).clone();
	}else{
		medialink = MediaLinkFactory.createMediaLink();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	medialink.setName(form.getName());
	medialink.setFile(form.getFile());
	medialink.setHref(form.getHref());
	medialink.setType(form.getType());
	medialink.setMedia(form.getMedia());
	medialink.setRel(form.getRel());
	medialink.setRev(form.getRev());
	medialink.setHreflang(form.getHreflang());
	medialink.setCharset(form.getCharset());
	medialink.setBrowserFiltering(form.getBrowserFiltering());
	medialink.setOnload(form.getOnload());
	// skipped container guards

	MediaLink updatedCopy = null;
	if (create){
		updatedCopy = getASSiteDataService().createMediaLink(medialink);
	}else{
		canUpdateMediaLinks(medialink, req);
		checkMediaLinks(medialink, req);
		updatedCopy = getASSiteDataService().updateMediaLink(medialink);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("assitedataMediaLinkEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(medialink, req);
		res.sendRedirect("assitedataMediaLinkShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(MediaLink medialink, HttpServletRequest req) throws Exception{
	if(((LockableObject)medialink).isLocked())
		unLockMediaLinks(medialink, req, false);
}

public ActionCommand assitedataMediaLinkLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	MediaLink medialinkCurr = id != null && !id.equals("") ? getASSiteDataService().getMediaLink(id) : null;
	if(medialinkCurr != null && medialinkCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)medialinkCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockMediaLinks(medialinkCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, medialinkCurr));
	return null;
}

public ActionCommand assitedataMediaLinkUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	MediaLink medialinkCurr = id != null && !id.equals("") ? getASSiteDataService().getMediaLink(id) : null;
	if(medialinkCurr != null && medialinkCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)medialinkCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockMediaLinks(medialinkCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, medialinkCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, MediaLink item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "assitedataMediaLinkShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "assitedataMediaLinkEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "assitedataMediaLinkShow?ts="+System.currentTimeMillis();
}

public ActionCommand assitedataMediaLinkClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	MediaLink medialinkCurr = id != null && !id.equals("") ? getASSiteDataService().getMediaLink(id) : null;
	if(medialinkCurr != null && medialinkCurr instanceof LockableObject && ((LockableObject)medialinkCurr).isLocked()) 
		unLockMediaLinks(medialinkCurr, req, false);
	res.sendRedirect("assitedataMediaLinkShow?ts="+System.currentTimeMillis());
	return null;
}

}
