/**
 ********************************************************************************
 *** ShowLocalizationBundlesAction.java                                       ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle;
import net.anotheria.anosite.gen.asresourcedata.bean.LocalizationBundleListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.asresourcedata.bean.LocalizationBundleListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;

public class ShowLocalizationBundlesAction extends BaseLocalizationBundleAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"LocalizationBundle";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"LocalizationBundle";
	private static Logger log = LoggerFactory.getLogger(ShowLocalizationBundlesAction.class);
	private Sorter<LocalizationBundleListItemBean> sorter;

	private IAttributeDecorator idDecorator;
	private IAttributeDecorator nameDecorator;

	private DocumentFilter nameFilterAZ;
	private DocumentFilter anyFilterMissingTranslation;

	public ShowLocalizationBundlesAction(){
		sorter = new QuickSorter<LocalizationBundleListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
			nameDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
			anyFilterMissingTranslation = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.MissingAnyTranslationFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		String filterParameter1 = "";
		try{ 
			filterParameter1 = getStringParameter(req, "pFilter1");
			addBeanToSession(req, SA_FILTER+"1", filterParameter1);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter1 = (String)getBeanFromSession(req, SA_FILTER+"1");
			if (filterParameter1==null)
				filterParameter1 = "";
		}
		req.setAttribute("currentFilterParameter1", filterParameter1);

		int sortMethod = LocalizationBundleListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = LocalizationBundleListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		LocalizationBundleListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new LocalizationBundleListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (LocalizationBundleListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new LocalizationBundleListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<LocalizationBundle> _unfiltered_localizationbundles = getASResourceDataService().getLocalizationBundles();
		List<LocalizationBundle> localizationbundles = new ArrayList<LocalizationBundle>();
		for (int i=0; i<_unfiltered_localizationbundles.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_localizationbundles.get(i), "name", filterParameter0));
			mayPass = mayPass && (anyFilterMissingTranslation.mayPass(_unfiltered_localizationbundles.get(i), "any", filterParameter1));
			if (mayPass)
				localizationbundles.add(_unfiltered_localizationbundles.get(i));
		}
		List<LocalizationBundleListItemBean> beans = new ArrayList<LocalizationBundleListItemBean>(localizationbundles.size());
		for (LocalizationBundle localizationbundle : localizationbundles){
			checkLocalizationBundles(localizationbundle, req);
			LocalizationBundleListItemBean bean = makeLocalizationBundleListItemBean(localizationbundle);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "localizationbundles", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		addBeanToRequest(req, "anyFilterMissingTranslation", anyFilterMissingTranslation.getTriggerer("any"));
		return mapping.success();
	}

	protected LocalizationBundleListItemBean makeLocalizationBundleListItemBean(LocalizationBundle localizationbundle) {
		LocalizationBundleListItemBean bean = new LocalizationBundleListItemBean();
		bean.setPlainId(localizationbundle.getId());
		bean.setIdForSorting(localizationbundle.getId());
		bean.setId(idDecorator.decorate(localizationbundle, "id", "3"));
		bean.setNameForSorting(localizationbundle.getName());
		bean.setName(nameDecorator.decorate(localizationbundle, "name", "null"));
		bean.setLocked(((LockableObject)localizationbundle).isLocked());
		bean.setLockerId(((LockableObject)localizationbundle).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)localizationbundle).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)localizationbundle).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(localizationbundle.getLastUpdateTimestamp()));
		return bean;
	}
}
