/**
 ********************************************************************************
 *** MultiOpPdfTemplatesLocalizationsAction.java                              ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.action;

import java.util.List;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asresourcedata.data.PdfTemplateFactory;
import net.anotheria.anosite.gen.asresourcedata.data.PdfTemplate;
import net.anotheria.anosite.gen.asresourcedata.bean.LocalizationsElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.asresourcedata.bean.LocalizationsQuickAddFB;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundleSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpPdfTemplatesLocalizationsAction extends BasePdfTemplateAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("asresourcedataPdfTemplateLocalizationsShow"))
			return asresourcedataPdfTemplateLocalizationsShow(mapping, req, res);
		if (path.equals("asresourcedataPdfTemplateLocalizationsAdd"))
			return asresourcedataPdfTemplateLocalizationsAdd(mapping, req, res);
		if (path.equals("asresourcedataPdfTemplateLocalizationsDelete"))
			return asresourcedataPdfTemplateLocalizationsDelete(mapping, req, res);
		if (path.equals("asresourcedataPdfTemplateLocalizationsMove"))
			return asresourcedataPdfTemplateLocalizationsMove(mapping, req, res);
		if (path.equals("asresourcedataPdfTemplateLocalizationsQuickAdd"))
			return asresourcedataPdfTemplateLocalizationsQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand asresourcedataPdfTemplateLocalizationsShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		PdfTemplate pdftemplate = getASResourceDataService().getPdfTemplate(id);
		addBeanToRequest(req, "ownerId", id);
		checkPdfTemplates(pdftemplate, req);

		LocalizationsElementFB form = new LocalizationsElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(pdftemplate.getId());
		addBeanToRequest(req, "asresourcedataPdfTemplateLocalizationsElementForm", form);

		LocalizationsQuickAddFB quickAddForm = new LocalizationsQuickAddFB() ;
		quickAddForm.setOwnerId(pdftemplate.getId());
		addBeanToRequest(req, "asresourcedataPdfTemplateLocalizationsQuickAddForm", quickAddForm);


		//link guard to ASResourceData.LocalizationBundle
		List<LocalizationBundle> localizationbundles = getASResourceDataService().getLocalizationBundles(new LocalizationBundleSortType(LocalizationBundleSortType.SORT_BY_NAME));
		List<LabelValueBean> localizationbundlesValues = new ArrayList<LabelValueBean>(localizationbundles.size());
		for (int i=0; i<localizationbundles.size(); i++){
			net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle tmp_localizationbundle = (net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle) localizationbundles.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_localizationbundle.getId(), tmp_localizationbundle.getName()+" ["+tmp_localizationbundle.getId()+"]" );
			localizationbundlesValues.add(bean);
		}
		addBeanToRequest(req, "guardValuesCollection", localizationbundlesValues);
		// generate list ...
		int size = pdftemplate.getLocalizationsSize();
		List<LocalizationsElementFB> beans = new ArrayList<LocalizationsElementFB>(size);
		for (int i=0; i<size; i++){
			String value = pdftemplate.getLocalizationsElement(i);
			LocalizationsElementFB bean = new LocalizationsElementFB();
			bean.setOwnerId(pdftemplate.getId());
			bean.setPosition(i);
			bean.setGuard(value);
			try{
				LocalizationBundle tmp_localizationbundle = getASResourceDataService().getLocalizationBundle(value);
				bean.setDescription(tmp_localizationbundle.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand asresourcedataPdfTemplateLocalizationsDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		PdfTemplate pdftemplateCurr = getASResourceDataService().getPdfTemplate(id);
		canUpdatePdfTemplates(pdftemplateCurr, req);
		checkPdfTemplates(pdftemplateCurr, req);
		int position = getIntParameter(req, "pPosition");
		PdfTemplate pdftemplate = getASResourceDataService().getPdfTemplate(id);
		pdftemplate.removeLocalizationsElement(position);
		getASResourceDataService().updatePdfTemplate(pdftemplate);
		return asresourcedataPdfTemplateLocalizationsShow(mapping, req, res);
	}

	public ActionCommand asresourcedataPdfTemplateLocalizationsMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		PdfTemplate pdftemplate = getASResourceDataService().getPdfTemplate(id);
		canUpdatePdfTemplates(pdftemplate, req);
		checkPdfTemplates(pdftemplate, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(pdftemplate, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(pdftemplate, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(pdftemplate, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(pdftemplate, position);
		return asresourcedataPdfTemplateLocalizationsShow(mapping, req, res);
	}

	private void moveUp(PdfTemplate pdftemplate, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		pdftemplate.swapLocalizationsElement(position, position-1);
		getASResourceDataService().updatePdfTemplate(pdftemplate);
	}

	private void moveTop(PdfTemplate pdftemplate, int position) throws ASGRuntimeException {
		List<String> targetList = pdftemplate.getLocalizations();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		pdftemplate.setLocalizations(targetList);
		getASResourceDataService().updatePdfTemplate(pdftemplate);
	}

	private void moveDown(PdfTemplate pdftemplate, int position) throws ASGRuntimeException {
		if (position<pdftemplate.getLocalizationsSize()-1){
			pdftemplate.swapLocalizationsElement(position, position+1);
			getASResourceDataService().updatePdfTemplate(pdftemplate);
		}
	}

	private void moveBottom(PdfTemplate pdftemplate, int position) throws ASGRuntimeException {
		List<String> targetList = pdftemplate.getLocalizations();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		pdftemplate.setLocalizations(targetList);
		getASResourceDataService().updatePdfTemplate(pdftemplate);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand asresourcedataPdfTemplateLocalizationsAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		LocalizationsElementFB form = new LocalizationsElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		PdfTemplate pdftemplate;
		pdftemplate = getASResourceDataService().getPdfTemplate(id);
		canUpdatePdfTemplates(pdftemplate, req);
		checkPdfTemplates(pdftemplate, req);
		pdftemplate.addLocalizationsElement(form.getGuard());
		getASResourceDataService().updatePdfTemplate(pdftemplate);
		return asresourcedataPdfTemplateLocalizationsShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand asresourcedataPdfTemplateLocalizationsQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		LocalizationsQuickAddFB form = new LocalizationsQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		PdfTemplate pdftemplate;
		pdftemplate = getASResourceDataService().getPdfTemplate(id);
		canUpdatePdfTemplates(pdftemplate, req);
		checkPdfTemplates(pdftemplate, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				pdftemplate.addLocalizationsElement(""+i);
			}
		}
		getASResourceDataService().updatePdfTemplate(pdftemplate);
		return asresourcedataPdfTemplateLocalizationsShow(mapping, req, res);
	}

}
