/**
 ********************************************************************************
 *** MultiOpMailTemplatesLocalizationsAction.java                             ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.action;

import java.util.List;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asresourcedata.data.MailTemplateFactory;
import net.anotheria.anosite.gen.asresourcedata.data.MailTemplate;
import net.anotheria.anosite.gen.asresourcedata.bean.LocalizationsElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.asresourcedata.bean.LocalizationsQuickAddFB;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundleSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpMailTemplatesLocalizationsAction extends BaseMailTemplateAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("asresourcedataMailTemplateLocalizationsShow"))
			return asresourcedataMailTemplateLocalizationsShow(mapping, req, res);
		if (path.equals("asresourcedataMailTemplateLocalizationsAdd"))
			return asresourcedataMailTemplateLocalizationsAdd(mapping, req, res);
		if (path.equals("asresourcedataMailTemplateLocalizationsDelete"))
			return asresourcedataMailTemplateLocalizationsDelete(mapping, req, res);
		if (path.equals("asresourcedataMailTemplateLocalizationsMove"))
			return asresourcedataMailTemplateLocalizationsMove(mapping, req, res);
		if (path.equals("asresourcedataMailTemplateLocalizationsQuickAdd"))
			return asresourcedataMailTemplateLocalizationsQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand asresourcedataMailTemplateLocalizationsShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		MailTemplate mailtemplate = getASResourceDataService().getMailTemplate(id);
		addBeanToRequest(req, "ownerId", id);
		checkMailTemplates(mailtemplate, req);

		LocalizationsElementFB form = new LocalizationsElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(mailtemplate.getId());
		addBeanToRequest(req, "asresourcedataMailTemplateLocalizationsElementForm", form);

		LocalizationsQuickAddFB quickAddForm = new LocalizationsQuickAddFB() ;
		quickAddForm.setOwnerId(mailtemplate.getId());
		addBeanToRequest(req, "asresourcedataMailTemplateLocalizationsQuickAddForm", quickAddForm);


		//link guard to ASResourceData.LocalizationBundle
		List<LocalizationBundle> localizationbundles = getASResourceDataService().getLocalizationBundles(new LocalizationBundleSortType(LocalizationBundleSortType.SORT_BY_NAME));
		List<LabelValueBean> localizationbundlesValues = new ArrayList<LabelValueBean>(localizationbundles.size());
		for (int i=0; i<localizationbundles.size(); i++){
			net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle tmp_localizationbundle = (net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle) localizationbundles.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_localizationbundle.getId(), tmp_localizationbundle.getName()+" ["+tmp_localizationbundle.getId()+"]" );
			localizationbundlesValues.add(bean);
		}
		addBeanToRequest(req, "guardValuesCollection", localizationbundlesValues);
		// generate list ...
		int size = mailtemplate.getLocalizationsSize();
		List<LocalizationsElementFB> beans = new ArrayList<LocalizationsElementFB>(size);
		for (int i=0; i<size; i++){
			String value = mailtemplate.getLocalizationsElement(i);
			LocalizationsElementFB bean = new LocalizationsElementFB();
			bean.setOwnerId(mailtemplate.getId());
			bean.setPosition(i);
			bean.setGuard(value);
			try{
				LocalizationBundle tmp_localizationbundle = getASResourceDataService().getLocalizationBundle(value);
				bean.setDescription(tmp_localizationbundle.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand asresourcedataMailTemplateLocalizationsDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		MailTemplate mailtemplateCurr = getASResourceDataService().getMailTemplate(id);
		canUpdateMailTemplates(mailtemplateCurr, req);
		checkMailTemplates(mailtemplateCurr, req);
		int position = getIntParameter(req, "pPosition");
		MailTemplate mailtemplate = getASResourceDataService().getMailTemplate(id);
		mailtemplate.removeLocalizationsElement(position);
		getASResourceDataService().updateMailTemplate(mailtemplate);
		return asresourcedataMailTemplateLocalizationsShow(mapping, req, res);
	}

	public ActionCommand asresourcedataMailTemplateLocalizationsMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		MailTemplate mailtemplate = getASResourceDataService().getMailTemplate(id);
		canUpdateMailTemplates(mailtemplate, req);
		checkMailTemplates(mailtemplate, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(mailtemplate, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(mailtemplate, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(mailtemplate, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(mailtemplate, position);
		return asresourcedataMailTemplateLocalizationsShow(mapping, req, res);
	}

	private void moveUp(MailTemplate mailtemplate, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		mailtemplate.swapLocalizationsElement(position, position-1);
		getASResourceDataService().updateMailTemplate(mailtemplate);
	}

	private void moveTop(MailTemplate mailtemplate, int position) throws ASGRuntimeException {
		List<String> targetList = mailtemplate.getLocalizations();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		mailtemplate.setLocalizations(targetList);
		getASResourceDataService().updateMailTemplate(mailtemplate);
	}

	private void moveDown(MailTemplate mailtemplate, int position) throws ASGRuntimeException {
		if (position<mailtemplate.getLocalizationsSize()-1){
			mailtemplate.swapLocalizationsElement(position, position+1);
			getASResourceDataService().updateMailTemplate(mailtemplate);
		}
	}

	private void moveBottom(MailTemplate mailtemplate, int position) throws ASGRuntimeException {
		List<String> targetList = mailtemplate.getLocalizations();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		mailtemplate.setLocalizations(targetList);
		getASResourceDataService().updateMailTemplate(mailtemplate);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand asresourcedataMailTemplateLocalizationsAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		LocalizationsElementFB form = new LocalizationsElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		MailTemplate mailtemplate;
		mailtemplate = getASResourceDataService().getMailTemplate(id);
		canUpdateMailTemplates(mailtemplate, req);
		checkMailTemplates(mailtemplate, req);
		mailtemplate.addLocalizationsElement(form.getGuard());
		getASResourceDataService().updateMailTemplate(mailtemplate);
		return asresourcedataMailTemplateLocalizationsShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand asresourcedataMailTemplateLocalizationsQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		LocalizationsQuickAddFB form = new LocalizationsQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		MailTemplate mailtemplate;
		mailtemplate = getASResourceDataService().getMailTemplate(id);
		canUpdateMailTemplates(mailtemplate, req);
		checkMailTemplates(mailtemplate, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				mailtemplate.addLocalizationsElement(""+i);
			}
		}
		getASResourceDataService().updateMailTemplate(mailtemplate);
		return asresourcedataMailTemplateLocalizationsShow(mapping, req, res);
	}

}
