/**
 ********************************************************************************
 *** MultiOpDialogLocalizationBundlesAction.java                              ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.action;

import net.anotheria.util.NumberUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundleFactory;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle;
import net.anotheria.anosite.gen.asresourcedata.bean.EditLocalizationBundleFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import net.anotheria.asg.data.MultilingualObject;

public class MultiOpDialogLocalizationBundlesAction extends BaseLocalizationBundleAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("asresourcedataLocalizationBundleDelete"))
			return asresourcedataLocalizationBundleDelete(mapping, req, res);
		if (path.equals("asresourcedataLocalizationBundleDuplicate"))
			return asresourcedataLocalizationBundleDuplicate(mapping, req, res);
		if (path.equals("asresourcedataLocalizationBundleUpdate"))
			return asresourcedataLocalizationBundleUpdate(mapping, req, res);
		if (path.equals("asresourcedataLocalizationBundleClose"))
			return asresourcedataLocalizationBundleClose(mapping, req, res);
		if (path.equals("asresourcedataLocalizationBundleCopyLang"))
			return asresourcedataLocalizationBundleCopyLang(mapping, req, res);
		if (path.equals("asresourcedataLocalizationBundleSwitchMultilang"))
			return asresourcedataLocalizationBundleSwitchMultilang(mapping, req, res);
		if (path.equals("asresourcedataLocalizationBundleLock"))
			return asresourcedataLocalizationBundleLock(mapping, req, res);
		if (path.equals("asresourcedataLocalizationBundleUnLock"))
			return asresourcedataLocalizationBundleUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand asresourcedataLocalizationBundleDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			LocalizationBundle localizationbundleCurr = getASResourceDataService().getLocalizationBundle(id);
			if (localizationbundleCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)localizationbundleCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASResourceDataService().deleteLocalizationBundle(id);
		}
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand asresourcedataLocalizationBundleDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		LocalizationBundle localizationbundleSrc = getASResourceDataService().getLocalizationBundle(id);
		LocalizationBundle localizationbundleDest = LocalizationBundleFactory.createLocalizationBundle(localizationbundleSrc);


		LocalizationBundle localizationbundleCreated = getASResourceDataService().createLocalizationBundle(localizationbundleDest);
		res.sendRedirect("asresourcedataLocalizationBundleEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+localizationbundleCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand asresourcedataLocalizationBundleUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditLocalizationBundleFB form = new EditLocalizationBundleFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		LocalizationBundle localizationbundle = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		localizationbundle = (LocalizationBundle)getASResourceDataService().getLocalizationBundle(form.getId()).clone();
	}else{
		localizationbundle = LocalizationBundleFactory.createLocalizationBundle();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	localizationbundle.setName(form.getName());
	localizationbundle.setMessagesEN(form.getMessagesEN());
	localizationbundle.setParentBundle(form.getParentBundle());

	LocalizationBundle updatedCopy = null;
	if (create){
		updatedCopy = getASResourceDataService().createLocalizationBundle(localizationbundle);
	}else{
		canUpdateLocalizationBundles(localizationbundle, req);
		checkLocalizationBundles(localizationbundle, req);
		updatedCopy = getASResourceDataService().updateLocalizationBundle(localizationbundle);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("asresourcedataLocalizationBundleEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(localizationbundle, req);
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(LocalizationBundle localizationbundle, HttpServletRequest req) throws Exception{
	if(((LockableObject)localizationbundle).isLocked())
		unLockLocalizationBundles(localizationbundle, req, false);
}

public ActionCommand asresourcedataLocalizationBundleCopyLang(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String sourceLanguage = req.getParameter("pSrcLang");
	if (sourceLanguage==null || sourceLanguage.length()==0)
		throw new RuntimeException("No source language");

	String destLanguage = req.getParameter("pDestLang");
	if (destLanguage==null || destLanguage.length()==0)
		throw new RuntimeException("No destination language");

	String id = getStringParameter(req, PARAM_ID);
	LocalizationBundle localizationbundle = getASResourceDataService().getLocalizationBundle(id);
	canUpdateLocalizationBundles(localizationbundle, req);
	checkLocalizationBundles(localizationbundle, req);
	localizationbundle.copyLANG2LANG(sourceLanguage, destLanguage);
	getASResourceDataService().updateLocalizationBundle(localizationbundle);
	res.sendRedirect("asresourcedataLocalizationBundleEdit?ts="+System.currentTimeMillis()+"&pId="+id);
	return null;
}

public ActionCommand asresourcedataLocalizationBundleSwitchMultilang(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	String value = getStringParameter(req, "value");
	LocalizationBundle localizationbundle = getASResourceDataService().getLocalizationBundle(id);
	canUpdateLocalizationBundles(localizationbundle, req);
	checkLocalizationBundles(localizationbundle, req);
	((MultilingualObject)localizationbundle).setMultilingualDisabledInstance(Boolean.valueOf(value));
	getASResourceDataService().updateLocalizationBundle(localizationbundle);
	res.sendRedirect("asresourcedataLocalizationBundleEdit?ts="+System.currentTimeMillis()+"&pId="+id);
	return null;
}

public ActionCommand asresourcedataLocalizationBundleLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	LocalizationBundle localizationbundleCurr = id != null && !id.equals("") ? getASResourceDataService().getLocalizationBundle(id) : null;
	if(localizationbundleCurr != null && localizationbundleCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)localizationbundleCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockLocalizationBundles(localizationbundleCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, localizationbundleCurr));
	return null;
}

public ActionCommand asresourcedataLocalizationBundleUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	LocalizationBundle localizationbundleCurr = id != null && !id.equals("") ? getASResourceDataService().getLocalizationBundle(id) : null;
	if(localizationbundleCurr != null && localizationbundleCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)localizationbundleCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockLocalizationBundles(localizationbundleCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, localizationbundleCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, LocalizationBundle item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "asresourcedataLocalizationBundleEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis();
}

public ActionCommand asresourcedataLocalizationBundleClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	LocalizationBundle localizationbundleCurr = id != null && !id.equals("") ? getASResourceDataService().getLocalizationBundle(id) : null;
	if(localizationbundleCurr != null && localizationbundleCurr instanceof LockableObject && ((LockableObject)localizationbundleCurr).isLocked()) 
		unLockLocalizationBundles(localizationbundleCurr, req, false);
	res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
	return null;
}

}
