/**
 ********************************************************************************
 *** ExportImagesAction.java                                                  ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.xml.XMLNode;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asresourcedata.data.Image;
import net.anotheria.anosite.gen.asresourcedata.data.ImageSortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;
import net.anotheria.anosite.gen.asresourcedata.bean.ImageListItemBeanSortType;

public class ExportImagesAction extends BaseImageAction{

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"Image";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"Image";
	private static final List<String> ITEMS_ON_PAGE_SELECTOR = java.util.Arrays.asList(new String[]{"5","10","20","25","50","100","500","1000"});
	private static final Logger log = LoggerFactory.getLogger(ExportImagesAction.class);
	private Sorter<Image> sorter;

	private DocumentFilter nameFilterAZ;
	private DocumentFilter AnyFilterMissingTranslation;

	public ExportImagesAction(){
		super();
		sorter = new QuickSorter<Image>();
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
			AnyFilterMissingTranslation = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.MissingAnyTranslationFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		String filterParameter1 = "";
		try{ 
			filterParameter1 = getStringParameter(req, "pFilter1");
			addBeanToSession(req, SA_FILTER+"1", filterParameter1);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter1 = (String)getBeanFromSession(req, SA_FILTER+"1");
			if (filterParameter1==null)
				filterParameter1 = "";
		}
		req.setAttribute("currentFilterParameter1", filterParameter1);

		int sortMethod = ImageListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = ImageListItemBeanSortType.ASC;
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = ImageListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			sortOrder = getStringParameter(req, PARAM_SORT_ORDER).equals("ASC") ? 
				ImageListItemBeanSortType.ASC : ImageListItemBeanSortType.DESC;
		}catch(Exception ignored){}

		ImageListItemBeanSortType sessionSortType  = null;
		ImageSortType sortType = null;
		if (sortParamSet){
			sessionSortType = new ImageListItemBeanSortType(sortMethod, sortOrder);
			sortType = new ImageSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sessionSortType);
		}else{
			sessionSortType = (ImageListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			sortType = sessionSortType == null ? new ImageSortType(sortMethod, sortOrder) : new ImageSortType(sessionSortType.getSortBy(), sessionSortType.getSortOrder());
			sessionSortType = sessionSortType == null ? new ImageListItemBeanSortType(sortMethod, sortOrder) : sessionSortType;
		}
		req.setAttribute("currentSortCode", sessionSortType.getMethodAndOrderCode());

		List<Image> _unfiltered_images = getASResourceDataService().getImages();
		List<Image> images = new ArrayList<Image>();
		for (Image element : _unfiltered_images ){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass( element, "name", filterParameter0));
			mayPass = mayPass && (AnyFilterMissingTranslation.mayPass( element, "Any", filterParameter1));
			if (mayPass)
				images.add(element);
		}
		images = sorter.sort(images, sortType);

		addBeanToRequest(req, "images", images);

		XMLNode beans = getASResourceDataService().exportImagesToXML(images);


		/**
		 * for XML node - page
		 */
		addBeanToRequest(req, "imagesXML", beans);
		/**
		 * for CSV - page
		 */
		addBeanToRequest(req, "imagesCSV", images);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer(""));
		addBeanToRequest(req, "AnyFilterMissingTranslation", AnyFilterMissingTranslation.getTriggerer(""));
		return mapping.success();
	}

}
