/**
 ********************************************************************************
 *** BaseFileLinkAction.java                                                  ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.action;

import net.anotheria.anosite.gen.shared.action.BaseResourcesAction;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.asresourcedata.data.FileLink;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseFileLinkAction extends BaseResourcesAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "File";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASResourceData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "FileLink";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, FileLink filelink) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASResourceData.FileLink").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.FileLink", filelink, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.FileLink", filelink, "title");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.title", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.FileLink", filelink, "file");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.file", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.FileLink", filelink, "size");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.size", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockFileLinks(FileLink filelink, HttpServletRequest req) throws Exception{
		if(filelink instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)filelink;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASResourceDataService().updateFileLink( filelink);
			logger.info("Lock-OPERATION, document with id : ["+filelink.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockFileLinks(FileLink filelink, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(filelink instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)filelink;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASResourceDataService().updateFileLink( filelink);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+filelink.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+filelink.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkFileLinks(FileLink filelink, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = filelink instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)filelink).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)filelink).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockFileLinks(filelink, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateFileLinks(FileLink filelink, HttpServletRequest req) throws Exception{
		if(filelink instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)filelink, false, getUserId(req));
		}
		if (isTimeoutReached(filelink)) {
			checkFileLinks(filelink, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(filelink, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(FileLink filelink){
		if (filelink instanceof LockableObject) {
			LockableObject lock = (LockableObject)filelink;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(FileLink filelink, HttpServletRequest req){
		if (filelink instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)filelink;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
