/**
 ********************************************************************************
 *** ShowGenericActionDefsAction.java                                         ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asgenericaction.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asgenericaction.data.GenericActionDef;
import net.anotheria.anosite.gen.asgenericaction.bean.GenericActionDefListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.asgenericaction.bean.GenericActionDefListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;

public class ShowGenericActionDefsAction extends BaseGenericActionDefAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"GenericActionDef";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"GenericActionDef";
	private static Logger log = LoggerFactory.getLogger(ShowGenericActionDefsAction.class);
	private Sorter<GenericActionDefListItemBean> sorter;

	private IAttributeDecorator idDecorator;

	private DocumentFilter nameFilterAZ;

	public ShowGenericActionDefsAction(){
		sorter = new QuickSorter<GenericActionDefListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = GenericActionDefListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = GenericActionDefListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		GenericActionDefListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new GenericActionDefListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (GenericActionDefListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new GenericActionDefListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<GenericActionDef> _unfiltered_genericactiondefs = getASGenericActionService().getGenericActionDefs();
		List<GenericActionDef> genericactiondefs = new ArrayList<GenericActionDef>();
		for (int i=0; i<_unfiltered_genericactiondefs.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_genericactiondefs.get(i), "name", filterParameter0));
			if (mayPass)
				genericactiondefs.add(_unfiltered_genericactiondefs.get(i));
		}
		List<GenericActionDefListItemBean> beans = new ArrayList<GenericActionDefListItemBean>(genericactiondefs.size());
		for (GenericActionDef genericactiondef : genericactiondefs){
			checkGenericActionDefs(genericactiondef, req);
			GenericActionDefListItemBean bean = makeGenericActionDefListItemBean(genericactiondef);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "genericactiondefs", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		return mapping.success();
	}

	protected GenericActionDefListItemBean makeGenericActionDefListItemBean(GenericActionDef genericactiondef) {
		GenericActionDefListItemBean bean = new GenericActionDefListItemBean();
		bean.setPlainId(genericactiondef.getId());
		bean.setIdForSorting(genericactiondef.getId());
		bean.setId(idDecorator.decorate(genericactiondef, "id", "3"));
		bean.setName(genericactiondef.getName());
		bean.setClazz(genericactiondef.getClazz());
		bean.setLocked(((LockableObject)genericactiondef).isLocked());
		bean.setLockerId(((LockableObject)genericactiondef).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)genericactiondef).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)genericactiondef).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(genericactiondef.getLastUpdateTimestamp()));
		return bean;
	}
}
