/**
 ********************************************************************************
 *** ShowFeaturesAction.java                                                  ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asfeature.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asfeature.data.Feature;
import net.anotheria.anosite.gen.asfeature.bean.FeatureListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.asfeature.bean.FeatureListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;

public class ShowFeaturesAction extends BaseFeatureAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"Feature";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"Feature";
	private static Logger log = LoggerFactory.getLogger(ShowFeaturesAction.class);
	private Sorter<FeatureListItemBean> sorter;

	private IAttributeDecorator idDecorator;
	private IAttributeDecorator nameDecorator;
	private IAttributeDecorator guardsDecorator;

	private DocumentFilter nameFilterAZ;

	public ShowFeaturesAction(){
		sorter = new QuickSorter<FeatureListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
			nameDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
			guardsDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.GuardCMS2Decorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = FeatureListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = FeatureListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		FeatureListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new FeatureListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (FeatureListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new FeatureListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<Feature> _unfiltered_features = getASFeatureService().getFeatures();
		List<Feature> features = new ArrayList<Feature>();
		for (int i=0; i<_unfiltered_features.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_features.get(i), "name", filterParameter0));
			if (mayPass)
				features.add(_unfiltered_features.get(i));
		}
		List<FeatureListItemBean> beans = new ArrayList<FeatureListItemBean>(features.size());
		for (Feature feature : features){
			checkFeatures(feature, req);
			FeatureListItemBean bean = makeFeatureListItemBean(feature);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "features", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		return mapping.success();
	}

	protected FeatureListItemBean makeFeatureListItemBean(Feature feature) {
		FeatureListItemBean bean = new FeatureListItemBean();
		bean.setPlainId(feature.getId());
		bean.setIdForSorting(feature.getId());
		bean.setId(idDecorator.decorate(feature, "id", "3"));
		bean.setNameForSorting(feature.getName());
		bean.setName(nameDecorator.decorate(feature, "name", "null"));
		bean.setEnabled(feature.getEnabled());
		bean.setActiveInProduction(feature.getActiveInProduction());
		bean.setObsolete(feature.getObsolete());
		bean.setGuardsForSorting(feature.getGuards());
		bean.setGuards(guardsDecorator.decorate(feature, "guards", "null"));
		bean.setLocked(((LockableObject)feature).isLocked());
		bean.setLockerId(((LockableObject)feature).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)feature).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)feature).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(feature.getLastUpdateTimestamp()));
		return bean;
	}
}
