/**
 ********************************************************************************
 *** BaseExperimentAction.java                                                ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asexperiment.action;

import net.anotheria.anosite.gen.shared.action.BaseFeaturesAction;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.asexperiment.data.Experiment;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseExperimentAction extends BaseFeaturesAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Experiments";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASExperiment";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "Experiment";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, Experiment experiment) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASExperiment.Experiment").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASExperiment.Experiment", experiment, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASExperiment.Experiment", experiment, "active");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.active", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASExperiment.Experiment", experiment, "distribution");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.distribution", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASExperiment.Experiment", experiment, "description");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.description", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASExperiment.Experiment", experiment, "variant1");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.variant1", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASExperiment.Experiment", experiment, "variant2");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.variant2", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASExperiment.Experiment", experiment, "variant3");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.variant3", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASExperiment.Experiment", experiment, "variant4");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.variant4", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASExperiment.Experiment", experiment, "variant5");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.variant5", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASExperiment.Experiment", experiment, "variant6");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.variant6", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASExperiment.Experiment", experiment, "variant7");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.variant7", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASExperiment.Experiment", experiment, "variant8");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.variant8", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASExperiment.Experiment", experiment, "variant9");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.variant9", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASExperiment.Experiment", experiment, "variant10");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.variant10", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockExperiments(Experiment experiment, HttpServletRequest req) throws Exception{
		if(experiment instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)experiment;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASExperimentService().updateExperiment( experiment);
			logger.info("Lock-OPERATION, document with id : ["+experiment.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockExperiments(Experiment experiment, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(experiment instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)experiment;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASExperimentService().updateExperiment( experiment);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+experiment.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+experiment.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkExperiments(Experiment experiment, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = experiment instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)experiment).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)experiment).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockExperiments(experiment, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateExperiments(Experiment experiment, HttpServletRequest req) throws Exception{
		if(experiment instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)experiment, false, getUserId(req));
		}
		if (isTimeoutReached(experiment)) {
			checkExperiments(experiment, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(experiment, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(Experiment experiment){
		if (experiment instanceof LockableObject) {
			LockableObject lock = (LockableObject)experiment;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(Experiment experiment, HttpServletRequest req){
		if (experiment instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)experiment;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
