/**
 ********************************************************************************
 *** BaseCustomGuardDefAction.java                                            ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.ascustomdata.action;

import net.anotheria.anosite.gen.shared.action.BaseDefinitionsAction;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.ascustomdata.data.CustomGuardDef;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseCustomGuardDefAction extends BaseDefinitionsAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "CustomGuard";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASCustomData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "CustomGuardDef";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, CustomGuardDef customguarddef) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASCustomData.CustomGuardDef").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASCustomData.CustomGuardDef", customguarddef, "parameter1");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter1", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASCustomData.CustomGuardDef", customguarddef, "parameter2");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter2", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASCustomData.CustomGuardDef", customguarddef, "parameter3");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter3", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASCustomData.CustomGuardDef", customguarddef, "parameter4");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter4", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASCustomData.CustomGuardDef", customguarddef, "parameter5");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter5", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASCustomData.CustomGuardDef", customguarddef, "description");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.description", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASCustomData.CustomGuardDef", customguarddef, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASCustomData.CustomGuardDef", customguarddef, "clazz");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.clazz", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockCustomGuardDefs(CustomGuardDef customguarddef, HttpServletRequest req) throws Exception{
		if(customguarddef instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)customguarddef;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASCustomDataService().updateCustomGuardDef( customguarddef);
			logger.info("Lock-OPERATION, document with id : ["+customguarddef.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockCustomGuardDefs(CustomGuardDef customguarddef, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(customguarddef instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)customguarddef;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASCustomDataService().updateCustomGuardDef( customguarddef);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+customguarddef.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+customguarddef.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkCustomGuardDefs(CustomGuardDef customguarddef, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = customguarddef instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)customguarddef).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)customguarddef).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockCustomGuardDefs(customguarddef, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateCustomGuardDefs(CustomGuardDef customguarddef, HttpServletRequest req) throws Exception{
		if(customguarddef instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)customguarddef, false, getUserId(req));
		}
		if (isTimeoutReached(customguarddef)) {
			checkCustomGuardDefs(customguarddef, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(customguarddef, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(CustomGuardDef customguarddef){
		if (customguarddef instanceof LockableObject) {
			LockableObject lock = (LockableObject)customguarddef;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(CustomGuardDef customguarddef, HttpServletRequest req){
		if (customguarddef instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)customguarddef;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
