/**
 ********************************************************************************
 *** BaseCustomActionDefAction.java                                           ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.ascustomaction.action;

import net.anotheria.anosite.gen.shared.action.BaseActionsAction;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.ascustomaction.data.CustomActionDef;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseCustomActionDefAction extends BaseActionsAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "CustomActions";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASCustomAction";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "CustomActionDef";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, CustomActionDef customactiondef) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASCustomAction.CustomActionDef").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASCustomAction.CustomActionDef", customactiondef, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASCustomAction.CustomActionDef", customactiondef, "clazz");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.clazz", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockCustomActionDefs(CustomActionDef customactiondef, HttpServletRequest req) throws Exception{
		if(customactiondef instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)customactiondef;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASCustomActionService().updateCustomActionDef( customactiondef);
			logger.info("Lock-OPERATION, document with id : ["+customactiondef.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockCustomActionDefs(CustomActionDef customactiondef, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(customactiondef instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)customactiondef;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASCustomActionService().updateCustomActionDef( customactiondef);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+customactiondef.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+customactiondef.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkCustomActionDefs(CustomActionDef customactiondef, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = customactiondef instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)customactiondef).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)customactiondef).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockCustomActionDefs(customactiondef, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateCustomActionDefs(CustomActionDef customactiondef, HttpServletRequest req) throws Exception{
		if(customactiondef instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)customactiondef, false, getUserId(req));
		}
		if (isTimeoutReached(customactiondef)) {
			checkCustomActionDefs(customactiondef, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(customactiondef, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(CustomActionDef customactiondef){
		if (customactiondef instanceof LockableObject) {
			LockableObject lock = (LockableObject)customactiondef;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(CustomActionDef customactiondef, HttpServletRequest req){
		if (customactiondef instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)customactiondef;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
