/**
 ********************************************************************************
 *** MultiOpPermissionsConstraintsAction.java                                 ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessconfiguration.action;

import java.util.List;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.PermissionFactory;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.Permission;
import net.anotheria.anosite.gen.anoaccessconfiguration.bean.ConstraintsElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.anoaccessconfiguration.bean.ConstraintsQuickAddFB;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.Constraint;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.ConstraintSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpPermissionsConstraintsAction extends BasePermissionAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("anoaccessconfigurationPermissionConstraintsShow"))
			return anoaccessconfigurationPermissionConstraintsShow(mapping, req, res);
		if (path.equals("anoaccessconfigurationPermissionConstraintsAdd"))
			return anoaccessconfigurationPermissionConstraintsAdd(mapping, req, res);
		if (path.equals("anoaccessconfigurationPermissionConstraintsDelete"))
			return anoaccessconfigurationPermissionConstraintsDelete(mapping, req, res);
		if (path.equals("anoaccessconfigurationPermissionConstraintsMove"))
			return anoaccessconfigurationPermissionConstraintsMove(mapping, req, res);
		if (path.equals("anoaccessconfigurationPermissionConstraintsQuickAdd"))
			return anoaccessconfigurationPermissionConstraintsQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand anoaccessconfigurationPermissionConstraintsShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Permission permission = getAnoAccessConfigurationService().getPermission(id);
		addBeanToRequest(req, "ownerId", id);
		checkPermissions(permission, req);

		ConstraintsElementFB form = new ConstraintsElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(permission.getId());
		addBeanToRequest(req, "anoaccessconfigurationPermissionConstraintsElementForm", form);

		ConstraintsQuickAddFB quickAddForm = new ConstraintsQuickAddFB() ;
		quickAddForm.setOwnerId(permission.getId());
		addBeanToRequest(req, "anoaccessconfigurationPermissionConstraintsQuickAddForm", quickAddForm);


		//link constraint to AnoAccessConfiguration.Constraint
		List<Constraint> constraints = getAnoAccessConfigurationService().getConstraints(new ConstraintSortType(ConstraintSortType.SORT_BY_NAME));
		List<LabelValueBean> constraintsValues = new ArrayList<LabelValueBean>(constraints.size());
		for (int i=0; i<constraints.size(); i++){
			net.anotheria.anosite.gen.anoaccessconfiguration.data.Constraint tmp_constraint = (net.anotheria.anosite.gen.anoaccessconfiguration.data.Constraint) constraints.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_constraint.getId(), tmp_constraint.getName()+" ["+tmp_constraint.getId()+"]" );
			constraintsValues.add(bean);
		}
		addBeanToRequest(req, "constraintValuesCollection", constraintsValues);
		// generate list ...
		int size = permission.getConstraintsSize();
		List<ConstraintsElementFB> beans = new ArrayList<ConstraintsElementFB>(size);
		for (int i=0; i<size; i++){
			String value = permission.getConstraintsElement(i);
			ConstraintsElementFB bean = new ConstraintsElementFB();
			bean.setOwnerId(permission.getId());
			bean.setPosition(i);
			bean.setConstraint(value);
			try{
				Constraint tmp_constraint = getAnoAccessConfigurationService().getConstraint(value);
				bean.setDescription(tmp_constraint.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand anoaccessconfigurationPermissionConstraintsDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Permission permissionCurr = getAnoAccessConfigurationService().getPermission(id);
		canUpdatePermissions(permissionCurr, req);
		checkPermissions(permissionCurr, req);
		int position = getIntParameter(req, "pPosition");
		Permission permission = getAnoAccessConfigurationService().getPermission(id);
		permission.removeConstraintsElement(position);
		getAnoAccessConfigurationService().updatePermission(permission);
		return anoaccessconfigurationPermissionConstraintsShow(mapping, req, res);
	}

	public ActionCommand anoaccessconfigurationPermissionConstraintsMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		Permission permission = getAnoAccessConfigurationService().getPermission(id);
		canUpdatePermissions(permission, req);
		checkPermissions(permission, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(permission, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(permission, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(permission, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(permission, position);
		return anoaccessconfigurationPermissionConstraintsShow(mapping, req, res);
	}

	private void moveUp(Permission permission, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		permission.swapConstraintsElement(position, position-1);
		getAnoAccessConfigurationService().updatePermission(permission);
	}

	private void moveTop(Permission permission, int position) throws ASGRuntimeException {
		List<String> targetList = permission.getConstraints();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		permission.setConstraints(targetList);
		getAnoAccessConfigurationService().updatePermission(permission);
	}

	private void moveDown(Permission permission, int position) throws ASGRuntimeException {
		if (position<permission.getConstraintsSize()-1){
			permission.swapConstraintsElement(position, position+1);
			getAnoAccessConfigurationService().updatePermission(permission);
		}
	}

	private void moveBottom(Permission permission, int position) throws ASGRuntimeException {
		List<String> targetList = permission.getConstraints();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		permission.setConstraints(targetList);
		getAnoAccessConfigurationService().updatePermission(permission);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand anoaccessconfigurationPermissionConstraintsAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		ConstraintsElementFB form = new ConstraintsElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Permission permission;
		permission = getAnoAccessConfigurationService().getPermission(id);
		canUpdatePermissions(permission, req);
		checkPermissions(permission, req);
		permission.addConstraintsElement(form.getConstraint());
		getAnoAccessConfigurationService().updatePermission(permission);
		return anoaccessconfigurationPermissionConstraintsShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand anoaccessconfigurationPermissionConstraintsQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		ConstraintsQuickAddFB form = new ConstraintsQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Permission permission;
		permission = getAnoAccessConfigurationService().getPermission(id);
		canUpdatePermissions(permission, req);
		checkPermissions(permission, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				permission.addConstraintsElement(""+i);
			}
		}
		getAnoAccessConfigurationService().updatePermission(permission);
		return anoaccessconfigurationPermissionConstraintsShow(mapping, req, res);
	}

}
