/**
 ********************************************************************************
 *** BaseAccessOperationAction.java                                           ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessconfiguration.action;

import net.anotheria.anosite.gen.shared.action.BaseAnoAccessConfigurationAction;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.AccessOperation;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseAccessOperationAction extends BaseAnoAccessConfigurationAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Access Operations";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "AnoAccessConfiguration";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "AccessOperation";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, AccessOperation accessoperation) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("AnoAccessConfiguration.AccessOperation").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessConfiguration.AccessOperation", accessoperation, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessConfiguration.AccessOperation", accessoperation, "description");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.description", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockAccessOperations(AccessOperation accessoperation, HttpServletRequest req) throws Exception{
		if(accessoperation instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)accessoperation;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getAnoAccessConfigurationService().updateAccessOperation( accessoperation);
			logger.info("Lock-OPERATION, document with id : ["+accessoperation.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockAccessOperations(AccessOperation accessoperation, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(accessoperation instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)accessoperation;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getAnoAccessConfigurationService().updateAccessOperation( accessoperation);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+accessoperation.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+accessoperation.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkAccessOperations(AccessOperation accessoperation, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = accessoperation instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)accessoperation).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)accessoperation).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockAccessOperations(accessoperation, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateAccessOperations(AccessOperation accessoperation, HttpServletRequest req) throws Exception{
		if(accessoperation instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)accessoperation, false, getUserId(req));
		}
		if (isTimeoutReached(accessoperation)) {
			checkAccessOperations(accessoperation, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(accessoperation, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(AccessOperation accessoperation){
		if (accessoperation instanceof LockableObject) {
			LockableObject lock = (LockableObject)accessoperation;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(AccessOperation accessoperation, HttpServletRequest req){
		if (accessoperation instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)accessoperation;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
